/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileDimensionMemoize;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileIfNude
extends FtileDimensionMemoize {
    protected final Ftile tile1;
    protected final Ftile tile2;
    private final Swimlane in;

    FtileIfNude(Ftile tile1, Ftile tile2, Swimlane in) {
        super(tile1.shadowing() || tile2.shadowing());
        this.tile1 = tile1;
        this.tile2 = tile2;
        this.in = in;
    }

    public boolean hasTwoBranches(StringBounder stringBounder) {
        return this.tile1.calculateDimension(stringBounder).hasPointOut() && this.tile2.calculateDimension(stringBounder).hasPointOut();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        result.addAll(this.tile1.getSwimlanes());
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.in;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    protected UTranslate getTranslate1(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        double x1 = 0.0;
        double y1 = 0.0;
        return new UTranslate(0.0, 0.0);
    }

    protected UTranslate getTranslate2(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        double x2 = dimTotal.getWidth() - ((Dimension2D)dim2).getWidth();
        double y2 = 0.0;
        return new UTranslate(x2, 0.0);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile1) {
            return this.getTranslate1(stringBounder);
        }
        if (child == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslate1(stringBounder)).draw(this.tile1);
        ug.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        if (this.tile1.calculateDimension(stringBounder).hasPointOut() || this.tile2.calculateDimension(stringBounder).hasPointOut()) {
            return new FtileGeometry(dimTotal, this.getLeft(stringBounder), 0.0, dimTotal.getHeight());
        }
        return new FtileGeometry(dimTotal, this.getLeft(stringBounder), 0.0);
    }

    @Override
    protected Dimension2D calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        double width = dim1.getLeft() + this.withInner(stringBounder) + (dim2.getWidth() - dim2.getLeft());
        Dimension2D dim12 = Dimension2DDouble.mergeLR(dim1, dim2);
        return new Dimension2DDouble(width, dim12.getHeight());
    }

    protected double withInner(StringBounder stringBounder) {
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        return dim1.getWidth() - dim1.getLeft() + dim2.getLeft();
    }

    protected double getLeft(StringBounder stringBounder) {
        double left1 = this.tile1.calculateDimension(stringBounder).translate(this.getTranslate1(stringBounder)).getLeft();
        double left2 = this.tile2.calculateDimension(stringBounder).translate(this.getTranslate2(stringBounder)).getLeft();
        return (left1 + left2) / 2.0;
    }
}

