/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithDiamonds;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ConditionalBuilder {
    private final Swimlane swimlane;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final UFont fontArrow;
    private final UFont fontTest;
    private final HtmlColor arrowColor;
    private final FtileFactory ftileFactory;
    private final ConditionStyle conditionStyle;
    private final Branch branch1;
    private final Branch branch2;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final Ftile tile1;
    private final Ftile tile2;

    public ConditionalBuilder(Swimlane swimlane, HtmlColor borderColor, HtmlColor backColor, UFont fontArrow, UFont fontTest, HtmlColor arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch1, Branch branch2, ISkinParam skinParam, StringBounder stringBounder) {
        this.swimlane = swimlane;
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.fontArrow = fontArrow;
        this.fontTest = fontTest;
        this.arrowColor = arrowColor;
        this.ftileFactory = ftileFactory;
        this.conditionStyle = conditionStyle;
        this.branch1 = branch1;
        this.branch2 = branch2;
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.tile1 = new FtileMinWidth(branch1.getFtile(), 30.0);
        this.tile2 = new FtileMinWidth(branch2.getFtile(), 30.0);
    }

    public static Ftile create(Swimlane swimlane, HtmlColor borderColor, HtmlColor backColor, UFont fontArrow, UFont fontTest, HtmlColor arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch1, Branch branch2, ISkinParam skinParam, StringBounder stringBounder) {
        ConditionalBuilder builder = new ConditionalBuilder(swimlane, borderColor, backColor, fontArrow, fontTest, arrowColor, ftileFactory, conditionStyle, branch1, branch2, skinParam, stringBounder);
        return builder.createWithLinks();
    }

    private Ftile createNude() {
        return new FtileIfNude(this.tile1, this.tile2, this.swimlane);
    }

    private Ftile createWithDiamonds() {
        Ftile diamond1 = this.getDiamond1();
        Ftile diamond2 = this.getDiamond2();
        return new FtileIfWithDiamonds(diamond1, this.tile1, this.tile2, diamond2, this.swimlane, this.stringBounder);
    }

    private Ftile createWithLinks() {
        Ftile diamond1 = this.getDiamond1();
        Ftile diamond2 = this.getDiamond2();
        Ftile tmp1 = FtileUtils.addHorizontalMargin(this.tile1, 10.0);
        Ftile tmp2 = FtileUtils.addHorizontalMargin(this.tile2, 10.0);
        return new FtileIfWithLinks(diamond1, tmp1, tmp2, diamond2, this.swimlane, this.arrowColor, this.stringBounder).addLinks(this.branch1, this.branch2, this.stringBounder);
    }

    private Ftile getDiamond1() {
        AbstractFtile diamond1;
        Display labelTest = this.branch1.getLabelTest();
        FontConfiguration fcArrow = this.fcArrow();
        TextBlock tb1 = this.branch1.getLabelPositive().create(fcArrow, HorizontalAlignment.LEFT, this.ftileFactory, CreoleMode.SIMPLE_LINE);
        TextBlock tb2 = this.branch2.getLabelPositive().create(fcArrow, HorizontalAlignment.LEFT, this.ftileFactory, CreoleMode.SIMPLE_LINE);
        FontConfiguration fcTest = new FontConfiguration(this.fontTest, this.fontColor(), this.skinParam.getHyperlinkColor(), this.skinParam.useUnderlineForHyperlink());
        Sheet sheet = new CreoleParser(fcTest, HorizontalAlignment.LEFT, this.skinParam, CreoleMode.FULL).createSheet(labelTest);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, 0.0, this.skinParam.getPadding());
        SheetBlock2 tbTest = new SheetBlock2(sheetBlock1, Diamond.asStencil(sheetBlock1), new UStroke(1.5));
        if (this.conditionStyle == ConditionStyle.INSIDE) {
            diamond1 = new FtileDiamondInside(this.tile1.shadowing(), this.backColor, this.borderColor, this.swimlane, tbTest).withWest(tb1).withEast(tb2);
        } else if (this.conditionStyle == ConditionStyle.DIAMOND) {
            diamond1 = new FtileDiamond(this.tile1.shadowing(), this.backColor, this.borderColor, this.swimlane).withWest(tb1).withEast(tb2).withNorth(tbTest);
        } else {
            throw new IllegalStateException();
        }
        return diamond1;
    }

    private Ftile getDiamond2() {
        AbstractFtile diamond2;
        FontConfiguration fcArrow = this.fcArrow();
        if (this.hasTwoBranches()) {
            Display out1 = LinkRendering.getDisplay(this.branch1.getFtile().getOutLinkRendering());
            TextBlock tbout1 = out1 == null ? null : out1.create(fcArrow, HorizontalAlignment.LEFT, this.ftileFactory, CreoleMode.SIMPLE_LINE);
            Display out2 = LinkRendering.getDisplay(this.branch2.getFtile().getOutLinkRendering());
            TextBlock tbout2 = out2 == null ? null : out2.create(fcArrow, HorizontalAlignment.LEFT, this.ftileFactory, CreoleMode.SIMPLE_LINE);
            diamond2 = new FtileDiamond(this.tile1.shadowing(), this.backColor, this.borderColor, this.swimlane).withWest(tbout1).withEast(tbout2);
        } else {
            diamond2 = new FtileEmpty(this.tile1.shadowing(), 0.0, 6.0, this.swimlane, this.swimlane);
        }
        return diamond2;
    }

    public boolean hasTwoBranches() {
        return this.tile1.calculateDimension(this.stringBounder).hasPointOut() && this.tile2.calculateDimension(this.stringBounder).hasPointOut();
    }

    private FontConfiguration fcArrow() {
        return new FontConfiguration(this.fontArrow, this.fontColor(), this.skinParam.getHyperlinkColor(), this.skinParam.useUnderlineForHyperlink());
    }

    private HtmlColor fontColor() {
        return this.skinParam.getFontHtmlColor(FontParam.ACTIVITY_DIAMOND, null);
    }
}

