/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixed;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBlackBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileFactoryDelegatorCreateFork
extends FtileFactoryDelegator {
    private final double spaceArroundBlackBar = 20.0;
    private final double barHeight = 6.0;
    private final double xMargin = 14.0;
    private final Rose rose = new Rose();

    public FtileFactoryDelegatorCreateFork(FtileFactory factory, ISkinParam skinParam) {
        super(factory, skinParam);
    }

    @Override
    public Ftile createFork(Swimlane swimlane, List<Ftile> all) {
        HtmlColor colorBar = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityBar);
        HtmlColor arrowColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
        FtileGeometry dimSuper = super.createFork(swimlane, all).calculateDimension(this.getStringBounder());
        double height1 = ((Dimension2D)dimSuper).getHeight() + 40.0;
        ArrayList<Ftile> list = new ArrayList<Ftile>();
        for (Ftile tmp : all) {
            list.add(new FtileHeightFixed(new FtileMarged(tmp, 14.0), height1));
        }
        Ftile inner = super.createFork(swimlane, list);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        FtileBlackBlock black = new FtileBlackBlock(this.shadowing(), colorBar, ((Ftile)list.get(0)).getSwimlaneIn());
        double x = 0.0;
        for (Ftile tmp : list) {
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            conns.add(new ConnectionIn(black, tmp, x, arrowColor));
            conns.add(new ConnectionOut(tmp, black, x, arrowColor, height1));
            x += ((Dimension2D)dim).getWidth();
        }
        inner = FtileUtils.addConnection(inner, conns);
        black.setDimenstion(inner.calculateDimension(this.getStringBounder()).getWidth(), 6.0);
        FtileAssemblySimple tmp1 = new FtileAssemblySimple(black, inner);
        return new FtileAssemblySimple(tmp1, black);
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final HtmlColor arrowColor;
        private final double height;

        public ConnectionOut(Ftile ftile1, Ftile ftile2, double x, HtmlColor arrowColor, double height) {
            super(ftile1, ftile2);
            this.x = x;
            this.arrowColor = arrowColor;
            this.height = height;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile1().calculateDimension(FtileFactoryDelegatorCreateFork.this.getStringBounder());
            if (!geo.hasPointOut()) {
                return;
            }
            Snake s = new Snake(this.arrowColor, Arrows.asToDown());
            s.addPoint(geo.getLeft(), geo.getOutY());
            s.addPoint(geo.getLeft(), this.height);
            ug.draw(s);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile1().calculateDimension(FtileFactoryDelegatorCreateFork.this.getStringBounder());
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D.Double p1 = new Point2D.Double(geo.getLeft(), geo.getOutY());
            Point2D.Double p2 = new Point2D.Double(geo.getLeft(), this.height);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            double middle = mp2b.getY() - 14.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final HtmlColor arrowColor;

        public ConnectionIn(Ftile ftile1, Ftile ftile2, double x, HtmlColor arrowColor) {
            super(ftile1, ftile2);
            this.x = x;
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile2().calculateDimension(FtileFactoryDelegatorCreateFork.this.getStringBounder());
            Snake s = new Snake(this.arrowColor, Arrows.asToDown());
            s.addPoint(geo.getLeft(), 0.0);
            s.addPoint(geo.getLeft(), geo.getInY());
            ug.draw(s);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile2().calculateDimension(FtileFactoryDelegatorCreateFork.this.getStringBounder());
            Point2D.Double p1 = new Point2D.Double(geo.getLeft(), 0.0);
            Point2D.Double p2 = new Point2D.Double(geo.getLeft(), geo.getInY());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            double middle = mp1a.getY() + 4.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }
}

