/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionWhile
implements Instruction {
    private final InstructionList repeatList = new InstructionList();
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final HtmlColor color;
    private final Display test;
    private final Display yes;
    private Display out = Display.NULL;
    private LinkRendering endInlinkRendering;
    private LinkRendering afterEndwhile;
    private final Swimlane swimlane;
    private final ISkinParam skinParam;
    private Display note;
    private NotePosition position;

    public InstructionWhile(Swimlane swimlane, Instruction parent, Display test, LinkRendering nextLinkRenderer, Display yes, HtmlColor color, ISkinParam skinParam) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        if (yes == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.test = test;
        this.nextLinkRenderer = nextLinkRenderer;
        this.yes = yes;
        this.swimlane = swimlane;
        this.color = color;
        this.skinParam = skinParam;
    }

    @Override
    public void add(Instruction ins) {
        this.repeatList.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile tmp = factory.decorateOut(this.repeatList.createFtile(factory), this.endInlinkRendering);
        tmp = factory.createWhile(this.swimlane, tmp, this.test, this.yes, this.out, this.afterEndwhile, this.color);
        if (this.note != null) {
            tmp = new FtileWithNoteOpale(tmp, this.note, this.position, this.skinParam, false);
        }
        return tmp;
    }

    public Instruction getParent() {
        return this.parent;
    }

    @Override
    public final boolean kill() {
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    public void endwhile(LinkRendering nextLinkRenderer, Display out) {
        this.endInlinkRendering = nextLinkRenderer;
        this.out = out;
        if (out == null) {
            throw new IllegalArgumentException();
        }
    }

    public void afterEndwhile(LinkRendering linkRenderer) {
        this.afterEndwhile = linkRenderer;
    }

    @Override
    public void addNote(Display note, NotePosition position) {
        if (this.repeatList.isEmpty()) {
            this.note = note;
            this.position = position;
        } else {
            this.repeatList.addNote(note, position);
        }
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }
}

