/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collection;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class Branch {
    private final InstructionList list;
    private final Display labelTest;
    private final Display labelPositive;
    private final HtmlColor color;
    private LinkRendering inlinkRendering;
    private Ftile ftile;

    public boolean isOnlySingleStop() {
        return this.list.isOnlySingleStop();
    }

    public Branch(Swimlane swimlane, Display labelPositive, Display labelTest, HtmlColor color) {
        if (labelPositive == null) {
            throw new IllegalArgumentException();
        }
        if (labelTest == null) {
            throw new IllegalArgumentException();
        }
        this.list = new InstructionList(swimlane);
        this.labelTest = labelTest;
        this.labelPositive = labelPositive;
        this.color = color;
    }

    public void add(Instruction ins) {
        this.list.add(ins);
    }

    public boolean kill() {
        return this.list.kill();
    }

    public void addNote(Display note, NotePosition position) {
        this.list.addNote(note, position);
    }

    public final void setInlinkRendering(LinkRendering inlinkRendering) {
        this.inlinkRendering = inlinkRendering;
    }

    public void updateFtile(FtileFactory factory) {
        this.ftile = factory.decorateOut(this.list.createFtile(factory), this.inlinkRendering);
    }

    public Collection<? extends Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    public final Display getLabelPositive() {
        LinkRendering in = this.ftile.getInLinkRendering();
        if (in != null && !Display.isNull(in.getDisplay())) {
            return in.getDisplay();
        }
        return this.labelPositive;
    }

    public final Display getLabelTest() {
        return this.labelTest;
    }

    public final HtmlColor getInlinkRenderingColor() {
        return this.inlinkRendering == null ? null : this.inlinkRendering.getColor();
    }

    public final Ftile getFtile() {
        return this.ftile;
    }

    public boolean shadowing() {
        return this.ftile.shadowing();
    }

    public final HtmlColor getColor() {
        return this.color;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

