/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;

public class SourceFileReader
implements ISourceFileReader {
    private final File file;
    private final File outputDirectory;
    private final BlockUmlBuilder builder;
    private FileFormatOption fileFormatOption;

    public SourceFileReader(File file) throws IOException {
        this(file, file.getAbsoluteFile().getParentFile());
    }

    public SourceFileReader(File file, File outputDirectory, String charset) throws IOException {
        this(new Defines(), file, outputDirectory, Collections.emptyList(), charset, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File outputDirectory) throws IOException {
        this(new Defines(), file, outputDirectory, Collections.emptyList(), null, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File outputDirectory, FileFormatOption fileFormatOption) throws IOException {
        this(new Defines(), file, outputDirectory, Collections.emptyList(), null, fileFormatOption);
    }

    public SourceFileReader(Defines defines, File file, File outputDirectory, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        if (outputDirectory == null) {
            outputDirectory = file.getAbsoluteFile().getParentFile();
        } else if (!outputDirectory.isAbsolute()) {
            outputDirectory = FileSystem.getInstance().getFile(outputDirectory.getPath());
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        this.outputDirectory = outputDirectory;
        this.builder = new BlockUmlBuilder(config, charset, defines, this.getReader(charset), file.getAbsoluteFile().getParentFile(), file.getAbsolutePath());
    }

    @Override
    public boolean hasError() {
        for (BlockUml b : this.builder.getBlockUmls()) {
            if (!(b.getDiagram() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GeneratedImage> getGeneratedImages() throws IOException {
        Log.info("Reading file: " + this.file);
        int cpt = 0;
        ArrayList<GeneratedImage> result = new ArrayList<GeneratedImage>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            String newName = blockUml.getFilename();
            if (newName == null) {
                newName = this.fileFormatOption.getFileFormat().changeName(this.file.getName(), cpt++);
            }
            File suggested = new File(this.outputDirectory, newName);
            suggested.getParentFile().mkdirs();
            Diagram system = blockUml.getDiagram();
            List<File> exportDiagrams = PSystemUtils.exportDiagrams(system, suggested, this.fileFormatOption);
            OptionFlags.getInstance().logData(this.file, system);
            for (File f : exportDiagrams) {
                String warnOrError;
                String desc = "[" + this.file.getName() + "] " + system.getDescription();
                if (OptionFlags.getInstance().isWord() && (warnOrError = system.getWarningOrError()) != null) {
                    String name = f.getName().substring(0, f.getName().length() - 4) + ".err";
                    File errorFile = new File(f.getParentFile(), name);
                    PrintStream ps = new PrintStream(new FileOutputStream(errorFile));
                    ps.print(warnOrError);
                    ps.close();
                }
                GeneratedImage generatedImage = new GeneratedImage(f, desc, blockUml);
                result.add(generatedImage);
            }
        }
        Log.info("Number of image(s): " + result.size());
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<String> getEncodedUrl() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            String source = blockUml.getDiagram().getSource().getPlainString();
            String encoded = transcoder.encode(source);
            result.add(encoded);
        }
        return Collections.unmodifiableList(result);
    }

    private Reader getReader(String charset) throws FileNotFoundException, UnsupportedEncodingException {
        if (charset == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(this.file));
        }
        Log.info("Using charset " + charset);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), charset);
    }

    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public final Set<File> getIncludedFiles() {
        return this.builder.getIncludedFiles();
    }
}

