/* pamac.h generated by valac 0.34.6, the Vala compiler, do not modify */


#ifndef __PAMAC_H__
#define __PAMAC_H__

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <alpm.h>
#include <float.h>
#include <math.h>
#include <alpm_list.h>
#include <alpm-util.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

G_BEGIN_DECLS


#define PAMAC_TYPE_PACKAGE_INFOS (pamac_package_infos_get_type ())
typedef struct _PamacPackageInfos PamacPackageInfos;

#define PAMAC_TYPE_UPDATES (pamac_updates_get_type ())
typedef struct _PamacUpdates PamacUpdates;

#define PAMAC_TYPE_ERROR_INFOS (pamac_error_infos_get_type ())
typedef struct _PamacErrorInfos PamacErrorInfos;
typedef struct _PamacConfig PamacConfig;
typedef struct _AlpmRepo AlpmRepo;
typedef struct _AlpmConfig AlpmConfig;

#define PAMAC_TYPE_MODE (pamac_mode_get_type ())

#define PAMAC_TYPE_TRANSACTION (pamac_transaction_get_type ())
#define PAMAC_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_TRANSACTION, PamacTransaction))
#define PAMAC_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_TRANSACTION, PamacTransactionClass))
#define PAMAC_IS_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_TRANSACTION))
#define PAMAC_IS_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_TRANSACTION))
#define PAMAC_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_TRANSACTION, PamacTransactionClass))

typedef struct _PamacTransaction PamacTransaction;
typedef struct _PamacTransactionClass PamacTransactionClass;
typedef struct _PamacTransactionPrivate PamacTransactionPrivate;

#define TYPE_ALPM_UTILS (alpm_utils_get_type ())
#define ALPM_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_UTILS, AlpmUtils))
#define ALPM_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_UTILS, AlpmUtilsClass))
#define IS_ALPM_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_UTILS))
#define IS_ALPM_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_UTILS))
#define ALPM_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_UTILS, AlpmUtilsClass))

typedef struct _AlpmUtils AlpmUtils;
typedef struct _AlpmUtilsClass AlpmUtilsClass;
typedef struct _AlpmUtilsPrivate AlpmUtilsPrivate;
typedef struct _PamacMirrorsConfig PamacMirrorsConfig;

struct _PamacPackageInfos {
	gchar* name;
	gchar* version;
	gchar* db_name;
	guint64 download_size;
};

struct _PamacUpdates {
	gboolean is_syncfirst;
	PamacPackageInfos* repos_updates;
	gint repos_updates_length1;
	PamacPackageInfos* aur_updates;
	gint aur_updates_length1;
};

struct _PamacErrorInfos {
	guint errno;
	gchar* message;
	gchar** details;
	gint details_length1;
};

struct _PamacConfig {
	gchar* conf_path;
	gboolean recurse;
	guint64 refresh_period;
	gboolean no_update_hide_icon;
	gboolean enable_aur;
	gboolean search_aur;
	gboolean check_aur_updates;
	gboolean no_confirm_build;
	GHashTable* environment_variables;
};

struct _AlpmRepo {
	gchar* name;
	alpm_siglevel_t siglevel;
	alpm_siglevel_t siglevel_mask;
	alpm_db_usage_t usage;
	GList* urls;
};

struct _AlpmConfig {
	gchar* conf_path;
	gchar* rootdir;
	gchar* dbpath;
	gchar* logfile;
	gchar* gpgdir;
	gchar* arch;
	gdouble deltaratio;
	gint usesyslog;
	gint checkspace;
	alpm_list_t* cachedirs;
	alpm_list_t* hookdirs;
	alpm_list_t* ignoregroups;
	alpm_list_t* ignorepkgs;
	alpm_list_t* noextracts;
	alpm_list_t* noupgrades;
	GList* holdpkgs;
	GList* syncfirsts;
	alpm_siglevel_t siglevel;
	alpm_siglevel_t localfilesiglevel;
	alpm_siglevel_t remotefilesiglevel;
	alpm_siglevel_t siglevel_mask;
	alpm_siglevel_t localfilesiglevel_mask;
	alpm_siglevel_t remotefilesiglevel_mask;
	GList* repo_order;
	alpm_handle_t* handle;
};

typedef enum  {
	PAMAC_MODE_MANAGER,
	PAMAC_MODE_UPDATER
} PamacMode;

struct _PamacTransaction {
	GObject parent_instance;
	PamacTransactionPrivate * priv;
	AlpmUtils* alpm_utils;
	PamacConfig* pamac_config;
	alpm_transflag_t flags;
	GHashTable* to_add;
	GHashTable* to_remove;
	GHashTable* to_load;
	GHashTable* to_build;
	GHashTable* temporary_ignorepkgs;
	PamacMode mode;
	GtkApplicationWindow* application_window;
};

struct _PamacTransactionClass {
	GObjectClass parent_class;
};

struct _AlpmUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlpmUtilsPrivate * priv;
};

struct _AlpmUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (AlpmUtils *self);
};

struct _PamacMirrorsConfig {
	gchar* conf_path;
	gchar* mirrorlists_dir;
	gchar* choosen_generation_method;
	gchar* choosen_country;
	GList* countrys;
};


GType pamac_package_infos_get_type (void) G_GNUC_CONST;
PamacPackageInfos* pamac_package_infos_dup (const PamacPackageInfos* self);
void pamac_package_infos_free (PamacPackageInfos* self);
void pamac_package_infos_copy (const PamacPackageInfos* self, PamacPackageInfos* dest);
void pamac_package_infos_destroy (PamacPackageInfos* self);
GType pamac_updates_get_type (void) G_GNUC_CONST;
PamacUpdates* pamac_updates_dup (const PamacUpdates* self);
void pamac_updates_free (PamacUpdates* self);
void pamac_updates_copy (const PamacUpdates* self, PamacUpdates* dest);
void pamac_updates_destroy (PamacUpdates* self);
GType pamac_error_infos_get_type (void) G_GNUC_CONST;
PamacErrorInfos* pamac_error_infos_dup (const PamacErrorInfos* self);
void pamac_error_infos_free (PamacErrorInfos* self);
void pamac_error_infos_copy (const PamacErrorInfos* self, PamacErrorInfos* dest);
void pamac_error_infos_destroy (PamacErrorInfos* self);
void pamac_error_infos_init (PamacErrorInfos *self);
void pamac_config_free (PamacConfig* self);
PamacConfig* pamac_config_new (const gchar* path);
void pamac_config_reload (PamacConfig* self);
void pamac_config_parse_file (PamacConfig* self, const gchar* path);
void pamac_config_write (PamacConfig* self, GHashTable* new_conf);
void alpm_repo_free (AlpmRepo* self);
AlpmRepo* alpm_repo_new (const gchar* name);
gint alpm_repo_compare_name (AlpmRepo* a, AlpmRepo* b);
gint alpm_repo_search_name (AlpmRepo* a, const gchar* name);
void alpm_config_free (AlpmConfig* self);
AlpmConfig* alpm_config_new (const gchar* path);
void alpm_config_reload (AlpmConfig* self);
void alpm_config_set_handle (AlpmConfig* self);
void alpm_config_parse_file (AlpmConfig* self, const gchar* path, const gchar* section);
void alpm_config_write (AlpmConfig* self, GHashTable* new_conf);
alpm_db_usage_t alpm_config_define_usage (AlpmConfig* self, const gchar* conf_string);
void alpm_config_process_siglevel (AlpmConfig* self, const gchar* conf_string, alpm_siglevel_t* siglevel, alpm_siglevel_t* siglevel_mask);
alpm_siglevel_t alpm_config_merge_siglevel (AlpmConfig* self, alpm_siglevel_t sigbase, alpm_siglevel_t sigover, alpm_siglevel_t sigmask);
GType pamac_mode_get_type (void) G_GNUC_CONST;
GType pamac_transaction_get_type (void) G_GNUC_CONST;
gpointer alpm_utils_ref (gpointer instance);
void alpm_utils_unref (gpointer instance);
GParamSpec* param_spec_alpm_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alpm_utils (GValue* value, gpointer v_object);
void value_take_alpm_utils (GValue* value, gpointer v_object);
gpointer value_get_alpm_utils (const GValue* value);
GType alpm_utils_get_type (void) G_GNUC_CONST;
PamacTransaction* pamac_transaction_new (GtkApplicationWindow* application_window);
PamacTransaction* pamac_transaction_construct (GType object_type, GtkApplicationWindow* application_window);
void pamac_transaction_run_preferences_dialog (PamacTransaction* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void pamac_transaction_run_preferences_dialog_finish (PamacTransaction* self, GAsyncResult* _res_);
void pamac_transaction_get_current_error (PamacTransaction* self, PamacErrorInfos* result);
void pamac_transaction_start_get_authorization (PamacTransaction* self);
void pamac_transaction_start_write_pamac_config (PamacTransaction* self, GHashTable* new_pamac_conf);
void pamac_transaction_start_write_alpm_config (PamacTransaction* self, GHashTable* new_alpm_conf);
void pamac_transaction_start_write_mirrors_config (PamacTransaction* self, GHashTable* new_mirrors_conf);
void pamac_transaction_start_generate_mirrors_list (PamacTransaction* self);
void pamac_transaction_start_set_pkgreason (PamacTransaction* self, const gchar* pkgname, alpm_pkgreason_t reason);
void pamac_transaction_start_refresh (PamacTransaction* self, gboolean force);
void pamac_transaction_start_get_updates (PamacTransaction* self);
void pamac_transaction_add_ignorepkg (PamacTransaction* self, const gchar* pkgname);
void pamac_transaction_remove_ignorepkg (PamacTransaction* self, const gchar* pkgname);
gboolean pamac_transaction_init (PamacTransaction* self, alpm_transflag_t flags);
void pamac_transaction_sysupgrade (PamacTransaction* self, gboolean enable_downgrade);
void pamac_transaction_clear_lists (PamacTransaction* self);
void pamac_transaction_run (PamacTransaction* self);
void pamac_transaction_start_commit (PamacTransaction* self);
void pamac_transaction_build_aur_packages (PamacTransaction* self);
void pamac_transaction_get_aur_infos (PamacTransaction* self, const gchar* aur_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonObject* pamac_transaction_get_aur_infos_finish (PamacTransaction* self, GAsyncResult* _res_);
void pamac_transaction_cancel (PamacTransaction* self);
void pamac_transaction_release (PamacTransaction* self);
void pamac_transaction_stop_daemon (PamacTransaction* self);
gint alpm_pkg_compare_name (alpm_pkg_t* pkg_a, alpm_pkg_t* pkg_b);
gint alpm_pkg_compare_origin (alpm_pkg_t* pkg_a, alpm_pkg_t* pkg_b);
gint alpm_pkg_compare_version (alpm_pkg_t* pkg_a, alpm_pkg_t* pkg_b);
gint alpm_pkg_compare_db_name (alpm_pkg_t* pkg_a, alpm_pkg_t* pkg_b);
gint alpm_pkg_compare_installed_size (alpm_pkg_t* pkg_a, alpm_pkg_t* pkg_b);
AlpmUtils* alpm_utils_new (const gchar* conf_file_path);
AlpmUtils* alpm_utils_construct (GType object_type, const gchar* conf_file_path);
gboolean alpm_utils_reload (AlpmUtils* self);
gint alpm_utils_get_checkspace (AlpmUtils* self);
GList* alpm_utils_get_holdpkgs (AlpmUtils* self);
alpm_list_t* alpm_utils_get_ignorepkgs (AlpmUtils* self);
alpm_pkg_t* alpm_utils_get_installed_pkg (AlpmUtils* self, const gchar* pkg_name);
alpm_pkg_t* alpm_utils_get_sync_pkg (AlpmUtils* self, const gchar* pkg_name);
alpm_db_t* alpm_utils_get_localdb (AlpmUtils* self);
alpm_list_t* alpm_utils_get_syncdbs (AlpmUtils* self);
alpm_list_t* alpm_utils_search_all_dbs (AlpmUtils* self, const gchar* search_string);
alpm_list_t* alpm_utils_get_group_pkgs (AlpmUtils* self, const gchar* group_name);
alpm_list_t* alpm_utils_get_installed_pkgs (AlpmUtils* self);
alpm_list_t* alpm_utils_get_orphans (AlpmUtils* self);
alpm_list_t* alpm_utils_get_local_pkgs (AlpmUtils* self);
alpm_list_t* alpm_utils_get_repo_pkgs (AlpmUtils* self, const gchar* repo_name);
alpm_list_t* alpm_utils_get_all_pkgs (AlpmUtils* self);
JsonArray* aur_search (gchar** needles, int needles_length1);
JsonArray* aur_multiinfo (gchar** pkgnames, int pkgnames_length1);
void pamac_mirrors_config_free (PamacMirrorsConfig* self);
PamacMirrorsConfig* pamac_mirrors_config_new (const gchar* path);
void pamac_mirrors_config_reload (PamacMirrorsConfig* self);
void pamac_mirrors_config_get_countrys (PamacMirrorsConfig* self);
void pamac_mirrors_config_parse_file (PamacMirrorsConfig* self, const gchar* path);
void pamac_mirrors_config_write (PamacMirrorsConfig* self, GHashTable* new_conf);


G_END_DECLS

#endif
