#ifndef _ENVENTOR_OBJECT_EO_H_
#define _ENVENTOR_OBJECT_EO_H_

#ifndef _ENVENTOR_OBJECT_EO_CLASS_TYPE
#define _ENVENTOR_OBJECT_EO_CLASS_TYPE

typedef Eo Enventor_Object;

#endif

#ifndef _ENVENTOR_OBJECT_EO_TYPES
#define _ENVENTOR_OBJECT_EO_TYPES


#endif
#define ENVENTOR_OBJECT_CLASS enventor_object_class_get()

EAPI const Eo_Class *enventor_object_class_get(void) EINA_CONST;

EOAPI void enventor_obj_part_highlight_set(Eina_Bool part_highlight);

EOAPI Eina_Bool enventor_obj_part_highlight_get(void);

EOAPI void enventor_obj_live_view_scale_set(double scale);

EOAPI double enventor_obj_live_view_scale_get(void);

EOAPI void enventor_obj_dummy_parts_set(Eina_Bool dummy_parts);

EOAPI Eina_Bool enventor_obj_dummy_parts_get(void);

EOAPI void enventor_obj_auto_complete_set(Eina_Bool auto_complete);

EOAPI Eina_Bool enventor_obj_auto_complete_get(void);

EOAPI void enventor_obj_auto_indent_set(Eina_Bool auto_indent);

EOAPI Eina_Bool enventor_obj_auto_indent_get(void);

EOAPI void enventor_obj_ctxpopup_set(Eina_Bool ctxpopup);

EOAPI Eina_Bool enventor_obj_ctxpopup_get(void);

EOAPI void enventor_obj_focus_set(Eina_Bool focus);

EOAPI Eina_Bool enventor_obj_focus_get(void);

EOAPI void enventor_obj_modified_set(Eina_Bool modified);

EOAPI Eina_Bool enventor_obj_modified_get(void);

EOAPI void enventor_obj_font_scale_set(double font_scale);

EOAPI double enventor_obj_font_scale_get(void);

EOAPI void enventor_obj_linenumber_set(Eina_Bool linenumber);

EOAPI Eina_Bool enventor_obj_linenumber_get(void);

EOAPI void enventor_obj_smart_undo_redo_set(Eina_Bool smart_undo_redo);

EOAPI Eina_Bool enventor_obj_smart_undo_redo_get(void);

EOAPI Eina_Bool enventor_obj_path_set(Enventor_Path_Type type, const Eina_List *pathes);

EOAPI const Eina_List *enventor_obj_path_get(Enventor_Path_Type type);

EOAPI Eina_List *enventor_obj_programs_list_get(void);

EOAPI Eina_List *enventor_obj_part_states_list_get(const char *type);

EOAPI Eina_List *enventor_obj_parts_list_get(void);

EOAPI int enventor_obj_max_line_get(void);

EOAPI const char *enventor_obj_text_get(void);

EOAPI void enventor_obj_text_insert(const char *text);

EOAPI const char *enventor_obj_selection_get(void);

EOAPI int enventor_obj_cursor_pos_get(void);

EOAPI void enventor_obj_cursor_pos_set(int position);

EOAPI void enventor_obj_select_none(void);

EOAPI void enventor_obj_select_region_set(int start, int end);

EOAPI void enventor_obj_line_delete(void);

EOAPI Eina_Bool enventor_obj_save(const char *file);

EOAPI Eo *enventor_obj_live_view_get(void);

EOAPI void enventor_obj_line_goto(int line);

EOAPI void enventor_obj_syntax_color_set(Enventor_Syntax_Color_Type color_type, const char *val);

EOAPI const char *enventor_obj_syntax_color_get(Enventor_Syntax_Color_Type color_type);

EOAPI void enventor_obj_syntax_color_full_apply(Eina_Bool force);

EOAPI void enventor_obj_syntax_color_partial_apply(double interval);

EOAPI Eina_Bool enventor_obj_template_insert(Enventor_Template_Insert_Type insert_type, char *syntax, size_t n);

EOAPI Eina_Bool enventor_obj_template_part_insert(Edje_Part_Type type, Enventor_Template_Insert_Type insert_type, float rel1_x, float rel1_y, float rel2_x, float rel2_y, char *syntax, size_t n);

EOAPI Eina_Bool enventor_obj_ctxpopup_visible_get(void);

EOAPI void enventor_obj_ctxpopup_dismiss(void);

EOAPI void enventor_obj_disabled_set(Eina_Bool disabled);

EOAPI void enventor_obj_live_view_size_set(Evas_Coord w, Evas_Coord h);

EOAPI void enventor_obj_live_view_size_get(Evas_Coord *w, Evas_Coord *h);

EOAPI Edje_Part_Type enventor_obj_part_type_get(const char *part_name);

EOAPI Eina_Bool enventor_obj_redo(void);

EOAPI Eina_Bool enventor_obj_undo(void);

EOAPI void enventor_obj_font_set(const char *font_name, const char *font_style);

EOAPI void enventor_obj_font_get(const char **font_name, const char **font_style);

EOAPI void enventor_obj_auto_complete_list_show(void);

EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_CURSOR_LINE_CHANGED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_CURSOR_GROUP_CHANGED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_LIVE_VIEW_UPDATED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_LIVE_VIEW_LOADED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_LIVE_VIEW_CURSOR_MOVED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_LIVE_VIEW_RESIZED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_MAX_LINE_CHANGED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_COMPILE_ERROR;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_PROGRAM_RUN;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_CTXPOPUP_ACTIVATED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_CTXPOPUP_CHANGED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_CTXPOPUP_DISMISSED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_EDC_MODIFIED;
EOAPI extern const Eo_Event_Description _ENVENTOR_OBJECT_EVENT_FOCUSED;

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_CURSOR_LINE_CHANGED (&(_ENVENTOR_OBJECT_EVENT_CURSOR_LINE_CHANGED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_CURSOR_GROUP_CHANGED (&(_ENVENTOR_OBJECT_EVENT_CURSOR_GROUP_CHANGED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_LIVE_VIEW_UPDATED (&(_ENVENTOR_OBJECT_EVENT_LIVE_VIEW_UPDATED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_LIVE_VIEW_LOADED (&(_ENVENTOR_OBJECT_EVENT_LIVE_VIEW_LOADED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_LIVE_VIEW_CURSOR_MOVED (&(_ENVENTOR_OBJECT_EVENT_LIVE_VIEW_CURSOR_MOVED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_LIVE_VIEW_RESIZED (&(_ENVENTOR_OBJECT_EVENT_LIVE_VIEW_RESIZED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_MAX_LINE_CHANGED (&(_ENVENTOR_OBJECT_EVENT_MAX_LINE_CHANGED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_COMPILE_ERROR (&(_ENVENTOR_OBJECT_EVENT_COMPILE_ERROR))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_PROGRAM_RUN (&(_ENVENTOR_OBJECT_EVENT_PROGRAM_RUN))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_CTXPOPUP_ACTIVATED (&(_ENVENTOR_OBJECT_EVENT_CTXPOPUP_ACTIVATED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_CTXPOPUP_CHANGED (&(_ENVENTOR_OBJECT_EVENT_CTXPOPUP_CHANGED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_CTXPOPUP_DISMISSED (&(_ENVENTOR_OBJECT_EVENT_CTXPOPUP_DISMISSED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_EDC_MODIFIED (&(_ENVENTOR_OBJECT_EVENT_EDC_MODIFIED))

/**
 * No description
 */
#define ENVENTOR_OBJECT_EVENT_FOCUSED (&(_ENVENTOR_OBJECT_EVENT_FOCUSED))

#endif
