#ifndef _ELM_CODE_WIDGET_EO_LEGACY_H_
#define _ELM_CODE_WIDGET_EO_LEGACY_H_

#ifndef _ELM_CODE_WIDGET_EO_CLASS_TYPE
#define _ELM_CODE_WIDGET_EO_CLASS_TYPE

typedef Eo Elm_Code_Widget;

#endif

#ifndef _ELM_CODE_WIDGET_EO_TYPES
#define _ELM_CODE_WIDGET_EO_TYPES


#endif

/**
 * @brief Set the underlying code object that this widget renders. This can
 * only be set during construction, once the widget is created the backing code
 * object cannot be changed.
 *
 * @param[in] code Our underlying Elm_Code object
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_code_set(Elm_Code_Widget *obj, Elm_Code *code);

/**
 * @brief Get the underlying code object we are rendering
 *
 * @return Our underlying Elm_Code object
 *
 * @ingroup Elm_Code_Widget
 */
EAPI Elm_Code *elm_code_widget_code_get(const Elm_Code_Widget *obj);

/**
 * @brief Set the font that this widget uses, the font should be a monospaced
 * scalable font. Passing NULL will load the default system monospaced font.
 *
 * @param[in] name The name of the font to load
 * @param[in] size The font size for the widget
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_font_set(Elm_Code_Widget *obj, const char *name, Evas_Font_Size size);

/**
 * @brief Get the font currently in use. The font name is a copy ad should be
 * freed once it is no longer needed
 *
 * @param[out] name The name of the font to load
 * @param[out] size The font size for the widget
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_font_get(const Elm_Code_Widget *obj, const char **name, Evas_Font_Size *size);

/**
 * @brief Set how this widget's scroller should respond to new lines being
 * added.
 *
 * An x value of 0.0 will maintain the distance from the left edge, 1.0 will
 * ensure the rightmost edge (of the longest line) is respected With 0.0 for y
 * the view will keep it's position relative to the top whereas 1.0 will scroll
 * downward as lines are added.
 *
 * @param[in] x The horizontal value of the scroller gravity - valid values are
 * 0.0 and 1.0
 * @param[in] y The vertical gravity of the widget's scroller - valid values
 * are 0.0 and 1.0
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_gravity_set(Elm_Code_Widget *obj, double x, double y);

/**
 * @brief Get the current x and y gravity of the widget's scroller
 *
 * @param[out] x The horizontal value of the scroller gravity - valid values
 * are 0.0 and 1.0
 * @param[out] y The vertical gravity of the widget's scroller - valid values
 * are 0.0 and 1.0
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_gravity_get(const Elm_Code_Widget *obj, double *x, double *y);

/**
 * @brief Set the policy for scrollbar visibility.
 *
 * @param[in] policy_h The horizontal scrollbar visibility policy
 * @param[in] policy_v The vertical scrollbar visibility policy
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_policy_set(Elm_Code_Widget *obj, Elm_Scroller_Policy policy_h, Elm_Scroller_Policy policy_v);

/**
 * @brief Get the widget's policy for scrollbar visibility.
 *
 * @param[out] policy_h The horizontal scrollbar visibility policy
 * @param[out] policy_v The vertical scrollbar visibility policy
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_policy_get(const Elm_Code_Widget *obj, Elm_Scroller_Policy *policy_h, Elm_Scroller_Policy *policy_v);

/**
 * @brief Set the width of a tab stop, used purely for visual layout of tab
 * characters.
 *
 * Recommended value is between 2 and 8.
 *
 * @param[in] tabstop Maximum width of a tab character
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_tabstop_set(Elm_Code_Widget *obj, unsigned int tabstop);

/**
 * @brief Get the current width of a tab stop. This is used to determine where
 * characters after a tab should appear in the line.
 *
 * @return Maximum width of a tab character
 *
 * @ingroup Elm_Code_Widget
 */
EAPI unsigned int elm_code_widget_tabstop_get(const Elm_Code_Widget *obj);

/**
 * @brief Set whether this widget allows editing
 *
 * If editable then the widget will allow user input to manipulate the
 * underlying Elm_Code_File of this Elm_Code instance. Any other
 * Elm_Code_Widget's connected to this Elm_Code will update to reflect the
 * changes.
 *
 * @param[in] editable The editable state of the widget
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_editable_set(Elm_Code_Widget *obj, Eina_Bool editable);

/**
 * @brief Get the current editable state of this widget
 *
 * returns EINA_TRUE if the widget is editable, EINA_FALSE otherwise. If this
 * widget is not editable the underlying Elm_Code_File could still be
 * manipulated by a different widget or the filesystem.
 *
 * @return The editable state of the widget
 *
 * @ingroup Elm_Code_Widget
 */
EAPI Eina_Bool elm_code_widget_editable_get(const Elm_Code_Widget *obj);

/**
 * @brief Set whether line numbers should be displayed in the left gutter.
 *
 * Passing EINA_TRUE will reserve a space for showing line numbers, EINA_FALSE
 * will turn this off.
 *
 * @param[in] line_numbers Whether or not line numbers (or their placeholder)
 * should be shown
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_line_numbers_set(Elm_Code_Widget *obj, Eina_Bool line_numbers);

/**
 * @brief Get the status of line number display for this widget.
 *
 * @return Whether or not line numbers (or their placeholder) should be shown
 *
 * @ingroup Elm_Code_Widget
 */
EAPI Eina_Bool elm_code_widget_line_numbers_get(const Elm_Code_Widget *obj);

/**
 * @brief Set where the line width market should be shown.
 *
 * Passing a non-zero value will set which line width to mark with a vertical
 * line. Passing 0 will hide this marker.
 *
 * @param[in] line_width_marker Where to display a line width marker, if at all
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_line_width_marker_set(Elm_Code_Widget *obj, unsigned int line_width_marker);

/**
 * @brief Get the position of the line width marker, any positive return
 * indicates where the marker appears.
 *
 * @return Where to display a line width marker, if at all
 *
 * @ingroup Elm_Code_Widget
 */
EAPI unsigned int elm_code_widget_line_width_marker_get(const Elm_Code_Widget *obj);

/**
 * @brief Set where white space should be shown.
 *
 * @param[in] show_whitespace Whether or not we show whitespace characters
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_show_whitespace_set(Elm_Code_Widget *obj, Eina_Bool show_whitespace);

/**
 * @brief Get whether or not white space will be visible.
 *
 * @return Whether or not we show whitespace characters
 *
 * @ingroup Elm_Code_Widget
 */
EAPI Eina_Bool elm_code_widget_show_whitespace_get(const Elm_Code_Widget *obj);

/**
 * @brief Set whether space characters should be inserted instead of tabs.
 *
 * @param[in] tab_inserts_spaces EINA_TRUE if we should insert space characters
 * instead of a tab when the Tab key is pressed
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_tab_inserts_spaces_set(Elm_Code_Widget *obj, Eina_Bool tab_inserts_spaces);

/**
 * @brief Get whether or not space characters will be inserted instead of tabs.
 *
 * @return EINA_TRUE if we should insert space characters instead of a tab when
 * the Tab key is pressed
 *
 * @ingroup Elm_Code_Widget
 */
EAPI Eina_Bool elm_code_widget_tab_inserts_spaces_get(const Elm_Code_Widget *obj);

/**
 * @brief Set the current location of the text cursor.
 *
 * @param[in] col The horizontal position of the cursor, starting from column 1
 * @param[in] line The vertical position of the cursor - the top row is 1
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_cursor_position_set(Elm_Code_Widget *obj, unsigned int col, unsigned int line);

/**
 * @brief Get the current x and y position of the widget's cursor.
 *
 * @param[out] col The horizontal position of the cursor, starting from column
 * 1
 * @param[out] line The vertical position of the cursor - the top row is 1
 *
 * @ingroup Elm_Code_Widget
 */
EAPI void elm_code_widget_cursor_position_get(const Elm_Code_Widget *obj, unsigned int *col, unsigned int *line);
EAPI void elm_code_widget_line_refresh(Elm_Code_Widget *obj, Elm_Code_Line *line);
EAPI Eina_Bool elm_code_widget_line_visible_get(Elm_Code_Widget *obj, Elm_Code_Line *line);
EAPI unsigned int elm_code_widget_lines_visible_get(Elm_Code_Widget *obj);
EAPI int elm_code_widget_text_left_gutter_width_get(Elm_Code_Widget *obj);
EAPI int elm_code_widget_text_line_number_width_get(Elm_Code_Widget *obj);
EAPI char *elm_code_widget_text_between_positions_get(Elm_Code_Widget *obj, unsigned int start_col, unsigned int start_line, unsigned int end_col, unsigned int end_line);
EAPI unsigned int elm_code_widget_line_text_column_width_to_position(Elm_Code_Widget *obj, Elm_Code_Line *line, unsigned int position);
EAPI unsigned int elm_code_widget_line_text_column_width_get(Elm_Code_Widget *obj, Elm_Code_Line *line);
EAPI unsigned int elm_code_widget_line_text_position_for_column_get(Elm_Code_Widget *obj, Elm_Code_Line *line, unsigned int column);
EAPI unsigned int elm_code_widget_text_tabwidth_at_column_get(Elm_Code_Widget *obj, unsigned int column);
EAPI void elm_code_widget_undo(Elm_Code_Widget *obj);

#endif
