/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.console;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.python.pydev.debug.core.IConsoleInputListener;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.EvaluateExpressionCommand;

public class EvaluationConsoleInputListener
implements IConsoleInputListener {
    private static final boolean DEBUG = false;
    private StringBuffer buf = new StringBuffer();

    public void newLineReceived(String lineReceived, AbstractDebugTarget target) {
        boolean evaluateNow = !lineReceived.startsWith(" ") && !lineReceived.startsWith("\t") && !lineReceived.endsWith(":") && !lineReceived.endsWith("\\");
        this.buf.append(lineReceived);
        if (lineReceived.length() > 0) {
            this.buf.append("@LINE@");
        }
        if (evaluateNow) {
            IAdaptable context;
            String toEval = this.buf.toString();
            if (toEval.trim().length() > 0 && (context = DebugUITools.getDebugContext()) instanceof PyStackFrame) {
                final PyStackFrame frame = (PyStackFrame)context;
                target.postCommand((AbstractDebuggerCommand)new EvaluateExpressionCommand(target, toEval, frame.getLocalsLocator().getPyDBLocation(), true){

                    public void processOKResponse(int cmdCode, String payload) {
                        frame.forceGetNewVariables();
                        super.processOKResponse(cmdCode, payload);
                    }
                });
            }
            this.buf = new StringBuffer();
        }
    }

    public void pasteReceived(String text, AbstractDebugTarget target) {
        text = text.replaceAll("\r\n", "@LINE@").replaceAll("\r", "@LINE@").replaceAll("\n", "@LINE@");
        this.buf.append(text);
        this.buf.append("@LINE@");
    }
}

