/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.actions;

import com.python.pydev.debug.DebugPluginPrefsInitializer;
import com.python.pydev.debug.actions.ShowProcessOutputDialog;
import com.python.pydev.debug.remote.client_api.PydevRemoteDebuggerServer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.IProcessInfo;
import org.python.pydev.shared_core.utils.IProcessList;
import org.python.pydev.shared_core.utils.PlatformUtils;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.utils.UIUtils;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.dialogs.Select1Dialog;
import org.python.pydev.ui.dialogs.TreeNodeLabelProvider;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterPreferencesPage;

public class AttachToProcess
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        try {
            this.doIt();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            PyDialogHelpers.openCritical((String)"Error attaching to process", (String)e.getMessage());
        }
    }

    protected void doIt() throws Exception {
        IProcessList processList = PlatformUtils.getProcessList();
        IProcessInfo[] processList2 = processList.getProcessList();
        TreeNode root = new TreeNode(null, null);
        IProcessInfo[] iProcessInfoArray = processList2;
        int n = processList2.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessInfo iProcessInfo = iProcessInfoArray[n2];
            new TreeNode((Object)root, (Object)iProcessInfo);
            ++n2;
        }
        TreeNode element = new Select1Dialog(){

            protected String getInitialFilter() {
                return "*python*";
            }

            protected ILabelProvider getLabelProvider() {
                return new TreeNodeLabelProvider(){

                    public Image getImage(Object element) {
                        return SharedUiPlugin.getImageCache().get("icons/new/attrpub_obj.gif");
                    }

                    public String getText(Object element) {
                        if (element == null) {
                            return "null";
                        }
                        TreeNode node = (TreeNode)element;
                        Object data = node.data;
                        if (data instanceof IProcessInfo) {
                            IProcessInfo iProcessInfo = (IProcessInfo)data;
                            return String.valueOf(iProcessInfo.getPid()) + " - " + iProcessInfo.getName();
                        }
                        return "Unexpected: " + data;
                    }
                };
            }
        }.selectElement(root);
        if (element != null) {
            IInterpreterInfo[] interpreters;
            IProcessInfo p = (IProcessInfo)element.data;
            int pid = p.getPid();
            if (!PydevRemoteDebuggerServer.isRunning()) {
                PydevRemoteDebuggerServer.startServer();
            }
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IInterpreterManager interpreterManager = PydevPlugin.getPythonInterpreterManager();
            if (interpreterManager == null) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"No interpreter manager.", (String)"No interpreter manager was available for attaching to a process.");
            }
            if ((interpreters = interpreterManager.getInterpreterInfos()) == null || interpreters.length == 0) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"No interpreters for creating console", (String)"An interpreter that matches the architecture of the target process must be configured in the interpreter preferences.");
                return;
            }
            SelectionDialog listDialog = AbstractInterpreterPreferencesPage.createChooseIntepreterInfoDialog((IWorkbenchWindow)workbenchWindow, (IInterpreterInfo[])interpreters, (String)"Select interpreter which matches the architecture of the target process (i.e.: 32/64 bits).", (boolean)false);
            int open = listDialog.open();
            if (open != 0 || listDialog.getResult().length != 1) {
                return;
            }
            Object[] result = listDialog.getResult();
            IInterpreterInfo interpreter = result == null || result.length == 0 ? interpreters[0] : (IInterpreterInfo)result[0];
            SimplePythonRunner runner = new SimplePythonRunner();
            IPath relative = new Path("pysrc").append("pydevd_attach_to_process").append("attach_pydevd.py");
            String script = PydevPlugin.getBundleInfo().getRelativePath(relative).getAbsolutePath();
            String[] args = new String[]{"--port", "" + DebugPluginPrefsInitializer.getRemoteDebuggerPort(), "--pid", "" + pid};
            SystemPythonNature nature = new SystemPythonNature(interpreterManager, interpreter);
            String[] s = SimplePythonRunner.preparePythonCallParameters((String)interpreter.getExecutableOrJar(), (String)script, (String[])args);
            Tuple run = runner.run(s, null, (IPythonNature)nature, (IProgressMonitor)new NullProgressMonitor());
            if (run.o1 != null) {
                ShowProcessOutputDialog dialog = new ShowProcessOutputDialog(UIUtils.getActiveShell(), (Process)run.o1);
                dialog.open();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

