/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.debug.ui.launching.AbstractLaunchShortcut;
import org.python.pydev.debug.ui.launching.FileOrResource;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class UnitTestLaunchShortcut
extends AbstractLaunchShortcut {
    private String arguments = "";

    @Override
    protected String getLaunchConfigurationType() {
        return "org.python.pydev.debug.unittestLaunchConfigurationType";
    }

    @Override
    protected IInterpreterManager getInterpreterManager(IProject project) {
        return PydevPlugin.getPythonInterpreterManager();
    }

    @Override
    public void launch(IEditorPart editor, String mode) {
        PyEdit pyEdit;
        PySelection ps;
        String selectedText;
        this.arguments = "";
        if (editor instanceof PyEdit && (selectedText = (ps = (pyEdit = (PyEdit)editor).createPySelection()).getSelectedText()).length() > 0) {
            String last = null;
            FastStringBuffer buf = new FastStringBuffer();
            List path = FastParser.parseToKnowGloballyAccessiblePath((IDocument)ps.getDoc(), (int)ps.getStartLineIndex());
            for (stmtType stmtType2 : path) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                last = NodeUtils.getRepresentationString((SimpleNode)stmtType2);
                buf.append(last);
            }
            if (last != null && last.equals(selectedText)) {
                this.arguments = buf.toString();
            }
        }
        super.launch(editor, mode);
    }

    @Override
    public ILaunchConfigurationWorkingCopy createDefaultLaunchConfigurationWithoutSaving(FileOrResource[] resource) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = super.createDefaultLaunchConfigurationWithoutSaving(resource);
        if (this.arguments.length() > 0) {
            workingCopy.setAttribute("org.python.pydev.debug.ATTR_UNITTEST_TESTS", this.arguments);
        }
        return workingCopy;
    }

    @Override
    protected List<ILaunchConfiguration> findExistingLaunchConfigurations(FileOrResource[] file) {
        ArrayList<ILaunchConfiguration> ret = new ArrayList<ILaunchConfiguration>();
        List<ILaunchConfiguration> existing = super.findExistingLaunchConfigurations(file);
        for (ILaunchConfiguration launch : existing) {
            boolean matches = false;
            try {
                matches = launch.getAttribute("org.python.pydev.debug.ATTR_UNITTEST_TESTS", "").equals(this.arguments);
            }
            catch (CoreException coreException) {}
            if (!matches) continue;
            ret.add(launch);
        }
        return ret;
    }
}

