/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.hover;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.ui.actions.EvalExpressionAction;
import org.python.pydev.editor.hover.AbstractPyEditorTextHover;
import org.python.pydev.editor.hover.PyHoverPreferencesPage;

public class PyDebugHover
extends AbstractPyEditorTextHover {
    public static String ID = "org.python.pydev.debug.ui.hover.PyDebugHover";

    public String getHoverInfo(final ITextViewer textViewer, IRegion hoverRegion) {
        block16: {
            if (!PyHoverPreferencesPage.getShowValuesWhileDebuggingOnHover()) {
                return null;
            }
            IAdaptable object = DebugUITools.getDebugContext();
            IDebugElement context = null;
            if (object instanceof IDebugElement) {
                context = (IDebugElement)object;
            } else if (object instanceof ILaunch) {
                context = ((ILaunch)object).getDebugTarget();
            }
            if (context != null) {
                IDebugTarget debugTarget = context.getDebugTarget();
                if (debugTarget == null || debugTarget.isTerminated()) {
                    return null;
                }
                String act = null;
                final ITextSelection[] textSelection = new ITextSelection[1];
                if (Thread.currentThread() == textViewer.getTextWidget().getDisplay().getThread()) {
                    textSelection[0] = (ITextSelection)textViewer.getSelectionProvider().getSelection();
                } else {
                    textViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            textSelection[0] = (ITextSelection)textViewer.getSelectionProvider().getSelection();
                        }
                    });
                }
                PySelection ps = new PySelection(textViewer.getDocument(), hoverRegion.getOffset() + hoverRegion.getLength());
                int mouseOffset = ps.getAbsoluteCursorOffset();
                int offset = textSelection[0].getOffset();
                int len = textSelection[0].getLength();
                boolean reportSyntaxErrors = false;
                if (len > 0 && mouseOffset >= offset && offset + len >= mouseOffset) {
                    try {
                        act = ps.getDoc().get(offset, len);
                        reportSyntaxErrors = true;
                    }
                    catch (BadLocationException e) {
                        Log.log((Throwable)e);
                    }
                }
                if (act == null || act.trim().length() == 0) {
                    String[] activationTokenAndQual = ps.getActivationTokenAndQual(true);
                    act = String.valueOf(activationTokenAndQual[0]) + activationTokenAndQual[1];
                }
                IWatchExpression watchExpression = EvalExpressionAction.createWatchExpression(act);
                watchExpression.evaluate();
                EvalExpressionAction.waitForExpressionEvaluation(watchExpression);
                IValue value = watchExpression.getValue();
                if (value != null) {
                    String valueString;
                    block17: {
                        valueString = value.getValueString();
                        if (valueString == null) break block16;
                        if (reportSyntaxErrors || !valueString.startsWith("SyntaxError") || valueString.indexOf("<string>") == -1) break block17;
                        return null;
                    }
                    try {
                        return String.valueOf(valueString) + "\n";
                    }
                    catch (DebugException e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public boolean isContentTypeSupported(String contentType) {
        boolean pythonCommentOrMultiline = IPythonPartitions.NON_DEFAULT_TYPES_AS_SET.contains(contentType);
        return !pythonCommentOrMultiline;
    }
}

