/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.codefolding.PyAbstractIndentGuidePreferencesProvider;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_ui.editor.BaseSourceViewer;
import org.python.pydev.shared_ui.editor.IVerticalIndentGuidePreferencesProvider;

public class PythonSourceViewer
extends BaseSourceViewer {
    private Font fFont;
    private Color fBackgroundColor;
    private Color fForegroundColor;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("org.eclipse.jface.textfont".equals(property)) {
                PythonSourceViewer.this.updateViewerFont();
            }
            if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property)) {
                PythonSourceViewer.this.updateViewerColors();
            }
            if (PythonSourceViewer.this.affectsTextPresentation(event)) {
                PythonSourceViewer.this.invalidateTextPresentation();
            }
        }
    };

    public PythonSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, null, false, styles, (IVerticalIndentGuidePreferencesProvider)new PyAbstractIndentGuidePreferencesProvider(){

            public int getTabWidth() {
                return DefaultIndentPrefs.get(null).getTabWidth();
            }
        });
        StyledText text = this.getTextWidget();
        text.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                try {
                    event.segments = PythonSourceViewer.this.getBidiLineSegments(event.lineOffset);
                }
                catch (BadLocationException badLocationException) {}
            }
        });
        this.updateViewerFont();
        this.updateViewerColors();
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    private void updateViewerFont() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            FontData data = null;
            data = store.contains("org.eclipse.jface.textfont") && !store.isDefault("org.eclipse.jface.textfont") ? PreferenceConverter.getFontData((IPreferenceStore)store, (String)"org.eclipse.jface.textfont") : PreferenceConverter.getDefaultFontData((IPreferenceStore)store, (String)"org.eclipse.jface.textfont");
            if (data != null) {
                Font font = new Font((Device)this.getTextWidget().getDisplay(), data);
                this.applyFont(font);
                if (this.getFont() != null) {
                    this.getFont().dispose();
                }
                this.setFont(font);
                return;
            }
        }
        this.applyFont(JFaceResources.getTextFont());
    }

    private void setFont(Font font) {
        this.fFont = font;
    }

    private Font getFont() {
        return this.fFont;
    }

    private void applyFont(Font font) {
        IDocument doc = this.getDocument();
        if (doc != null && doc.getLength() > 0) {
            Point selection = this.getSelectedRange();
            int topIndex = this.getTopIndex();
            StyledText styledText = this.getTextWidget();
            styledText.setRedraw(false);
            styledText.setFont(font);
            this.setSelectedRange(selection.x, selection.y);
            this.setTopIndex(topIndex);
            styledText.setRedraw(true);
        } else {
            this.getTextWidget().setFont(font);
        }
    }

    public void updateViewerColors() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = this.getTextWidget();
            if (styledText == null || styledText.isDisposed()) {
                return;
            }
            Color color = store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.getForegroundColor() != null) {
                this.getForegroundColor().dispose();
            }
            this.setForegroundColor(color);
            color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.getBackgroundColor() != null) {
                this.getBackgroundColor().dispose();
            }
            this.setBackgroundColor(color);
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    protected Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    protected void setBackgroundColor(Color backgroundColor) {
        this.fBackgroundColor = backgroundColor;
    }

    protected Color getForegroundColor() {
        return this.fForegroundColor;
    }

    protected void setForegroundColor(Color foregroundColor) {
        this.fForegroundColor = foregroundColor;
    }

    protected IPreferenceStore getPreferenceStore() {
        return PydevPrefs.getChainedPrefStore();
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return true;
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    protected int[] getBidiLineSegments(int lineOffset) throws BadLocationException {
        IDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        IRegion line = document.getLineInformationOfOffset(lineOffset);
        ITypedRegion[] linePartitioning = document.computePartitioning(lineOffset, line.getLength());
        int size = linePartitioning.length;
        int[] segments = new int[size * 2 + 1];
        int j = 0;
        int i = 0;
        while (i < size) {
            int offset;
            ITypedRegion segment = linePartitioning[i];
            if (i == 0) {
                segments[j++] = 0;
            }
            if ((offset = segment.getOffset() - lineOffset) > segments[j - 1]) {
                segments[j++] = offset;
            }
            if (offset + segment.getLength() >= line.getLength()) break;
            segments[j++] = offset + segment.getLength();
            ++i;
        }
        if (j < segments.length) {
            int[] result = new int[j];
            System.arraycopy(segments, 0, result, 0, j);
            segments = result;
        }
        return segments;
    }

    public void dispose() {
        if (this.getFont() != null) {
            this.getFont().dispose();
            this.setFont(null);
        }
        if (this.getBackgroundColor() != null) {
            this.getBackgroundColor().dispose();
            this.setBackgroundColor(null);
        }
        if (this.getForegroundColor() != null) {
            this.getForegroundColor().dispose();
            this.setForegroundColor(null);
        }
        this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }
}

