/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.debug.core.ConfigureExceptionsFileUtils;

public class PyPropertyTraceDialog
extends SelectionDialog {
    private Button disableStepIntoPropertiesCheck;
    private Button disableStepIntoGetterCheck;
    private Button disableStepIntoSetterCheck;
    private Button disableStepIntoDeleterCheck;
    private boolean disableStepIntoProperties = false;
    private boolean disableStepIntoGetter = false;
    private boolean disableStepIntoSetter = false;
    private boolean disableStepIntoDeleter = false;

    public PyPropertyTraceDialog(Shell parentShell) {
        super(parentShell);
    }

    private void createStepIntoOptions(Composite composite) {
        List<String> pyPropertyTraceStatesList = ConfigureExceptionsFileUtils.getConfiguredExceptions("property_trace_state.prefs");
        if (pyPropertyTraceStatesList.size() == 4) {
            this.disableStepIntoProperties = Boolean.parseBoolean(pyPropertyTraceStatesList.get(0));
            this.disableStepIntoGetter = Boolean.parseBoolean(pyPropertyTraceStatesList.get(1));
            this.disableStepIntoSetter = Boolean.parseBoolean(pyPropertyTraceStatesList.get(2));
            this.disableStepIntoDeleter = Boolean.parseBoolean(pyPropertyTraceStatesList.get(3));
        }
        this.disableStepIntoPropertiesCheck = new Button(composite, 32);
        this.disableStepIntoPropertiesCheck.setText("Disable step into properties");
        this.disableStepIntoPropertiesCheck.setSelection(this.disableStepIntoProperties);
        this.createSelectionListener();
        GridData gridData = new GridData();
        gridData.horizontalIndent = 25;
        this.disableStepIntoGetterCheck = new Button(composite, 32);
        this.disableStepIntoGetterCheck.setText("Disable step into property getters");
        this.disableStepIntoGetterCheck.setSelection(this.disableStepIntoGetter);
        this.disableStepIntoGetterCheck.setEnabled(this.disableStepIntoPropertiesCheck.getSelection());
        this.disableStepIntoGetterCheck.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalIndent = 25;
        this.disableStepIntoSetterCheck = new Button(composite, 32);
        this.disableStepIntoSetterCheck.setText("Disable step into property setters");
        this.disableStepIntoSetterCheck.setSelection(this.disableStepIntoSetter);
        this.disableStepIntoSetterCheck.setEnabled(this.disableStepIntoPropertiesCheck.getSelection());
        this.disableStepIntoSetterCheck.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalIndent = 25;
        this.disableStepIntoDeleterCheck = new Button(composite, 32);
        this.disableStepIntoDeleterCheck.setText("Disable step into property deleters");
        this.disableStepIntoDeleterCheck.setSelection(this.disableStepIntoDeleter);
        this.disableStepIntoDeleterCheck.setEnabled(this.disableStepIntoPropertiesCheck.getSelection());
        this.disableStepIntoDeleterCheck.setLayoutData((Object)gridData);
    }

    private void createSelectionListener() {
        this.disableStepIntoPropertiesCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                PyPropertyTraceDialog.this.disableStepIntoGetterCheck.setSelection(false);
                PyPropertyTraceDialog.this.disableStepIntoGetterCheck.setEnabled(PyPropertyTraceDialog.this.disableStepIntoPropertiesCheck.getSelection());
                PyPropertyTraceDialog.this.disableStepIntoSetterCheck.setSelection(false);
                PyPropertyTraceDialog.this.disableStepIntoSetterCheck.setEnabled(PyPropertyTraceDialog.this.disableStepIntoPropertiesCheck.getSelection());
                PyPropertyTraceDialog.this.disableStepIntoDeleterCheck.setSelection(false);
                PyPropertyTraceDialog.this.disableStepIntoDeleterCheck.setEnabled(PyPropertyTraceDialog.this.disableStepIntoPropertiesCheck.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createStepIntoOptions(composite);
        return composite;
    }

    protected void okPressed() {
        this.disableStepIntoProperties = this.disableStepIntoPropertiesCheck.getSelection();
        this.disableStepIntoGetter = this.disableStepIntoGetterCheck.getSelection();
        this.disableStepIntoSetter = this.disableStepIntoSetterCheck.getSelection();
        this.disableStepIntoDeleter = this.disableStepIntoDeleterCheck.getSelection();
        super.okPressed();
    }

    public boolean isDisableStepIntoProperties() {
        return this.disableStepIntoProperties;
    }

    public boolean isDisableStepIntoGetter() {
        return this.disableStepIntoGetter;
    }

    public boolean isDisableStepIntoSetter() {
        return this.disableStepIntoSetter;
    }

    public boolean isDisableStepIntoDeleter() {
        return this.disableStepIntoDeleter;
    }
}

