/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.profile;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.utils.PlatformUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.dialogs.PyDialogHelpers;

public class PyProfilePreferences {
    public static final String ENABLE_PROFILING_FOR_NEW_LAUNCHES = "ENABLE_PROFILING_FOR_NEW_LAUNCHES";
    public static final String PYVMMONITOR_UI_LOCATION = "PYVMMONITOR_UI_LOCATION";
    public static final String PROFILE_MODE = "PROFILE_MODE";
    public static final int PROFILE_MODE_YAPPI = 0;
    public static final int PROFILE_MODE_LSPROF = 1;
    public static final int PROFILE_MODE_NONE = 2;
    private static PreferenceStore tempPreferenceStore = new PreferenceStore();
    private static boolean firstCall;
    private static final Object lock;

    static {
        tempPreferenceStore.setDefault(ENABLE_PROFILING_FOR_NEW_LAUNCHES, false);
        firstCall = true;
        lock = new Object();
    }

    public static boolean getAllRunsDoProfile() {
        return tempPreferenceStore.getBoolean(ENABLE_PROFILING_FOR_NEW_LAUNCHES);
    }

    public static IPreferenceStore getTemporaryPreferenceStore() {
        return tempPreferenceStore;
    }

    public static String getPyVmMonitorUILocation() {
        String location = PyProfilePreferences.getPermanentPreferenceStore().getString(PYVMMONITOR_UI_LOCATION);
        if (!new File(location).exists() || !new File(location).isFile()) {
            if (PlatformUtils.isMacOsPlatform()) {
                File f = new File(location, "Contents");
                f = new File(f, "MacOS");
                if ((f = new File(f, "pyvmmonitor-ui")).exists()) {
                    return FileUtils.getFileAbsolutePath((File)f);
                }
            }
            location = PyProfilePreferences.getDefaultLocation();
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPreferenceStore getPermanentPreferenceStore() {
        IPreferenceStore preferenceStore = PydevPrefs.getPreferenceStore();
        if (firstCall) {
            Object object = lock;
            synchronized (object) {
                if (firstCall) {
                    firstCall = false;
                    String defaultLocation = PyProfilePreferences.getDefaultLocation();
                    if (defaultLocation != null) {
                        preferenceStore.setDefault(PYVMMONITOR_UI_LOCATION, defaultLocation);
                    }
                    preferenceStore.setDefault(PROFILE_MODE, 1);
                }
            }
        }
        return preferenceStore;
    }

    public static String getDefaultLocation() {
        File settings = null;
        try {
            String env;
            if (PlatformUtils.isMacOsPlatform()) {
                settings = new File(System.getProperty("user.home"), "Library");
                settings = new File(settings, "Application Support");
                settings = new File(settings, "Brainwy");
                settings = new File(settings, "PyVmMonitor.ini");
            } else if (PlatformUtils.isLinuxPlatform()) {
                settings = new File(System.getProperty("user.home"), ".config/Brainwy/pyvmmonitor.ini");
            } else if (PlatformUtils.isWindowsPlatform() && (env = System.getenv("LOCALAPPDATA")) != null && env.length() > 0 && new File(env).exists()) {
                settings = new File(new File(env, "Brainwy"), "PyVmMonitor.ini");
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        String defaultLocation = null;
        try {
            if (settings != null && settings.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(settings));
                String property = props.getProperty("pyvmmonitor_ui_executable");
                if (property != null) {
                    defaultLocation = property;
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return defaultLocation;
    }

    public static int getProfileMode() {
        return PyProfilePreferences.getPermanentPreferenceStore().getInt(PROFILE_MODE);
    }

    public static void addProfileArgs(List<String> cmdArgs, boolean profileRun, boolean actualRun) {
        if (profileRun) {
            final String pyVmMonitorUILocation = PyProfilePreferences.getPyVmMonitorUILocation();
            if (pyVmMonitorUILocation == null || pyVmMonitorUILocation.length() == 0) {
                if (actualRun) {
                    RunInUiThread.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PyDialogHelpers.openWarning((String)"Unable to run in profile mode.", (String)"Unable to run in profile mode: pyvmmonitor-ui location not specified.");
                        }
                    });
                }
                return;
            }
            if (!new File(pyVmMonitorUILocation).exists()) {
                if (actualRun) {
                    RunInUiThread.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PyDialogHelpers.openWarning((String)"Unable to run in profile mode.", (String)("Unable to run in profile mode: Invalid location for pyvmmonitor-ui: " + pyVmMonitorUILocation));
                        }
                    });
                }
                return;
            }
            File file = new File(pyVmMonitorUILocation);
            File publicApi = new File(file.getParentFile(), "public_api");
            File pyvmmonitorFolder = new File(publicApi, "pyvmmonitor");
            final File pyvmmonitorInit = new File(pyvmmonitorFolder, "__init__.py");
            if (!pyvmmonitorInit.exists()) {
                if (actualRun) {
                    RunInUiThread.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PyDialogHelpers.openWarning((String)"Unable to run in profile mode.", (String)("Unable to run in profile mode: Invalid location for pyvmmonitor/__init__.py: " + FileUtils.getFileAbsolutePath((File)pyvmmonitorInit)));
                        }
                    });
                }
                return;
            }
            cmdArgs.add(FileUtils.getFileAbsolutePath((File)pyvmmonitorInit));
            int profileMode = PyProfilePreferences.getProfileMode();
            if (profileMode == 0) {
                cmdArgs.add("--profile=yappi");
            } else if (profileMode == 1) {
                cmdArgs.add("--profile=lsprof");
            }
            cmdArgs.add("--spawn-ui=false");
            if (actualRun) {
                ProcessUtils.run((String[])new String[]{pyVmMonitorUILocation, "--default-port-single-instance"}, null, (File)new File(pyVmMonitorUILocation).getParentFile(), null);
            }
        }
    }
}

