/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.prefs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsoleCommand;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.preferences.IScopedPreferences;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;
import org.python.pydev.shared_ui.dialogs.DialogHelpers;
import org.yaml.snakeyaml.Yaml;

public class InterativeConsoleCommandsPreferencesEditor {
    private IScopedPreferences scopedPreferences;
    private Combo combo;
    private final Map<String, InteractiveConsoleCommand> nameToCommand = new HashMap<String, InteractiveConsoleCommand>();
    private Text textCommand;
    private Text textKeybinding;
    private Label errorLabel;
    private Color red;
    private ModifyListener textKeybindingListener;
    private ModifyListener textCommandListener;
    private boolean registered = false;

    public InterativeConsoleCommandsPreferencesEditor() {
        this.scopedPreferences = InteractiveConsoleCommand.getScopedPreferences();
    }

    public Combo getCombo() {
        return this.combo;
    }

    public Control createContents(Composite parent) {
        parent = new Composite(parent, 0x800000);
        parent.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)this.createGridData());
        label.setText("Command");
        this.combo = new Combo(parent, 12);
        this.combo.setLayoutData((Object)this.createComboGridData());
        final Button button = new Button(parent, 8);
        button.setLayoutData((Object)this.createGridData());
        button.setText("Add");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] items = InterativeConsoleCommandsPreferencesEditor.this.combo.getItems();
                final HashSet<String> set = new HashSet<String>(Arrays.asList(items));
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "At least 1 char must be provided.";
                        }
                        if (set.contains(newText)) {
                            return "A command named: " + newText + " already exists.";
                        }
                        return null;
                    }
                };
                String name = DialogHelpers.openInputRequest((String)"Command name", (String)"Please enter the name of the command", (Shell)button.getShell(), (IInputValidator)validator);
                if (name != null && name.length() > 0) {
                    InteractiveConsoleCommand cmd = new InteractiveConsoleCommand(name);
                    InterativeConsoleCommandsPreferencesEditor.this.addCommand(cmd);
                    InterativeConsoleCommandsPreferencesEditor.this.comboSelectionChanged();
                }
            }
        });
        Button buttonRemove = new Button(parent, 8);
        buttonRemove.setLayoutData((Object)this.createGridData());
        buttonRemove.setText("Remove");
        buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterativeConsoleCommandsPreferencesEditor.this.removeSelectedCommand();
                InterativeConsoleCommandsPreferencesEditor.this.comboSelectionChanged();
            }
        });
        label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 1).create());
        label.setText("Keybinding");
        this.textKeybinding = new Text(parent, 2052);
        this.textKeybinding.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        this.textKeybindingListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String comboText = InterativeConsoleCommandsPreferencesEditor.this.combo.getText();
                InteractiveConsoleCommand interactiveConsoleCommand = (InteractiveConsoleCommand)InterativeConsoleCommandsPreferencesEditor.this.nameToCommand.get(comboText);
                if (interactiveConsoleCommand == null) {
                    Log.log((String)("Expected a command to be bound to: " + comboText));
                    return;
                }
                InterativeConsoleCommandsPreferencesEditor.this.validateAndSetKeybinding(comboText, interactiveConsoleCommand);
            }
        };
        label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 1).create());
        label.setText("Command text.\n\n${text} is replaced by the currently selected text\nor the full line if no text is selected.");
        this.textCommand = new Text(parent, 2050);
        this.textCommand.setLayoutData(this.createTextGridData());
        this.textCommandListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String comboText = InterativeConsoleCommandsPreferencesEditor.this.combo.getText();
                InteractiveConsoleCommand interactiveConsoleCommand = (InteractiveConsoleCommand)InterativeConsoleCommandsPreferencesEditor.this.nameToCommand.get(comboText);
                if (interactiveConsoleCommand == null) {
                    Log.log((String)("Expected a command to be bound to: " + comboText));
                    return;
                }
                interactiveConsoleCommand.commandText = InterativeConsoleCommandsPreferencesEditor.this.textCommand.getText();
            }
        };
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterativeConsoleCommandsPreferencesEditor.this.comboSelectionChanged();
            }
        });
        this.errorLabel = new Label(parent, 0);
        this.errorLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 1).create());
        this.errorLabel.setText("Command text.\n\n${text} is replaced by the currently selected text\nor the full line if no text is selected.");
        this.errorLabel.setVisible(false);
        this.red = new Color((Device)Display.getCurrent(), 255, 0, 0);
        this.errorLabel.setForeground(this.red);
        this.loadCommands();
        this.addTextListeners();
        return parent;
    }

    private void addTextListeners() {
        if (!this.registered) {
            this.textKeybinding.addModifyListener(this.textKeybindingListener);
            this.textCommand.addModifyListener(this.textCommandListener);
            this.registered = true;
        }
    }

    private void removeTextListeners() {
        if (this.registered) {
            this.textKeybinding.removeModifyListener(this.textKeybindingListener);
            this.textCommand.removeModifyListener(this.textCommandListener);
            this.registered = false;
        }
    }

    protected void showKeybindingError(String message) {
        this.errorLabel.setText(message);
        this.errorLabel.setVisible(true);
        this.errorLabel.getParent().layout(true);
    }

    protected void showKeybindingError(Exception e1) {
        this.showKeybindingError(e1.getMessage());
    }

    protected void hideKeybindingError() {
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
        this.errorLabel.getParent().layout(true);
    }

    protected void comboSelectionChanged() {
        this.removeTextListeners();
        try {
            String text = this.combo.getText();
            InteractiveConsoleCommand interactiveConsoleCommand = this.nameToCommand.get(text);
            if (interactiveConsoleCommand == null) {
                this.textKeybinding.setText("");
                this.textKeybinding.setEnabled(false);
                this.textCommand.setText("");
                this.textCommand.setEnabled(false);
            } else {
                this.textKeybinding.setText(interactiveConsoleCommand.keybinding);
                this.textKeybinding.setEnabled(true);
                this.textCommand.setText(interactiveConsoleCommand.commandText);
                this.textCommand.setEnabled(true);
            }
            if (interactiveConsoleCommand != null) {
                this.validateAndSetKeybinding(text, interactiveConsoleCommand);
            } else {
                this.hideKeybindingError();
            }
        }
        finally {
            this.addTextListeners();
        }
    }

    public void clearCommands() {
        this.combo.setItems(new String[0]);
        this.nameToCommand.clear();
        this.comboSelectionChanged();
    }

    public void loadCommands() {
        this.clearCommands();
        List<InteractiveConsoleCommand> loadExistingCommands = InteractiveConsoleCommand.loadExistingCommands();
        for (InteractiveConsoleCommand command : loadExistingCommands) {
            this.addCommand(command);
        }
        this.comboSelectionChanged();
    }

    private Object createTextGridData() {
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 4;
        return data;
    }

    private GridData createGridData() {
        GridData data = new GridData();
        return data;
    }

    private GridData createComboGridData() {
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    public void addCommand(InteractiveConsoleCommand command) {
        this.combo.add(command.name);
        this.nameToCommand.put(command.name, command);
        this.combo.select(this.combo.getItemCount() - 1);
    }

    public void performSave() {
        String[] items;
        Yaml yaml = new Yaml();
        HashMap map = new HashMap();
        ArrayList<Map<String, Object>> commands = new ArrayList<Map<String, Object>>();
        String[] stringArray = items = this.combo.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            InteractiveConsoleCommand command = this.nameToCommand.get(string);
            if (command.isValid()) {
                commands.add(command.asMap());
            }
            ++n2;
        }
        map.put("commands", commands);
        File yamlFile = this.scopedPreferences.getWorkspaceSettingsLocation();
        if (!yamlFile.getParentFile().exists()) {
            yamlFile.getParentFile().mkdirs();
        }
        String dumpAsMap = yaml.dumpAsMap(map);
        FileUtils.writeStrToFile((String)dumpAsMap, (File)yamlFile);
        InteractiveConsoleCommand.keepBindingsUpdated();
    }

    public void removeSelectedCommand() {
        String selectedName = this.combo.getText();
        InteractiveConsoleCommand command = this.nameToCommand.get(selectedName);
        if (command != null) {
            int selectionIndex = this.combo.getSelectionIndex();
            this.nameToCommand.remove(selectedName);
            this.combo.remove(selectedName);
            if (selectionIndex >= this.combo.getItemCount()) {
                --selectionIndex;
            }
            if (selectionIndex >= 0 && selectionIndex < this.combo.getItemCount()) {
                this.combo.select(selectionIndex);
            }
        }
    }

    public void performDefaults() {
        if (DialogHelpers.openQuestion((String)"Confirm", (String)"Clear all the commands created?")) {
            this.clearCommands();
            this.performSave();
        }
    }

    public void dispose() {
        this.red.dispose();
    }

    public void setCommandText(String text) {
        this.textCommand.setText(text);
    }

    public void setKeybindingText(String text) {
        this.textKeybinding.setText(text);
    }

    public void selectComboText(String string) {
        String[] items = this.combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (string.equals(items[i])) {
                this.combo.select(i);
                this.comboSelectionChanged();
            }
            ++i;
        }
    }

    public String getCommandText() {
        return this.textCommand.getText();
    }

    public String getCommandKeybinding() {
        return this.textKeybinding.getText().trim();
    }

    private Set<String> getCurrentBindings(String comboTextToIgnore) {
        String[] items;
        HashSet<String> currentBindings = new HashSet<String>();
        String[] stringArray = items = this.combo.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            InteractiveConsoleCommand command;
            String commandName = stringArray[n2];
            if (!commandName.equals(comboTextToIgnore) && (command = this.nameToCommand.get(commandName)) != null) {
                currentBindings.add(command.keybinding);
            }
            ++n2;
        }
        return currentBindings;
    }

    private boolean validateAndSetKeybinding(String comboText, InteractiveConsoleCommand interactiveConsoleCommand) {
        block16: {
            String text;
            block15: {
                block14: {
                    text = this.textKeybinding.getText().trim();
                    if (text.length() != 0) break block14;
                    this.showKeybindingError("The keybinding must be specified.");
                    return false;
                }
                Set<String> currentBindings = this.getCurrentBindings(comboText);
                if (!currentBindings.contains(text)) break block15;
                this.showKeybindingError("The keybinding: " + text + " is already being used.");
                return false;
            }
            KeySequence keySequence = KeyBindingHelper.getKeySequence((String)text);
            IBindingService bindingService = null;
            try {
                bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            }
            catch (Throwable throwable) {}
            FastStringBuffer bufConflicts = new FastStringBuffer();
            int numberOfConflicts = 0;
            if (bindingService != null) {
                Binding[] bindings;
                Binding[] bindingArray = bindings = bindingService.getBindings();
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    Binding binding = bindingArray[n2];
                    if (binding.getContextId().equals("org.python.pydev.ui.editor.scope") && binding.getTriggerSequence().equals((Object)keySequence)) {
                        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
                        if (parameterizedCommand == null) {
                            bufConflicts.append(binding.toString()).append('\n');
                        } else if (!parameterizedCommand.getCommand().getId().startsWith("org.python.pydev.custom.interactive_console.user_command.InteractiveConsoleUserCommand")) {
                            bufConflicts.append(" - ").append(parameterizedCommand.getName()).append('\n');
                            ++numberOfConflicts;
                        }
                    }
                    ++n2;
                }
            }
            interactiveConsoleCommand.keybinding = text;
            if (bufConflicts.length() <= 0) break block16;
            this.showKeybindingError("The current keybinding (" + text + ") conflicts with:\n" + bufConflicts.toString() + "(" + (numberOfConflicts == 1 ? "they" : "it") + "'ll be removed if the changes are applied and\n" + "can only be restored in the 'Keys' preferences page).");
            return true;
        }
        try {
            this.hideKeybindingError();
            return true;
        }
        catch (IllegalArgumentException | ParseException e1) {
            this.showKeybindingError((Exception)e1);
            return false;
        }
        catch (Exception e1) {
            this.showKeybindingError(e1);
            Log.log((Throwable)e1);
            return false;
        }
    }
}

