/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.newconsole.IPyStackFrameProvider;
import org.python.pydev.shared_ui.utils.UIUtils;

public class AnyPyStackFrameSelected
implements IPyStackFrameProvider,
IDebugContextListener {
    protected boolean isLinkedWithDebug = true;
    private PyStackFrame last;

    public AnyPyStackFrameSelected() {
        IWorkbenchPart activePart = UIUtils.getActivePart();
        if (activePart != null) {
            IWorkbenchPartSite site = activePart.getSite();
            DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)site, (IDebugContextListener)this);
        }
    }

    @Override
    public PyStackFrame getLastSelectedFrame() {
        PyStackFrame stackFrame;
        this.updateContext(DebugUITools.getDebugContext());
        if (this.last instanceof PyStackFrame && !(stackFrame = this.last).isTerminated() && stackFrame.isSuspended()) {
            return this.last;
        }
        return null;
    }

    private void updateContext(IAdaptable context) {
        PyStackFrame stackFrame;
        if (!this.isLinkedWithDebug && this.last != null) {
            return;
        }
        if (context != this.last && context instanceof PyStackFrame && !(stackFrame = (PyStackFrame)context).isTerminated() && stackFrame.isSuspended() && this.acceptsSelection(stackFrame)) {
            this.last = stackFrame;
        }
    }

    protected boolean acceptsSelection(PyStackFrame stackFrame) {
        return true;
    }

    public void debugContextChanged(DebugContextEvent event) {
        if (event.getFlags() == 1) {
            this.updateContext(AnyPyStackFrameSelected.getDebugContextElementForSelection(event.getContext()));
        }
    }

    private static IAdaptable getDebugContextElementForSelection(ISelection activeContext) {
        Object firstElement;
        IStructuredSelection selection;
        if (activeContext instanceof IStructuredSelection && !(selection = (IStructuredSelection)activeContext).isEmpty() && (firstElement = selection.getFirstElement()) instanceof IAdaptable) {
            return (IAdaptable)firstElement;
        }
        return null;
    }

    @Override
    public void linkWithDebugSelection(boolean isLinkedWithDebug) {
        this.isLinkedWithDebug = isLinkedWithDebug;
    }
}

