/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_core.net.SocketUtil;

public class ListenConnector
implements Runnable {
    protected volatile int timeout;
    protected ServerSocket serverSocket;
    protected Socket socket;
    protected Exception e;

    public ListenConnector(int timeout) throws IOException {
        this.timeout = timeout;
        try {
            this.serverSocket = SocketUtil.createLocalServerSocket();
        }
        catch (IOException e) {
            Log.log((String)"Error when creating server socket.", (Throwable)e);
            throw e;
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    Exception getException() {
        return this.e;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void stopListening() {
        if (this.serverSocket != null) {
            try {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    PydevDebugPlugin.log(2, "Error closing pydevd socket", e);
                    this.serverSocket = null;
                }
            }
            finally {
                this.serverSocket = null;
            }
        }
    }

    public boolean isDisposed() {
        return this.serverSocket == null;
    }

    @Override
    public void run() {
        try {
            this.socket = this.waitForConnection();
        }
        catch (IOException e) {
            this.e = e;
        }
    }

    public Socket waitForConnection() throws SocketException, IOException {
        this.serverSocket.setSoTimeout(this.timeout);
        return this.serverSocket.accept();
    }

    public int getLocalPort() throws IOException {
        int localPort = this.serverSocket.getLocalPort();
        SocketUtil.checkValidPort((int)localPort);
        return localPort;
    }

    protected void finalize() throws Throwable {
        try {
            this.stopListening();
        }
        catch (Throwable e) {
            PydevDebugPlugin.log(2, "Error finalizing ListenConnector", e);
        }
    }
}

