/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class PyConditionalBreakPointManager {
    private static final String DELIMETER = "\t";
    private static final int ERROR_CODE = 1;
    private static final String PYTHON_TRACEBACK = "Traceback (most recent call last):";
    private static final String SHELL_TEXT = "Conditional Breakpoint";
    private static final String PID = "Error";
    private static final String ERROR_MESSAGE = "An exception has occurred when evaluating a conditional breakpoint:\n\n";
    private static final String TITLE = "Error in executing conditional breakpoint";
    private static PyConditionalBreakPointManager pyConditionalBreakPointManager;

    private PyConditionalBreakPointManager() {
    }

    public static synchronized PyConditionalBreakPointManager getInstance() {
        if (pyConditionalBreakPointManager == null) {
            pyConditionalBreakPointManager = new PyConditionalBreakPointManager();
        }
        return pyConditionalBreakPointManager;
    }

    public void handleBreakpointException(final AbstractDebugTarget target, String payload) {
        if (payload.indexOf(DELIMETER) > 0) {
            final String[] exceptionDetailList = payload.split(DELIMETER);
            RunInUiThread.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    String errorMessage = "An exception has occurred when evaluating a conditional breakpoint:\n\n\n" + exceptionDetailList[0];
                    List<Object> exceptionStackTraceList = new ArrayList();
                    Shell shell = new Shell(Display.getCurrent());
                    shell.setText(PyConditionalBreakPointManager.SHELL_TEXT);
                    MultiStatus multiStatusInfo = new MultiStatus(PyConditionalBreakPointManager.PID, 1, errorMessage, null);
                    multiStatusInfo.add((IStatus)new Status(4, PyConditionalBreakPointManager.PID, 1, PyConditionalBreakPointManager.PYTHON_TRACEBACK, null));
                    try {
                        exceptionStackTraceList = XMLUtils.getExceptionStackTrace(target, exceptionDetailList[1]);
                    }
                    catch (Exception exception) {
                        Log.log((Throwable)exception);
                    }
                    if (exceptionStackTraceList != null) {
                        for (ExceptionStackTrace exceptionStackTrace : exceptionStackTraceList) {
                            multiStatusInfo.add((IStatus)new Status(4, PyConditionalBreakPointManager.PID, 1, exceptionStackTrace.toString(), null));
                        }
                    }
                    ErrorDialog.openError((Shell)shell, (String)PyConditionalBreakPointManager.TITLE, null, (IStatus)multiStatusInfo);
                }
            });
        }
    }

    static class ExceptionStackTrace {
        private AbstractDebugTarget target;
        private String filename;
        private int lineNo;
        private String methodName;
        private String methodObj;

        public ExceptionStackTrace(AbstractDebugTarget target, String filename, int lineNo, String methodName, String methodObj) {
            this.target = target;
            this.filename = filename;
            this.lineNo = lineNo;
            this.methodName = methodName;
            this.methodObj = methodObj;
        }

        public String toString() {
            return StringUtils.join((String)"", (Object[])new Object[]{"tFile ", this.filename, "\n line ", this.lineNo, ", in", this.methodName, ", ", this.methodObj});
        }
    }
}

