/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.texteditor.IUpdate;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.console.PromptOverlay;
import org.python.pydev.debug.console.SetBufferedOutputAction;
import org.python.pydev.debug.console.SetFullLayoutAction;
import org.python.pydev.debug.console.SetLayoutAction;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.actions.BaseAction;

public class ShowPromptOverlayAction
extends BaseAction
implements IUpdate,
IEditorActionDelegate,
IPropertyChangeListener {
    private final WeakReference<PromptOverlay> promptOverlay;
    private Menu fMenu;
    private final IPreferenceStore preferences;
    private final SetLayoutAction setLayoutAction;
    private final SetFullLayoutAction setFullLayoutAction;
    private final SetBufferedOutputAction setBufferedOutputAction;
    private IMenuCreator menuCreator;

    public ShowPromptOverlayAction(PromptOverlay promptOverlay) {
        this.promptOverlay = new WeakReference<PromptOverlay>(promptOverlay);
        this.preferences = PydevDebugPlugin.getDefault().getPreferenceStore();
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setLayoutAction = new SetLayoutAction(this.promptOverlay);
        this.setFullLayoutAction = new SetFullLayoutAction(this.promptOverlay);
        this.setBufferedOutputAction = new SetBufferedOutputAction(this.promptOverlay);
        this.update();
        this.menuCreator = new IMenuCreator(){

            public Menu getMenu(Menu parent) {
                return null;
            }

            public void dispose() {
                if (ShowPromptOverlayAction.this.fMenu != null) {
                    ShowPromptOverlayAction.this.fMenu.dispose();
                }
                ShowPromptOverlayAction.this.fMenu = null;
            }

            public Menu getMenu(Control parent) {
                if (ShowPromptOverlayAction.this.fMenu != null) {
                    ShowPromptOverlayAction.this.fMenu.dispose();
                }
                ShowPromptOverlayAction.this.fMenu = new Menu(parent);
                this.addActionToMenu(ShowPromptOverlayAction.this.fMenu, ShowPromptOverlayAction.this.setLayoutAction);
                this.addActionToMenu(ShowPromptOverlayAction.this.fMenu, ShowPromptOverlayAction.this.setFullLayoutAction);
                this.addActionToMenu(ShowPromptOverlayAction.this.fMenu, ShowPromptOverlayAction.this.setBufferedOutputAction);
                return ShowPromptOverlayAction.this.fMenu;
            }

            private void addActionToMenu(Menu parent, Action action) {
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(parent, -1);
            }
        };
        this.setMenuCreator(this.menuCreator);
    }

    public void update() {
        PromptOverlay overlay = (PromptOverlay)this.promptOverlay.get();
        if (overlay == null) {
            return;
        }
        boolean show = this.preferences.getBoolean("SHOW_CONSOLE_PROMPT_ON_DEBUG");
        if (show) {
            this.setImageDescriptor(SharedUiPlugin.getImageCache().getDescriptor("icons/console_enabled.png"));
            this.setToolTipText("Hide console prompt");
        } else {
            this.setImageDescriptor(SharedUiPlugin.getImageCache().getDescriptor("icons/console_disabled.png"));
            this.setToolTipText("Show console prompt");
        }
        overlay.setOverlayVisible(show);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("SHOW_CONSOLE_PROMPT_ON_DEBUG".equals(event.getProperty())) {
            this.update();
        }
    }

    public void run(IAction action) {
        this.preferences.setValue("SHOW_CONSOLE_PROMPT_ON_DEBUG", !this.preferences.getBoolean("SHOW_CONSOLE_PROMPT_ON_DEBUG"));
        if (this.preferences instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.preferences).save();
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void run() {
        this.run((IAction)this);
    }

    public void dispose() {
        this.menuCreator.dispose();
        this.preferences.removePropertyChangeListener((IPropertyChangeListener)this);
        this.setLayoutAction.dispose();
        this.setBufferedOutputAction.dispose();
    }
}

