/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.plugin.nature.PythonNature;

public class PythonFileRunner {
    public static ILaunch launch(IFile file, String arguments) throws CoreException {
        try {
            ILaunchConfigurationWorkingCopy conf = PythonFileRunner.getLaunchConfiguration(file, arguments);
            return conf.launch("run", null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ILaunchConfigurationWorkingCopy getLaunchConfiguration(IFile resource, String programArguments) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        String launchConfigurationType;
        String vmargs = "";
        IProject project = resource.getProject();
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(launchConfigurationType = PythonFileRunner.configurationFor(nature.getInterpreterType()));
        if (type == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus((int)4, (String)"Python launch configuration not found", null));
        }
        String location = resource.getRawLocation().toString();
        String name = manager.generateUniqueLaunchConfigurationNameFrom(resource.getName());
        String baseDirectory = new File(location).getParent();
        int resourceType = 1;
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        workingCopy.setAttribute("org.python.pydev.debug.ATTR_PROJECT", project.getName());
        workingCopy.setAttribute("org.python.pydev.debug.ATTR_RESOURCE_TYPE", resourceType);
        workingCopy.setAttribute("org.python.pydev.debug.ATTR_INTERPRETER", nature.getProjectInterpreter().getExecutableOrJar());
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", baseDirectory);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", programArguments);
        workingCopy.setAttribute("org.python.pydev.debug.vm.arguments", vmargs);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        workingCopy.setAttribute("org.eclipse.debug.core.capture_output", true);
        workingCopy.setMappedResources(new IResource[]{resource});
        return workingCopy;
    }

    private static String configurationFor(int interpreterType) {
        switch (interpreterType) {
            case 2: {
                return "org.python.pydev.debug.ironpythonLaunchConfigurationType";
            }
            case 1: {
                return "org.python.pydev.debug.jythonLaunchConfigurationType";
            }
            case 0: {
                return "org.python.pydev.debug.regularLaunchConfigurationType";
            }
        }
        throw new RuntimeException("Unknown Python interpreter type");
    }
}

