/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.debug.ui.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.PydevConsoleFactory;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.env.PydevIProcessFactory;
import org.python.pydev.django.debug.ui.actions.DjangoAction;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_ui.EditorUtils;

public class DjangoShell
extends DjangoAction {
    @Override
    public void run(IAction action) {
        try {
            PythonNature nature = PythonNature.getPythonNature((IProject)this.selectedProject);
            if (nature == null) {
                MessageDialog.openError((Shell)EditorUtils.getShell(), (String)"PyDev nature not found", (String)"Unable to perform action because the Pydev nature is not properly set.");
                return;
            }
            IPythonPathNature pythonPathNature = nature.getPythonPathNature();
            String settingsModule = null;
            Map variableSubstitution = null;
            try {
                variableSubstitution = pythonPathNature.getVariableSubstitution();
                settingsModule = (String)variableSubstitution.get("DJANGO_SETTINGS_MODULE");
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            if (settingsModule == null) {
                InputDialog d = new InputDialog(EditorUtils.getShell(), "Settings module", "Please enter the settings module to be used.\n\nNote that it can be edited later in:\nproject properties > pydev pythonpath > string substitution variables.", String.valueOf(this.selectedProject.getName()) + ".settings", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "Text must be entered.";
                        }
                        char[] cArray = newText.toCharArray();
                        int n = cArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char c = cArray[n2];
                            if (c == ' ') {
                                return "Whitespaces not accepted";
                            }
                            if (c != '.' && !Character.isJavaIdentifierPart(c)) {
                                return "Invalid char: " + c;
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
                int retCode = d.open();
                if (retCode == 0) {
                    settingsModule = d.getValue();
                    variableSubstitution.put("DJANGO_SETTINGS_MODULE", settingsModule);
                    try {
                        pythonPathNature.setVariableSubstitution(variableSubstitution);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                if (settingsModule == null) {
                    return;
                }
            }
            List<PythonNature> natures = Collections.singletonList(nature);
            PydevConsoleFactory consoleFactory = new PydevConsoleFactory();
            PydevIProcessFactory.PydevConsoleLaunchInfo launchInfo = new PydevIProcessFactory().createLaunch(nature.getRelatedInterpreterManager(), nature.getProjectInterpreter(), (Collection)nature.getPythonPathNature().getCompleteProjectPythonPath(nature.getProjectInterpreter(), nature.getRelatedInterpreterManager()), (IPythonNature)nature, natures);
            PydevConsoleInterpreter interpreter = PydevConsoleFactory.createPydevInterpreter((PydevIProcessFactory.PydevConsoleLaunchInfo)launchInfo, natures, (String)launchInfo.encoding);
            String djangoAdditionalCommands = PydevDebugPlugin.getDefault().getPreferenceStore().getString("DJANGO_INTERPRETER_CMDS");
            djangoAdditionalCommands = djangoAdditionalCommands.replace("${DJANGO_SETTINGS_MODULE}", settingsModule);
            consoleFactory.createConsole(interpreter, djangoAdditionalCommands);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

