/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.analysis.scopeanalysis.ScopeAnalysis;
import com.python.pydev.refactoring.wizards.rename.AbstractRenameWorkspaceRefactorProcess;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.SequencialASTIteratorVisitor;

public class PyRenameFunctionProcess
extends AbstractRenameWorkspaceRefactorProcess {
    private ASTEntry functionDefEntryCache;

    protected PyRenameFunctionProcess() {
    }

    public PyRenameFunctionProcess(Definition definition) {
        super(definition);
        Assert.isTrue((boolean)(this.definition.ast instanceof FunctionDef));
    }

    @Override
    protected boolean getRecheckWhereDefinitionWasFound() {
        return true;
    }

    private List<ASTEntry> getLocalOccurrences(String occurencesFor, SimpleNode simpleNode, RefactoringStatus status) {
        ArrayList<ASTEntry> ret = new ArrayList<ASTEntry>();
        ASTEntry functionDefEntry = this.getOriginalFunctionInAst(simpleNode);
        if (functionDefEntry == null) {
            status.addFatalError("Unable to find the original definition for the function definition.");
            return ret;
        }
        if (functionDefEntry.parent != null) {
            SimpleNode parentNode = functionDefEntry.parent.node;
            if (parentNode instanceof ClassDef) {
                ret.add(new ASTEntry(functionDefEntry, (SimpleNode)((FunctionDef)functionDefEntry.node).name));
                SequencialASTIteratorVisitor classVisitor = SequencialASTIteratorVisitor.create((SimpleNode)parentNode);
                Iterator it = classVisitor.getIterator(Attribute.class);
                while (it.hasNext()) {
                    ASTEntry entry = (ASTEntry)it.next();
                    List parts = NodeUtils.getAttributeParts((Attribute)((Attribute)entry.node));
                    if (parts.get(1) instanceof Attribute) continue;
                    String rep0 = NodeUtils.getRepresentationString((SimpleNode)((SimpleNode)parts.get(0)));
                    String rep1 = NodeUtils.getRepresentationString((SimpleNode)((SimpleNode)parts.get(1)));
                    if (rep0 == null || rep1 == null || !rep0.equals("self") || !rep1.equals(occurencesFor)) continue;
                    ret.add(entry);
                }
                List attributeReferences = ScopeAnalysis.getAttributeReferences((String)occurencesFor, (SimpleNode)simpleNode);
                NameTokType funcName = ((FunctionDef)functionDefEntry.node).name;
                for (ASTEntry entry : attributeReferences) {
                    if (entry.node == funcName) continue;
                    if (entry.node instanceof NameTok) {
                        NameTok nameTok = (NameTok)entry.node;
                        if (nameTok.ctx == 1) continue;
                    }
                    ret.add(entry);
                }
            } else if (parentNode instanceof FunctionDef) {
                ret.addAll(ScopeAnalysis.getLocalOccurrences((String)occurencesFor, (SimpleNode)parentNode));
            }
        } else {
            ret.addAll(ScopeAnalysis.getLocalOccurrences((String)occurencesFor, (SimpleNode)simpleNode));
        }
        if (ret.size() > 0) {
            ret.addAll(ScopeAnalysis.getCommentOccurrences((String)occurencesFor, (SimpleNode)simpleNode));
            ret.addAll(ScopeAnalysis.getStringOccurrences((String)occurencesFor, (SimpleNode)simpleNode));
        }
        return ret;
    }

    private ASTEntry getOriginalFunctionInAst(SimpleNode simpleNode) {
        if (this.functionDefEntryCache == null) {
            SequencialASTIteratorVisitor visitor = SequencialASTIteratorVisitor.create((SimpleNode)simpleNode);
            Iterator it = visitor.getIterator(FunctionDef.class);
            ASTEntry functionDefEntry = null;
            while (it.hasNext()) {
                functionDefEntry = (ASTEntry)it.next();
                if (functionDefEntry.node.beginLine != this.definition.ast.beginLine || functionDefEntry.node.beginColumn != this.definition.ast.beginColumn) continue;
                this.functionDefEntryCache = functionDefEntry;
                break;
            }
        }
        return this.functionDefEntryCache;
    }

    @Override
    protected void findReferencesToRenameOnLocalScope(RefactoringRequest request, RefactoringStatus status) {
        SimpleNode root = request.getAST();
        if (!this.definition.module.getName().equals(request.moduleName)) {
            this.docOccurrences.addAll(this.getEntryOccurrencesInOtherModule(request.initialName, root));
        } else {
            this.docOccurrences.addAll(this.getEntryOccurrencesInSameModule(status, request.initialName, root));
        }
    }

    protected List<ASTEntry> getEntryOccurrencesInSameModule(RefactoringStatus status, String initialName, SimpleNode root) {
        return this.getLocalOccurrences(initialName, root, status);
    }

    protected List<ASTEntry> getEntryOccurrencesInOtherModule(String initialName, SimpleNode root) {
        List ret = ScopeAnalysis.getLocalOccurrences((String)initialName, (SimpleNode)root, (boolean)false);
        if (ret.size() > 0) {
            ret.addAll(ScopeAnalysis.getCommentOccurrences((String)initialName, (SimpleNode)root));
            ret.addAll(ScopeAnalysis.getStringOccurrences((String)initialName, (SimpleNode)root));
        }
        return ret;
    }

    @Override
    protected List<ASTEntry> findReferencesOnOtherModule(RefactoringStatus status, RefactoringRequest request, String initialName, SourceModule module) {
        SimpleNode root = module.getAst();
        if (!this.definition.module.getName().equals(module.getName())) {
            return this.getEntryOccurrencesInOtherModule(initialName, root);
        }
        return this.getLocalOccurrences(initialName, root, status);
    }
}

