/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.ui.findreplace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_ui.EditorUtils;

public class FindInOpenDocuments {
    public static void findInOpenDocuments(final String searchText, final boolean caseSensitive, boolean wholeWord, final boolean isRegEx, IStatusLineManager statusLineManager) {
        List opened = EditorUtils.getFilesInOpenEditors((IStatusLineManager)statusLineManager);
        final ArrayList<IFile> files = new ArrayList<IFile>(opened.size());
        for (Object object : opened) {
            if (!(object instanceof IFile)) continue;
            files.add((IFile)object);
        }
        if (files.size() == 0) {
            if (statusLineManager != null) {
                statusLineManager.setMessage("No file was found to perform the search (editors not in the workspace cannot be searched).");
            }
            return;
        }
        try {
            ISearchQuery query = TextSearchQueryProvider.getPreferred().createQuery(new TextSearchQueryProvider.TextSearchInput(){

                public boolean isRegExSearch() {
                    return isRegEx;
                }

                public boolean isCaseSensitiveSearch() {
                    return caseSensitive;
                }

                public String getSearchText() {
                    return searchText;
                }

                public FileTextSearchScope getScope() {
                    return FileTextSearchScope.newSearchScope((IResource[])files.toArray(new IResource[files.size()]), (String[])new String[]{"*"}, (boolean)true);
                }
            });
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
        catch (CoreException e1) {
            Log.log((Throwable)e1);
        }
    }
}

