/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.tdd;

import com.python.pydev.analysis.ctrl_1.AbstractAnalysisMarkersParticipants;
import com.python.pydev.refactoring.tdd.PyCreateMethodOrField;
import com.python.pydev.refactoring.tdd.TddQuickFixParticipant;
import com.python.pydev.refactoring.tdd.TddRefactorCompletion;
import com.python.pydev.refactoring.tdd.TddRefactorCompletionInModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.EasyASTIteratorVisitor;
import org.python.pydev.parser.visitors.scope.ReturnVisitor;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.ImageCache;

public class TddCodeGenerationQuickFixParticipant
extends AbstractAnalysisMarkersParticipants {
    private TddQuickFixParticipant tddQuickFixParticipant;
    public static ICallback<Boolean, Exception> onGetTddPropsError;

    protected void fillParticipants() {
        this.tddQuickFixParticipant = new TddQuickFixParticipant();
        this.participants.add(this.tddQuickFixParticipant);
    }

    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        List ret = super.getProps(ps, imageCache, f, nature, edit, offset);
        this.getTddProps(ps, imageCache, f, nature, edit, offset, ret);
        return ret;
    }

    public List<ICompletionProposal> getTddProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset, List<ICompletionProposal> ret) {
        if (ret == null) {
            ret = new ArrayList<ICompletionProposal>();
        }
        int lineOfOffset = ps.getLineOfOffset(offset);
        String lineContents = ps.getLine(lineOfOffset);
        List callsAtLine = ps.getTddPossibleMatchesAtLine();
        if (callsAtLine.size() > 0) {
            HashMap<String, PySelection.TddPossibleMatches> callsToCheck = new HashMap<String, PySelection.TddPossibleMatches>();
            for (PySelection.TddPossibleMatches tddPossibleMatches : callsAtLine) {
                String callString = String.valueOf(tddPossibleMatches.initialPart) + tddPossibleMatches.secondPart;
                callsToCheck.put(callString, tddPossibleMatches);
            }
            block5: for (Map.Entry entry : callsToCheck.entrySet()) {
                IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
                try {
                    PySelection.TddPossibleMatches possibleMatch = (PySelection.TddPossibleMatches)entry.getValue();
                    String callWithoutParens = (String)entry.getKey();
                    ItemPointer[] pointers = null;
                    PySelection callPs = null;
                    PySelection.TddPossibleMatches lastPossibleMatchNotFound = possibleMatch;
                    int i = 0;
                    while (i < 10) {
                        String full;
                        int indexOf;
                        lastPossibleMatchNotFound = possibleMatch;
                        if (i > 0) {
                            String line = FullRepIterable.getWithoutLastPart((String)possibleMatch.full);
                            List tddPossibleMatchesAtLine = ps.getTddPossibleMatchesAtLine(line);
                            if (tddPossibleMatchesAtLine.size() <= 0) continue block5;
                            possibleMatch = (PySelection.TddPossibleMatches)tddPossibleMatchesAtLine.get(0);
                            callWithoutParens = String.valueOf(possibleMatch.initialPart) + possibleMatch.secondPart;
                        }
                        if ((indexOf = lineContents.indexOf(full = possibleMatch.full)) < 0) {
                            Log.log((String)"Did not expect index < 0.");
                            continue block5;
                        }
                        callPs = new PySelection(ps.getDoc(), ps.getLineOffset() + indexOf + callWithoutParens.length());
                        RefactoringRequest request = new RefactoringRequest(f, callPs, null, nature, edit);
                        request.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)false);
                        pointers = pyRefactoring.findDefinition(request);
                        if (pointers != null && pointers.length > 0 || StringUtils.count((String)possibleMatch.full, (char)'.') <= 1) break;
                        ++i;
                    }
                    if (pointers == null || callPs == null) continue;
                    if (lastPossibleMatchNotFound != null && lastPossibleMatchNotFound != possibleMatch && pointers.length >= 1) {
                        String methodToCreate = FullRepIterable.getLastPart((String)lastPossibleMatchNotFound.secondPart);
                        int absoluteCursorOffset = callPs.getAbsoluteCursorOffset();
                        PySelection newSelection = new PySelection(callPs.getDoc(), absoluteCursorOffset -= 1 + methodToCreate.length());
                        this.checkCreationBasedOnFoundPointers(edit, callPs, ret, possibleMatch, pointers, methodToCreate, newSelection, nature);
                        continue;
                    }
                    if (pointers.length >= 1) {
                        if (this.checkInitCreation(edit, callPs, pointers, ret)) continue;
                        boolean foundInInit = false;
                        ItemPointer[] itemPointerArray = pointers;
                        int n = pointers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            void p = itemPointerArray[n2];
                            Definition definition = p.definition;
                            try {
                                FunctionDef functionDef;
                                String rep;
                                Object peek = definition.scope.getScopeStack().peek();
                                if (peek instanceof FunctionDef && (rep = NodeUtils.getRepresentationString((SimpleNode)(functionDef = (FunctionDef)peek))) != null && rep.equals("__init__")) {
                                    foundInInit = true;
                                    break;
                                }
                            }
                            catch (Exception exception) {}
                            ++n2;
                        }
                        if (foundInInit) continue;
                        this.checkMethodCreationAtClass(edit, pyRefactoring, callWithoutParens, callPs, ret, lineContents, possibleMatch, f, nature);
                        continue;
                    }
                    if (pointers.length != 0) continue;
                    this.checkMethodCreationAtClass(edit, pyRefactoring, callWithoutParens, callPs, ret, lineContents, possibleMatch, f, nature);
                }
                catch (Exception e) {
                    if (onGetTddPropsError != null) {
                        onGetTddPropsError.call((Object)e);
                    }
                    Log.log((Throwable)e);
                }
            }
        }
        return ret;
    }

    private boolean checkMethodCreationAtClass(PyEdit edit, IPyRefactoring pyRefactoring, String callWithoutParens, PySelection callPs, List<ICompletionProposal> ret, String lineContents, PySelection.TddPossibleMatches possibleMatch, File f, IPythonNature nature) throws MisconfigurationException, Exception {
        String[] headAndTail = FullRepIterable.headAndTail((String)callWithoutParens);
        if (headAndTail[0].length() > 0) {
            String methodToCreate = headAndTail[1];
            if (headAndTail[0].equals("self")) {
                int firstCharPosition = PySelection.getFirstCharPosition((String)lineContents);
                PySelection.LineStartingScope scopeStart = callPs.getPreviousLineThatStartsScope(PySelection.CLASS_TOKEN, false, firstCharPosition);
                String classNameInLine = null;
                if (scopeStart != null) {
                    Boolean[] booleanArray = new Boolean[]{true, false};
                    int n = booleanArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Boolean isCall = booleanArray[n2];
                        PyCreateMethodOrField pyCreateMethod = new PyCreateMethodOrField();
                        List<String> parametersAfterCall = null;
                        parametersAfterCall = this.configCreateAsAndReturnParametersAfterCall(callPs, isCall, pyCreateMethod, parametersAfterCall, methodToCreate);
                        String startingScopeLineContents = callPs.getLine(scopeStart.iLineStartingScope);
                        classNameInLine = PySelection.getClassNameInLine((String)startingScopeLineContents);
                        if (classNameInLine != null && classNameInLine.length() > 0) {
                            pyCreateMethod.setCreateInClass(classNameInLine);
                            this.addCreateMethodOption(callPs, edit, ret, methodToCreate, parametersAfterCall, pyCreateMethod, classNameInLine);
                        }
                        ++n2;
                    }
                }
                return true;
            }
            int absoluteCursorOffset = callPs.getAbsoluteCursorOffset();
            PySelection newSelection = new PySelection(callPs.getDoc(), absoluteCursorOffset -= 1 + methodToCreate.length());
            RefactoringRequest request = new RefactoringRequest(f, newSelection, null, nature, edit);
            request.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)false);
            ItemPointer[] pointers = pyRefactoring.findDefinition(request);
            if (pointers.length == 1 && this.checkCreationBasedOnFoundPointers(edit, callPs, ret, possibleMatch, pointers, methodToCreate, newSelection, nature)) {
                return true;
            }
        }
        return false;
    }

    public Definition rebaseAssignDefinition(AssignDefinition assignDef, IPythonNature nature, ICompletionCache completionCache) throws Exception {
        if (assignDef.value.equals("None")) {
            return assignDef;
        }
        IDefinition[] definitions2 = assignDef.module.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)assignDef.value, (IPythonNature)nature, (ICompletionCache)completionCache), assignDef.line, assignDef.col, nature);
        if (definitions2.length > 0) {
            return (Definition)definitions2[0];
        }
        return assignDef;
    }

    public Definition rebaseFunctionDef(Definition definition, IPythonNature nature, ICompletionCache completionCache) throws Exception {
        List returns = ReturnVisitor.findReturns((FunctionDef)((FunctionDef)definition.ast));
        for (Return returnFound : returns) {
            IDefinition[] definitions2;
            String act = NodeUtils.getFullRepresentationString((SimpleNode)returnFound.value);
            if (act == null || (definitions2 = definition.module.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)act, (IPythonNature)nature, (ICompletionCache)completionCache), definition.line, definition.col, nature)).length != 1) continue;
            return (Definition)definitions2[0];
        }
        return definition;
    }

    private Definition rebaseToClassDefDefinition(IPythonNature nature, CompletionCache completionCache, Definition definition, CompletionState completionState) throws CompletionRecursionException, Exception {
        if (completionState == null) {
            completionState = new CompletionState();
        }
        if (definition.ast instanceof ClassDef) {
            return definition;
        }
        if (definition instanceof AssignDefinition || definition.ast instanceof FunctionDef) {
            completionState.checkDefinitionMemory(definition.module, (IDefinition)definition);
            definition = definition instanceof AssignDefinition ? this.rebaseAssignDefinition((AssignDefinition)definition, nature, (ICompletionCache)completionCache) : this.rebaseFunctionDef(definition, nature, (ICompletionCache)completionCache);
            return this.rebaseToClassDefDefinition(nature, completionCache, definition, completionState);
        }
        return definition;
    }

    public boolean checkCreationBasedOnFoundPointers(PyEdit edit, PySelection callPs, List<ICompletionProposal> ret, PySelection.TddPossibleMatches possibleMatch, ItemPointer[] pointers, String methodToCreate, PySelection newSelection, IPythonNature nature) throws MisconfigurationException, Exception {
        CompletionCache completionCache = new CompletionCache();
        ItemPointer[] itemPointerArray = pointers;
        int n = pointers.length;
        int n2 = 0;
        while (n2 < n) {
            ItemPointer pointer = itemPointerArray[n2];
            Definition definition = pointer.definition;
            try {
                definition = this.rebaseToClassDefDefinition(nature, completionCache, definition, null);
            }
            catch (CompletionRecursionException e) {
                Log.log((Throwable)e);
            }
            if (definition.ast instanceof ClassDef) {
                ClassDef d = (ClassDef)definition.ast;
                String fullName = String.valueOf(NodeUtils.getRepresentationString((SimpleNode)d)) + "." + methodToCreate;
                IToken repInModule = nature.getAstManager().getRepInModule(definition.module, fullName, nature);
                if (repInModule == null) {
                    Boolean[] booleanArray = new Boolean[]{true, false};
                    int n3 = booleanArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Boolean isCall = booleanArray[n4];
                        PyCreateMethodOrField pyCreateMethod = new PyCreateMethodOrField();
                        List<String> parametersAfterCall = null;
                        parametersAfterCall = this.configCreateAsAndReturnParametersAfterCall(callPs, isCall, pyCreateMethod, parametersAfterCall, methodToCreate);
                        String className = NodeUtils.getRepresentationString((SimpleNode)d);
                        pyCreateMethod.setCreateInClass(className);
                        String displayString = StringUtils.format((String)"Create %s %s at %s (%s)", (Object[])new Object[]{methodToCreate, pyCreateMethod.getCreationStr(), className, definition.module.getName()});
                        TddRefactorCompletionInModule completion = new TddRefactorCompletionInModule(methodToCreate, this.tddQuickFixParticipant != null ? this.tddQuickFixParticipant.imageMethod : null, displayString, null, displayString, 5, edit, definition.module.getFile(), parametersAfterCall, pyCreateMethod, newSelection);
                        completion.locationStrategy = 1;
                        ret.add((ICompletionProposal)completion);
                        ++n4;
                    }
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private List<String> configCreateAsAndReturnParametersAfterCall(PySelection callPs, boolean isCall, PyCreateMethodOrField pyCreateMethod, List<String> parametersAfterCall, String methodToCreate) {
        if (isCall) {
            pyCreateMethod.setCreateAs(0);
            parametersAfterCall = callPs.getParametersAfterCall(callPs.getAbsoluteCursorOffset());
        } else if (StringUtils.isAllUpper((String)methodToCreate)) {
            pyCreateMethod.setCreateAs(4);
        } else {
            pyCreateMethod.setCreateAs(3);
        }
        return parametersAfterCall;
    }

    private void addCreateMethodOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, List<String> parametersAfterCall, PyCreateMethodOrField pyCreateMethod, String classNameInLine) {
        String displayString = StringUtils.format((String)"Create %s %s at %s", (Object[])new Object[]{markerContents, pyCreateMethod.getCreationStr(), classNameInLine});
        TddRefactorCompletion tddRefactorCompletion = new TddRefactorCompletion(markerContents, this.tddQuickFixParticipant.imageMethod, displayString, null, null, 5, edit, 0, parametersAfterCall, pyCreateMethod, ps);
        props.add((ICompletionProposal)tddRefactorCompletion);
    }

    private boolean checkInitCreation(PyEdit edit, PySelection callPs, ItemPointer[] pointers, List<ICompletionProposal> ret) {
        ItemPointer[] itemPointerArray = pointers;
        int n = pointers.length;
        int n2 = 0;
        while (n2 < n) {
            ClassDef d;
            ASTEntry initEntry;
            ItemPointer pointer = itemPointerArray[n2];
            Definition definition = pointer.definition;
            if (definition != null && definition.ast instanceof ClassDef && (initEntry = TddCodeGenerationQuickFixParticipant.findInitInClass(d = (ClassDef)definition.ast)) == null) {
                PyCreateMethodOrField pyCreateMethod = new PyCreateMethodOrField();
                pyCreateMethod.setCreateAs(0);
                String className = NodeUtils.getRepresentationString((SimpleNode)d);
                pyCreateMethod.setCreateInClass(className);
                List parametersAfterCall = callPs.getParametersAfterCall(callPs.getAbsoluteCursorOffset());
                String displayString = StringUtils.format((String)"Create %s __init__ (%s)", (Object[])new Object[]{className, definition.module.getName()});
                TddRefactorCompletionInModule completion = new TddRefactorCompletionInModule("__init__", this.tddQuickFixParticipant.imageMethod, displayString, null, displayString, 5, edit, definition.module.getFile(), parametersAfterCall, pyCreateMethod, callPs);
                completion.locationStrategy = 2;
                ret.add((ICompletionProposal)completion);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ASTEntry findInitInClass(ClassDef d) {
        EasyASTIteratorVisitor visitor = EasyASTIteratorVisitor.create((SimpleNode)d);
        Iterator it = visitor.getMethodsIterator();
        while (it.hasNext()) {
            String rep;
            ASTEntry next = (ASTEntry)it.next();
            if (next.node == null || !"__init__".equals(rep = NodeUtils.getRepresentationString((SimpleNode)next.node))) continue;
            return next;
        }
        return null;
    }
}

