/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search;

import com.python.pydev.refactoring.refactorer.search.PythonFileSearchResult;
import com.python.pydev.refactoring.refactorer.search.copied.SearchResultUpdater;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.python.pydev.shared_ui.search.ICustomSearchQuery;
import org.python.pydev.shared_ui.search.replace.PatternConstructor;

public abstract class AbstractPythonSearchQuery
implements ISearchQuery,
ICustomSearchQuery {
    private final FileTextSearchScope fScope;
    private final String fSearchText;
    private final boolean fIsRegEx;
    private final boolean fIsCaseSensitive;
    private PythonFileSearchResult fResult;
    private boolean fIsWholeWord;

    public AbstractPythonSearchQuery(String searchText) {
        this(searchText, false, true, true, null);
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return "Python Search";
    }

    protected boolean isScopeAllFileTypes() {
        return false;
    }

    public abstract String getResultLabel(int var1);

    public AbstractPythonSearchQuery(String searchText, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, FileTextSearchScope scope) {
        this.fSearchText = searchText;
        this.fIsRegEx = isRegEx;
        this.fIsCaseSensitive = isCaseSensitive;
        this.fIsWholeWord = isWholeWord;
        this.fScope = scope;
    }

    public FileTextSearchScope getSearchScope() {
        return this.fScope;
    }

    public abstract IStatus run(IProgressMonitor var1);

    public String getSearchString() {
        return this.fSearchText;
    }

    protected Pattern getSearchPattern() {
        return PatternConstructor.createPattern((String)this.fSearchText, (boolean)this.fIsRegEx, (boolean)true, (boolean)this.fIsCaseSensitive, (boolean)this.fIsWholeWord);
    }

    public boolean isWholeWord() {
        return this.fIsWholeWord;
    }

    public boolean isFileNameSearch() {
        return this.fSearchText.length() == 0;
    }

    public boolean isRegexSearch() {
        return this.fIsRegEx;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new PythonFileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }
}

