/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer;

import com.python.pydev.refactoring.IPyRefactoring2;
import com.python.pydev.refactoring.refactorer.RefactorerFindDefinition;
import com.python.pydev.refactoring.refactorer.RefactorerFinds;
import com.python.pydev.refactoring.wizards.RefactorProcessFactory;
import com.python.pydev.refactoring.wizards.rename.PyReferenceSearcher;
import com.python.pydev.refactoring.wizards.rename.PyRenameEntryPoint;
import com.python.pydev.refactoring.wizards.rename.PyRenameRefactoringWizard;
import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoringRequest;
import org.python.pydev.editor.refactoring.ModuleRenameRefactoringRequest;
import org.python.pydev.editor.refactoring.MultiModuleMoveRefactoringRequest;
import org.python.pydev.editor.refactoring.PyRefactoringRequest;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.editor.refactoring.TooManyMatchesException;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.EditorUtils;

public class Refactorer
extends AbstractPyRefactoring
implements IPyRefactoring2 {
    public String getName() {
        return "PyDev Extensions Refactorer";
    }

    public String rename(IPyRefactoringRequest request) {
        try {
            RefactoringRequest req;
            List actualRequests = request.getRequests();
            if (actualRequests.size() == 1 && !(req = (RefactoringRequest)actualRequests.get(0)).isModuleRenameRefactoringRequest()) {
                ItemPointer[] pointers;
                IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
                ItemPointer[] itemPointerArray = pointers = pyRefactoring.findDefinition(req);
                int n = pointers.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemPointer pointer = itemPointerArray[n2];
                    Definition definition = pointer.definition;
                    if (RefactorProcessFactory.isModuleRename(definition)) {
                        try {
                            request = new PyRefactoringRequest(new RefactoringRequest[]{new ModuleRenameRefactoringRequest(definition.module.getFile(), req.nature, null)});
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ++n2;
                }
            }
            PyRenameEntryPoint entryPoint = new PyRenameEntryPoint(request);
            RenameRefactoring renameRefactoring = new RenameRefactoring((RenameProcessor)entryPoint);
            request.fillInitialNameAndOffset();
            String title = "Rename";
            if (request instanceof MultiModuleMoveRefactoringRequest) {
                MultiModuleMoveRefactoringRequest multiModuleMoveRefactoringRequest = (MultiModuleMoveRefactoringRequest)request;
                title = "Move To package (project: " + multiModuleMoveRefactoringRequest.getTarget().getProject().getName() + ")";
            }
            PyRenameRefactoringWizard wizard = new PyRenameRefactoringWizard((Refactoring)renameRefactoring, title, "inputPageDescription", request);
            try {
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                op.run(EditorUtils.getShell(), "Rename Refactor Action");
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public ItemPointer[] findDefinition(RefactoringRequest request) throws TooManyMatchesException, BadLocationException {
        return new RefactorerFindDefinition().findDefinition(request);
    }

    public boolean areAllInSameClassHierarchy(List<AssignDefinition> defs) {
        return new RefactorerFinds(this).areAllInSameClassHierarchy(defs);
    }

    public HierarchyNodeModel findClassHierarchy(RefactoringRequest request, boolean findOnlyParents) {
        return new RefactorerFinds(this).findClassHierarchy(request, findOnlyParents);
    }

    public Map<Tuple<String, File>, HashSet<ASTEntry>> findAllOccurrences(RefactoringRequest req) throws OperationCanceledException, CoreException {
        PyReferenceSearcher pyReferenceSearcher = new PyReferenceSearcher(req);
        req.checkCancelled();
        IProgressMonitor monitor = req.getMonitor();
        try {
            monitor.beginTask("Find all occurrences", 100);
            monitor.setTaskName("Find all occurrences");
            try {
                try {
                    req.pushMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    pyReferenceSearcher.prepareSearch(req);
                }
                catch (PyReferenceSearcher.SearchException | BadLocationException throwable) {
                    req.popMonitor().done();
                    monitor.done();
                    return null;
                }
            }
            finally {
                req.popMonitor().done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

