/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.threaded_objects_pool;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.shared_core.structure.Tuple;

public class ThreadedObjectsPool<X> {
    private final int maxSize;
    private final List<Tuple<Object, X>> lst;
    private final Object lock = new Object();

    public ThreadedObjectsPool(int maxSize) {
        Assert.isTrue((maxSize > 0 ? 1 : 0) != 0);
        this.maxSize = maxSize;
        this.lst = new LinkedListWarningOnSlowOperations<Tuple<Object, X>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X getObject(Object configuration) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<Tuple<Object, X>> iterator = this.lst.iterator();
            while (iterator.hasNext()) {
                Tuple<Object, X> tup = iterator.next();
                if (!tup.o1.equals(configuration)) continue;
                iterator.remove();
                return (X)tup.o2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(Object configuration, X obj) {
        Assert.isNotNull(obj);
        Object object = this.lock;
        synchronized (object) {
            while (this.lst.size() + 1 > this.maxSize) {
                this.lst.remove(0);
            }
            this.lst.add(new Tuple<Object, X>(configuration, obj));
        }
    }
}

