/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.structure;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class Location {
    public int line;
    public int column;
    static Location MIN_LOCATION = new Location(0, 0);
    static Location MAX_LOCATION = new Location(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public Location() {
        this.column = 0;
        this.line = 0;
    }

    public Location(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int toOffset(IDocument document) throws BadLocationException {
        return document.getLineOffset(this.line) + this.column;
    }

    public boolean contained(Location start, Location end) {
        boolean endOk;
        boolean startOk;
        boolean bl = startOk = this.line > start.line || this.line == start.line && this.column >= start.column;
        boolean bl2 = startOk ? this.line < end.line || this.line == end.line && this.column <= end.column : (endOk = false);
        return startOk && endOk;
    }

    public String toString() {
        return "L:" + Integer.toString(this.line) + " C:" + Integer.toString(this.column);
    }

    public int compareTo(Location l) {
        if (this.line > l.line) {
            return 1;
        }
        if (this.line < l.line) {
            return -1;
        }
        if (this.column > l.column) {
            return 1;
        }
        if (this.column < l.column) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Location)) {
            return false;
        }
        Location l = (Location)obj;
        return l.line == this.line && l.column == this.column;
    }

    public int hashCode() {
        return this.line * 99 + this.column * 5;
    }

    public static Location offsetToLocation(IDocument document, int offset) {
        try {
            int line = document.getLineOfOffset(offset);
            int line_start = document.getLineOffset(line);
            return new Location(line, offset - line_start);
        }
        catch (BadLocationException badLocationException) {
            return new Location();
        }
    }
}

