/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import java.io.StringReader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.cache.Cache;
import org.python.pydev.shared_core.cache.LRUCache;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.NoPeerAvailableException;
import org.python.pydev.shared_core.structure.Tuple;

public final class StringUtils {
    public static final String EMPTY = "";
    private static final Object md5CacheLock = new Object();
    private static final LRUCache<String, String> md5Cache = new LRUCache(1000);
    public static String BOM_UTF8 = new String(new char[]{'\u00ef', '\u00bb', '\u00bf'});
    public static String BOM_UNICODE = new String(new char[]{'\ufeff'});
    private static Cache<Integer, String> widthToSpaceString = new LRUCache<Integer, String>(8);
    private static final Pattern compiled = Pattern.compile("\\r?\\n|\\r");
    private static final int STATE_LOWER = 0;
    private static final int STATE_UPPER = 1;
    private static final int STATE_NUMBER = 2;

    public static Iterable<String> iterLines(final String string) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new IterLines(string);
            }
        };
    }

    public static Object join(String delimiter, String[] splitted, Class<? extends Object> returnType) {
        int len = splitted.length;
        switch (len) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return splitted[0];
            }
        }
        int delimiterLen = delimiter.length();
        int totalSize = delimiterLen * (len - 1);
        int i = 0;
        while (i < len) {
            totalSize += splitted[i].length();
            ++i;
        }
        char[] buf = new char[totalSize];
        int count = 0;
        String string = splitted[0];
        int strLen = string.length();
        string.getChars(0, strLen, buf, count);
        count += strLen;
        switch (delimiterLen) {
            case 0: {
                int i2 = 1;
                while (i2 < len) {
                    string = splitted[i2];
                    strLen = string.length();
                    string.getChars(0, strLen, buf, count);
                    count += strLen;
                    ++i2;
                }
                break;
            }
            case 1: {
                char delimiterChar = delimiter.charAt(0);
                int i3 = 1;
                while (i3 < len) {
                    buf[count] = delimiterChar;
                    string = splitted[i3];
                    strLen = string.length();
                    string.getChars(0, strLen, buf, ++count);
                    count += strLen;
                    ++i3;
                }
                break;
            }
            case 2: {
                char delimiterChar0 = delimiter.charAt(0);
                char delimiterChar1 = delimiter.charAt(1);
                int i4 = 1;
                while (i4 < len) {
                    buf[count] = delimiterChar0;
                    buf[count + 1] = delimiterChar1;
                    string = splitted[i4];
                    strLen = string.length();
                    string.getChars(0, strLen, buf, count += 2);
                    count += strLen;
                    ++i4;
                }
                break;
            }
            default: {
                int i5 = 1;
                while (i5 < len) {
                    strLen = delimiterLen;
                    delimiter.getChars(0, strLen, buf, count);
                    count += strLen;
                    string = splitted[i5];
                    strLen = string.length();
                    string.getChars(0, strLen, buf, count);
                    count += strLen;
                    ++i5;
                }
                break block4;
            }
        }
        if (returnType == null || returnType == String.class) {
            return new String(buf);
        }
        if (returnType == FastStringBuffer.class) {
            return new FastStringBuffer(buf);
        }
        if (returnType == char[].class) {
            return buf;
        }
        throw new RuntimeException("Don't know how to handle return type: " + returnType);
    }

    public static String join(String delimiter, String[] splitted, int startAtSegment, int endAtSegment) {
        String[] s = new String[endAtSegment - startAtSegment];
        int i = startAtSegment;
        int j = 0;
        while (i < splitted.length && i < endAtSegment) {
            s[j] = splitted[i];
            ++i;
            ++j;
        }
        return StringUtils.join(delimiter, s);
    }

    public static String join(String delimiter, Collection splitted) {
        int size = splitted.size();
        if (size == 0) {
            return EMPTY;
        }
        Object[] arr = new Object[size];
        return StringUtils.join(delimiter, splitted.toArray(arr));
    }

    public static String join(String delimiter, String[] splitted) {
        return (String)StringUtils.join(delimiter, splitted, null);
    }

    public static String join(String delimiter, Object ... splitted) {
        String[] newSplitted = new String[splitted.length];
        int i = 0;
        while (i < splitted.length) {
            Object s = splitted[i];
            newSplitted[i] = s == null ? "null" : s.toString();
            ++i;
        }
        return StringUtils.join(delimiter, newSplitted);
    }

    public static String format(String str, Object ... args) {
        int length = str.length();
        FastStringBuffer buffer = new FastStringBuffer(length + 16 * args.length);
        int j = 0;
        int i = 0;
        int start = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (c == '%' && i + 1 < length) {
                if (i > start) {
                    buffer.append(str.substring(start, i));
                }
                char nextC = str.charAt(i + 1);
                switch (nextC) {
                    case 's': {
                        buffer.appendObject(args[j]);
                        ++j;
                        break;
                    }
                    case '%': {
                        buffer.append('%');
                        ++j;
                    }
                }
                start = ++i + 1;
            }
            ++i;
        }
        if (i > start) {
            buffer.append(str.substring(start, i));
        }
        return buffer.toString();
    }

    public static long parsePositiveLong(FastStringBuffer buf) {
        char[] array = buf.getInternalCharsArray();
        int len = buf.length();
        if (len == 0) {
            throw new NumberFormatException("Empty string received");
        }
        long result = 0L;
        int zeroAsInt = 48;
        int i = 0;
        while (i < len) {
            result *= 10L;
            int c = array[i] - zeroAsInt;
            if (c < 0 || c > 9) {
                throw new NumberFormatException("Error getting positive int from: " + buf);
            }
            result += (long)c;
            ++i;
        }
        return result;
    }

    public static int parsePositiveInt(FastStringBuffer buf) {
        char[] array = buf.getInternalCharsArray();
        int len = buf.length();
        if (len == 0) {
            throw new NumberFormatException("Empty string received");
        }
        int result = 0;
        int zeroAsInt = 48;
        int i = 0;
        while (i < len) {
            result *= 10;
            int c = array[i] - zeroAsInt;
            if (c < 0 || c > 9) {
                throw new NumberFormatException("Error getting positive int from: " + buf);
            }
            result += c;
            ++i;
        }
        return result;
    }

    public static int countLineBreaks(String replacementString) {
        int lineBreaks = 0;
        int ignoreNextNAt = -1;
        int len = replacementString.length();
        int i = 0;
        while (i < len) {
            char c = replacementString.charAt(i);
            if (c == '\r') {
                ++lineBreaks;
                ignoreNextNAt = i + 1;
            } else if (c == '\n' && ignoreNextNAt != i) {
                ++lineBreaks;
            }
            ++i;
        }
        return lineBreaks;
    }

    public static String md5(String str) {
        Object object = md5CacheLock;
        synchronized (object) {
            String obj = (String)md5Cache.getObj(str);
            if (obj != null) {
                return obj;
            }
            try {
                byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                MessageDigest md = MessageDigest.getInstance("MD5");
                String ret = new BigInteger(1, md.digest(bytes)).toString(36).toLowerCase();
                md5Cache.add(str, ret);
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static List<String> split(String string, char toSplit, int maxPartsToSplit) {
        Assert.isTrue((maxPartsToSplit > 0 ? 1 : 0) != 0);
        int len = string.length();
        if (len == 0) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ret = new ArrayList<String>(maxPartsToSplit);
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit) {
                if (last != i) {
                    if (ret.size() == maxPartsToSplit - 1) {
                        ret.add(string.substring(last, len));
                        return ret;
                    }
                    ret.add(string.substring(last, i));
                }
                while (c == toSplit && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (c != toSplit) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    public static List<String> split(String string, String toSplit) {
        int len = string.length();
        if (len == 0) {
            return new ArrayList<String>(0);
        }
        int length = toSplit.length();
        if (length == 1) {
            return StringUtils.split(string, toSplit.charAt(0));
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (length == 0) {
            ret.add(string);
            return ret;
        }
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit.charAt(0) && StringUtils.matches(string, toSplit, i)) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                last = i + toSplit.length();
                i += toSplit.length() - 1;
            }
            ++i;
        }
        if (last < len) {
            ret.add(string.substring(last, len));
        }
        return ret;
    }

    private static boolean matches(String string, String toSplit, int i) {
        int toSplitLen;
        int length = string.length();
        if (length - i >= (toSplitLen = toSplit.length())) {
            int j = 0;
            while (j < toSplitLen) {
                if (string.charAt(i + j) != toSplit.charAt(j)) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public static List<String> split(String string, char toSplit) {
        int len = string.length();
        if (len == 0) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ret = new ArrayList<String>();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (c == toSplit && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (c != toSplit) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    public static List<String> splitInWhiteSpaces(String string) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (Character.isWhitespace(c) && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (!Character.isWhitespace(c)) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    public static List<String> splitInLines(String string) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            buf.append(c);
            if (c == '\r') {
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                    buf.append('\n');
                }
                ret.add(buf.toString());
                buf.clear();
            }
            if (c == '\n') {
                ret.add(buf.toString());
                buf.clear();
            }
            ++i;
        }
        if (buf.length() != 0) {
            ret.add(buf.toString());
        }
        return ret;
    }

    public static List<String> splitInLines(String string, boolean addNewLines) {
        if (addNewLines) {
            return StringUtils.splitInLines(string);
        }
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            buf.append(c);
            if (c == '\r') {
                buf.deleteLast();
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                ret.add(buf.toString());
                buf.clear();
            }
            if (c == '\n') {
                buf.deleteLast();
                ret.add(buf.toString());
                buf.clear();
            }
            ++i;
        }
        if (buf.length() != 0) {
            ret.add(buf.toString());
        }
        return ret;
    }

    public static String removeBom(String contents) {
        if (contents.startsWith(BOM_UTF8)) {
            contents = contents.substring(BOM_UTF8.length());
        }
        return contents;
    }

    public static String createSpaceString(int width) {
        String existing = widthToSpaceString.getObj(width);
        if (existing != null) {
            return existing;
        }
        FastStringBuffer buf = new FastStringBuffer(width);
        buf.appendN(' ', width);
        String newStr = buf.toString();
        widthToSpaceString.add(width, newStr);
        return newStr;
    }

    public static String getWithClosedPeer(char c) {
        switch (c) {
            case '{': {
                return "{}";
            }
            case '(': {
                return "()";
            }
            case '[': {
                return "[]";
            }
            case '<': {
                return "<>";
            }
            case '\'': {
                return "''";
            }
            case '\"': {
                return "\"\"";
            }
        }
        throw new NoPeerAvailableException("Unable to find peer for :" + c);
    }

    public static boolean isOpeningPeer(char lastChar) {
        return lastChar == '(' || lastChar == '[' || lastChar == '{' || lastChar == '<';
    }

    public static boolean isClosingPeer(char lastChar) {
        return lastChar == ')' || lastChar == ']' || lastChar == '}' || lastChar == '>';
    }

    public static char getPeer(char c) {
        switch (c) {
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '>': {
                return '<';
            }
            case '<': {
                return '>';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
            case '/': {
                return '/';
            }
            case '`': {
                return '`';
            }
        }
        throw new NoPeerAvailableException("Unable to find peer for :" + c);
    }

    public static int countChars(char c, StringBuffer line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static int countChars(char c, FastStringBuffer line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static int countChars(char c, String line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static String replaceNewLines(String text, String repl) {
        return compiled.matcher(text).replaceAll(repl);
    }

    public static String replaceAll(String string, String replace, String with) {
        FastStringBuffer ret = new FastStringBuffer(string, 16);
        return ret.replaceAll(replace, with).toString();
    }

    public static String shorten(String nameForUI, int maxLen) {
        if (nameForUI.length() >= maxLen) {
            int first = (maxLen -= 5) / 2;
            int last = maxLen / 2 + maxLen % 2;
            return String.valueOf(nameForUI.substring(0, first)) + " ... " + nameForUI.substring(nameForUI.length() - last, nameForUI.length());
        }
        return nameForUI;
    }

    public static String rightTrim(String input) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) <= ' ') {
            --len;
        }
        return input.substring(0, len);
    }

    public static String leftTrim(String input) {
        int len = input.length();
        int off = 0;
        while (off < len && input.charAt(off) <= ' ') {
            ++off;
        }
        return input.substring(off, len);
    }

    public static int nthIndexOf(String string, char character, int nth) {
        if (nth <= 0) {
            return -1;
        }
        int pos = string.indexOf(character);
        while (--nth > 0 && pos != -1) {
            pos = string.indexOf(character, pos + 1);
        }
        return pos;
    }

    public static int count(String name, char c) {
        int count = 0;
        int len = name.length();
        int i = 0;
        while (i < len) {
            if (name.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static boolean isValidTextString(byte[] buffer, int len) {
        if (len <= 0) {
            return true;
        }
        if (len > buffer.length) {
            len = buffer.length;
        }
        String s = new String(buffer, 0, len, StandardCharsets.ISO_8859_1);
        int maxLen = s.length();
        int i = 0;
        while (i < maxLen) {
            char c = s.charAt(i);
            if (!(c >= ' ' && c <= '\u00ff' || c >= '\t' && c <= '\u000f')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int lastIndexOf(String string, String regex) {
        Pattern pat;
        int index = -1;
        if (string == null || regex == null || string.length() == 0 || regex.length() == 0) {
            return index;
        }
        try {
            pat = Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return index;
        }
        int len = string.length();
        int i = len - 1;
        char c = '\u0000';
        Matcher mat = null;
        while (i >= 0) {
            c = string.charAt(i);
            mat = pat.matcher(String.valueOf(c));
            if (mat.matches()) {
                index = i;
                break;
            }
            --i;
        }
        return index;
    }

    public static <T> String joinIterable(String delimiter, Iterable<T> objs) throws IllegalArgumentException {
        if (objs == null) {
            throw new IllegalArgumentException("objs can't be null!");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter can't be null");
        }
        Iterator<T> iter = objs.iterator();
        if (!iter.hasNext()) {
            return EMPTY;
        }
        String nxt = String.valueOf(iter.next());
        FastStringBuffer buffer = new FastStringBuffer(String.valueOf(nxt), nxt.length());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(String.valueOf(iter.next()));
        }
        return buffer.toString();
    }

    public static String repeatString(String str, int times) {
        String s = String.valueOf(str);
        if (s.length() == 0 || times <= 0) {
            return EMPTY;
        }
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.appendN(s, times);
        return buffer.toString();
    }

    public static int countPercS(String str) {
        int j = 0;
        int len = str.length();
        int i = 0;
        while (i < len) {
            char nextC;
            char c = str.charAt(i);
            if (c == '%' && i + 1 < len && (nextC = str.charAt(i + 1)) == 's') {
                ++j;
                ++i;
            }
            ++i;
        }
        return j;
    }

    public static String stripExtension(String input) {
        return StringUtils.stripFromRigthCharOnwards(input, '.');
    }

    public static String getFileExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        if (name.length() - 1 == i) {
            return EMPTY;
        }
        return name.substring(i + 1);
    }

    public static int rFind(String input, char ch) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) != ch) {
            --len;
        }
        return --len;
    }

    private static String stripFromRigthCharOnwards(String input, char ch) {
        int len = StringUtils.rFind(input, ch);
        if (len == -1) {
            return input;
        }
        return input.substring(0, len);
    }

    public static String stripFromLastSlash(String input) {
        return StringUtils.stripFromRigthCharOnwards(input, '/');
    }

    public static String rightTrim(String input, char charToTrim) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) == charToTrim) {
            --len;
        }
        return input.substring(0, len);
    }

    public static String rightTrimNewLineChars(String input) {
        char c;
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && ((c = input.charAt(off + len - 1)) == '\r' || c == '\n')) {
            --len;
        }
        return input.substring(0, len);
    }

    public static String leftAndRightTrim(String input, char charToTrim) {
        return StringUtils.rightTrim(StringUtils.leftTrim(input, charToTrim), charToTrim);
    }

    public static String leftTrim(String input, char charToTrim) {
        int len = input.length();
        int off = 0;
        while (off < len && input.charAt(off) == charToTrim) {
            ++off;
        }
        return input.substring(off, len);
    }

    public static String replaceAllSlashes(String string) {
        int len = string.length();
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == '\\') {
                char[] ds = string.toCharArray();
                ds[i] = 47;
                int j = i;
                while (j < len) {
                    if (ds[j] == '\\') {
                        ds[j] = 47;
                    }
                    ++j;
                }
                return new String(ds);
            }
            ++i;
        }
        return string;
    }

    public static String extractTextFromHTML(String html) {
        try {
            HTMLEditorKit kit = new HTMLEditorKit();
            Document doc = ((EditorKit)kit).createDefaultDocument();
            doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            StringReader rd = new StringReader(html);
            ((EditorKit)kit).read(rd, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (Exception exception) {
            return EMPTY;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean split(String string, char toSplit, ICallbackOnSplit onSplit) {
        len = string.length();
        last = 0;
        c = '\u0000';
        i = 0;
        while (i < len) {
            block2: {
                c = string.charAt(i);
                if (c != toSplit) break block2;
                if (last == i || onSplit.call(string.substring(last, i))) ** GOTO lbl11
                return false;
lbl-1000:
                // 1 sources

                {
                    c = string.charAt(++i);
lbl11:
                    // 2 sources

                    ** while (c == toSplit && i < len - 1)
                }
lbl12:
                // 1 sources

                last = i;
            }
            ++i;
        }
        return c == toSplit || !(last == 0 && len > 0 ? onSplit.call(string) == false : last < len && onSplit.call(string.substring(last, len)) == false);
    }

    public static List<String> split(String string, char ... toSplit) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (StringUtils.contains(c, toSplit)) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (StringUtils.contains(c, toSplit) && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (!StringUtils.contains(c, toSplit)) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    private static boolean contains(char c, char[] toSplit) {
        char[] cArray = toSplit;
        int n = toSplit.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (c == ch) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<String> splitAndRemoveEmptyNotTrimmed(String string, char c) {
        List<String> split = StringUtils.split(string, c);
        int i = split.size() - 1;
        while (i >= 0) {
            if (split.get(i).length() == 0) {
                split.remove(i);
            }
            --i;
        }
        return split;
    }

    public static List<String> splitAndRemoveEmptyTrimmed(String string, char c) {
        List<String> split = StringUtils.split(string, c);
        int i = split.size() - 1;
        while (i >= 0) {
            if (split.get(i).trim().length() == 0) {
                split.remove(i);
            }
            --i;
        }
        return split;
    }

    public static Tuple<String, String> splitOnFirst(String fullRep, char toSplit) {
        int i = fullRep.indexOf(toSplit);
        if (i != -1) {
            return new Tuple<String, String>(fullRep.substring(0, i), fullRep.substring(i + 1));
        }
        return new Tuple<String, String>(fullRep, EMPTY);
    }

    public static Tuple<String, String> splitOnFirst(String fullRep, String toSplit) {
        int i = fullRep.indexOf(toSplit);
        if (i != -1) {
            return new Tuple<String, String>(fullRep.substring(0, i), fullRep.substring(i + toSplit.length()));
        }
        return new Tuple<String, String>(fullRep, EMPTY);
    }

    public static List<String> dotSplit(String string) {
        return StringUtils.splitAndRemoveEmptyTrimmed(string, '.');
    }

    public static char[] addChar(char[] c, char toAdd) {
        char[] c1 = new char[c.length + 1];
        System.arraycopy(c, 0, c1, 0, c.length);
        c1[c.length] = toAdd;
        return c1;
    }

    public static String[] addString(String[] c, String toAdd) {
        String[] c1 = new String[c.length + 1];
        System.arraycopy(c, 0, c1, 0, c.length);
        c1[c.length] = toAdd;
        return c1;
    }

    public static String removeNewLineChars(String message) {
        return message.replaceAll("\r", EMPTY).replaceAll("\n", EMPTY);
    }

    public static String asStyleLowercaseUnderscores(String string) {
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer(len * 2);
        int lastState = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (lastState != 1 && buf.length() > 0 && buf.lastChar() != '_') {
                    buf.append('_');
                }
                buf.append(Character.toLowerCase(c));
                lastState = 1;
            } else if (Character.isDigit(c)) {
                if (lastState != 2 && buf.length() > 0 && buf.lastChar() != '_') {
                    buf.append('_');
                }
                buf.append(c);
                lastState = 2;
            } else {
                buf.append(c);
                lastState = 0;
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean isAllUpper(String string) {
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAsciiLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public static boolean isAsciiLetterOrUnderline(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95;
    }

    public static boolean isAsciiLetterOrUnderlineOrNumber(int c) {
        return StringUtils.isAsciiLetterOrUnderline(c) || Character.isDigit(c);
    }

    public static String asStyleCamelCaseFirstLower(String string) {
        if (StringUtils.isAllUpper(string)) {
            string = string.toLowerCase();
        }
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer(len);
        boolean first = true;
        int nextUpper = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (first) {
                if (c == '_') {
                    buf.append(c);
                } else {
                    buf.append(Character.toLowerCase(c));
                    first = false;
                }
            } else if (c == '_') {
                ++nextUpper;
            } else {
                if (nextUpper > 0) {
                    c = Character.toUpperCase(c);
                    nextUpper = 0;
                }
                buf.append(c);
            }
            ++i;
        }
        if (nextUpper > 0) {
            buf.appendN('_', nextUpper);
        }
        return buf.toString();
    }

    public static String asStyleCamelCaseFirstUpper(String string) {
        if ((string = StringUtils.asStyleCamelCaseFirstLower(string)).length() > 0) {
            return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
        }
        return string;
    }

    public static boolean endsWith(FastStringBuffer str, char c) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == c;
    }

    public static boolean endsWith(String str, char c) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        return str.charAt(len - 1) == c;
    }

    public static boolean endsWith(StringBuffer str, char c) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        return str.charAt(len - 1) == c;
    }

    public static String safeDecodeByteArray(byte[] b, String baseCharset) {
        try {
            if (baseCharset == null) {
                return new String(b, StandardCharsets.ISO_8859_1);
            }
            return new String(b, baseCharset);
        }
        catch (Exception exception) {
            try {
                CharsetDecoder decoder = Charset.forName(baseCharset).newDecoder();
                decoder.onMalformedInput(CodingErrorAction.IGNORE);
                decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                CharBuffer parsed = decoder.decode(ByteBuffer.wrap(b, 0, b.length));
                return parsed.toString();
            }
            catch (Exception e2) {
                Log.log(e2);
                return new String("Unable to decode bytearray from Python.");
            }
        }
    }

    public static boolean containsWhitespace(String name) {
        int len = name.length();
        int i = 0;
        while (i < len) {
            if (Character.isWhitespace(name.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getWithFirstUpper(String creationStr) {
        int len = creationStr.length();
        if (len == 0) {
            return creationStr;
        }
        char upperCase = Character.toUpperCase(creationStr.charAt(0));
        return String.valueOf(upperCase) + creationStr.substring(1);
    }

    public static String indentTo(String source, String indent) {
        return StringUtils.indentTo(source, indent, true);
    }

    public static String indentTo(String source, String indent, boolean indentFirstLine) {
        int indentLen = indent.length();
        if (indent == null || indentLen == 0) {
            return source;
        }
        List<String> splitInLines = StringUtils.splitInLines(source);
        int sourceLen = source.length();
        FastStringBuffer buf = new FastStringBuffer(sourceLen + splitInLines.size() * indentLen + 2);
        int i = 0;
        while (i < splitInLines.size()) {
            String line = splitInLines.get(i);
            if (indentFirstLine || i > 0) {
                buf.append(indent);
            }
            buf.append(line);
            ++i;
        }
        return buf.toString();
    }

    public static String reverse(String lineContentsToCursor) {
        return new FastStringBuffer(lineContentsToCursor, 0).reverse().toString();
    }

    public static List<String> splitForIndexMatching(String string) {
        int len = string.length();
        if (len == 0) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ret = new ArrayList<String>();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') {
                String substring;
                if (last != i && !StringUtils.containsOnlyWildCards(substring = string.substring(last, i))) {
                    ret.add(substring);
                }
                while (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?' && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (Character.isJavaIdentifierPart(c) || c == '*' || c == '?') {
            String substring;
            if (last == 0 && len > 0) {
                if (!StringUtils.containsOnlyWildCards(string)) {
                    ret.add(string);
                }
            } else if (last < len && !StringUtils.containsOnlyWildCards(substring = string.substring(last, len))) {
                ret.add(substring);
            }
        }
        return ret;
    }

    public static void checkTokensValidForWildcardQuery(String token) {
        List<String> splitForIndexMatching = StringUtils.splitForIndexMatching(token);
        if (splitForIndexMatching == null || splitForIndexMatching.size() == 0) {
            throw new RuntimeException(StringUtils.format("Token: %s is not a valid token to search for.", token));
        }
    }

    public static boolean containsOnlyWildCards(String string) {
        boolean onlyWildCardsInPart = true;
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c != '*' && c != '?') {
                onlyWildCardsInPart = false;
                break;
            }
            ++i;
        }
        return onlyWildCardsInPart;
    }

    public static interface ICallbackOnSplit {
        public boolean call(String var1);
    }

    private static final class IterLines
    implements Iterator<String> {
        private final String string;
        private final int len;
        private int i;
        private boolean calculatedNext;
        private boolean hasNext;
        private String next;

        private IterLines(String string) {
            this.string = string;
            this.len = string.length();
        }

        @Override
        public boolean hasNext() {
            if (!this.calculatedNext) {
                this.calculatedNext = true;
                this.hasNext = this.calculateNext();
            }
            return this.hasNext;
        }

        private boolean calculateNext() {
            this.next = null;
            int start = this.i;
            while (this.i < this.len) {
                char c = this.string.charAt(this.i);
                if (c == '\r') {
                    if (this.i < this.len - 1 && this.string.charAt(this.i + 1) == '\n') {
                        ++this.i;
                    }
                    ++this.i;
                    this.next = this.string.substring(start, this.i);
                    return true;
                }
                if (c == '\n') {
                    ++this.i;
                    this.next = this.string.substring(start, this.i);
                    return true;
                }
                ++this.i;
            }
            if (start != this.i) {
                this.next = this.string.substring(start, this.i);
                ++this.i;
                return true;
            }
            return false;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String n = this.next;
            this.calculatedNext = false;
            this.next = null;
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

