/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.python.pydev.shared_core.structure.FastStack;

public class StringScanner
implements ICharacterScanner {
    private final String contents;
    private int offset;
    private final int length;
    final FastStack<char[]> endLevel = new FastStack(3);

    public StringScanner(String contents) {
        this.contents = contents;
        this.length = contents.length();
    }

    public int read() {
        if (this.offset < this.length) {
            char ret = this.contents.charAt(this.offset);
            ++this.offset;
            return ret;
        }
        if (this.offset == this.length) {
            ++this.offset;
            return -1;
        }
        throw new RuntimeException("Reading past EOF!");
    }

    public int peek(int i) {
        int checkAt = this.offset + i;
        if (checkAt >= this.length || checkAt < 0) {
            return -1;
        }
        return this.contents.charAt(checkAt);
    }

    public void unread() {
        --this.offset;
        if (this.offset < 0) {
            throw new RuntimeException("Reading before begin of stream.");
        }
    }

    public int getMark() {
        return this.offset;
    }

    public String getContents() {
        return this.contents;
    }

    public void addLevelFinishingAt(char ... endLevelChar) {
        this.endLevel.push(endLevelChar);
    }

    public void popLevel() {
        this.endLevel.pop();
    }

    public void setMark(int mark) {
        this.offset = mark;
    }

    public boolean isEndLevelChar(int c) {
        if (!this.endLevel.isEmpty()) {
            char[] peek = this.endLevel.peek();
            int len = peek.length;
            int i = 0;
            while (i < len) {
                if (peek[i] == c) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int getLevel() {
        return this.endLevel.size();
    }

    public char[][] getLegalLineDelimiters() {
        throw new AssertionError((Object)"Not implemented");
    }

    public int getColumn() {
        throw new AssertionError((Object)"Not implemented");
    }
}

