/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class SelectionKeeper {
    private final int startLine;
    private final int endLine;
    private final int startCol;
    private final int endCol;

    public SelectionKeeper(TextSelectionUtils ps) {
        ITextSelection selection = ps.getTextSelection();
        this.startLine = selection.getStartLine();
        this.endLine = selection.getEndLine();
        this.startCol = selection.getOffset() - ps.getLineOffset(this.startLine);
        this.endCol = selection.getOffset() + selection.getLength() - ps.getLineOffset(this.endLine);
    }

    public void restoreSelection(ISelectionProvider selectionProvider, IDocument doc) {
        int numberOfLines = doc.getNumberOfLines();
        int startLine = this.fixBasedOnNumberOfLines(this.startLine, numberOfLines);
        int endLine = this.fixBasedOnNumberOfLines(this.endLine, numberOfLines);
        int startLineOffset = this.getOffset(doc, startLine);
        int startLineLen = this.getLineLength(doc, startLine);
        int startLineDelimiterLen = this.getLineDelimiterLen(doc, startLine);
        int startOffset = this.fixOffset(startLineOffset + this.startCol, startLineOffset, startLineOffset + startLineLen - startLineDelimiterLen);
        int endLineOffset = this.getOffset(doc, endLine);
        int endLineLen = this.getLineLength(doc, endLine);
        int endLineDelimiterLen = this.getLineDelimiterLen(doc, endLine);
        int endOffset = this.fixOffset(endLineOffset + this.endCol, endLineOffset, endLineOffset + endLineLen - endLineDelimiterLen);
        selectionProvider.setSelection((ISelection)new TextSelection(startOffset, endOffset - startOffset));
    }

    private int getLineDelimiterLen(IDocument doc, int line) {
        String lineDelimiter;
        block3: {
            try {
                lineDelimiter = doc.getLineDelimiter(line);
                if (lineDelimiter != null) break block3;
                return 0;
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }
        return lineDelimiter.length();
    }

    private int getLineLength(IDocument doc, int line) {
        try {
            return doc.getLineLength(line);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private int fixOffset(int offset, int minOffset, int maxOffset) {
        if (offset > maxOffset) {
            offset = maxOffset;
        }
        if (offset < minOffset) {
            offset = minOffset;
        }
        return offset;
    }

    private int getOffset(IDocument doc, int startLine) {
        try {
            return doc.getLineOffset(startLine);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private int fixBasedOnNumberOfLines(int line, int numberOfLines) {
        if (line > numberOfLines - 1) {
            line = numberOfLines - 1;
        }
        if (line < 0) {
            line = 0;
        }
        return line;
    }
}

