/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.resource_stubs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.resource_stubs.AbstractIProjectStub;
import org.python.pydev.shared_core.resource_stubs.FileStub;
import org.python.pydev.shared_core.resource_stubs.FolderStub;

public class ProjectStub
extends AbstractIProjectStub
implements IWorkbenchAdapter {
    public File projectRoot;
    private Map<File, IResource> cache = new HashMap<File, IResource>();
    private IProjectNature nature;
    private IContainer parent;
    private boolean addNullChild;
    private List<Object> additionalChildren;
    private HashMap<Object, Object[]> stubsCache = new HashMap();

    public ProjectStub(File file, IProjectNature nature) {
        this(file, nature, false);
    }

    public ProjectStub(File file, IProjectNature nature, boolean addNullChild) {
        this(file, nature, addNullChild, new ArrayList<Object>());
    }

    public ProjectStub(File file, IProjectNature nature, boolean addNullChild, List<Object> additionalChildren) {
        Assert.isTrue((file.exists() && file.isDirectory() ? 1 : 0) != 0);
        this.projectRoot = file;
        this.nature = nature;
        this.addNullChild = addNullChild;
        this.additionalChildren = additionalChildren;
    }

    public IResource getResource(File parentFile) {
        if (parentFile.equals(this.projectRoot)) {
            return this;
        }
        IResource r = this.cache.get(parentFile);
        if (r == null) {
            r = parentFile.isFile() ? new FileStub(this, parentFile) : new FolderStub(this, null, parentFile, false);
            this.cache.put(parentFile, r);
        }
        return r;
    }

    public IContainer getFolder(File parentFile) {
        return (IContainer)this.getResource(parentFile);
    }

    public void setParent(IContainer parent) {
        this.parent = parent;
    }

    @Override
    public IContainer getParent() {
        return this.parent;
    }

    public String toString() {
        return "ProjectStub:" + this.projectRoot;
    }

    @Override
    public IProjectNature getNature(String natureId) throws CoreException {
        if (this.nature == null) {
            throw new RuntimeException("not expected");
        }
        return this.nature;
    }

    @Override
    public String getName() {
        return this.projectRoot.getName();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
    }

    @Override
    public IPath getFullPath() {
        return new Path(this.projectRoot.getName());
    }

    @Override
    public IFolder getFolder(String name) {
        return this.getFolder((IPath)new Path(name));
    }

    @Override
    public IFolder getFolder(IPath path) {
        String[] segments = path.segments();
        IFolder f = null;
        File curr = this.projectRoot;
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            File parentFile = new File(curr, string);
            f = (IFolder)this.getFolder(parentFile);
            curr = parentFile;
            ++n2;
        }
        return f;
    }

    @Override
    public IFile getFile(IPath path) {
        String[] segments = path.segments();
        int segmentCount = path.segmentCount();
        ProjectStub container = this;
        int i = 0;
        while (i < segmentCount - i) {
            container = container.getFolder((IPath)new Path(segments[i]));
            ++i;
        }
        if (container != this) {
            return container.getFile((IPath)new Path(segments[segmentCount - 1]));
        }
        throw new RuntimeException("Finish implementing");
    }

    @Override
    public IPath getLocation() {
        return Path.fromOSString((String)FileUtils.getFileAbsolutePath(this.projectRoot));
    }

    @Override
    public IProject getProject() {
        return this;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return (T)this;
        }
        throw new RuntimeException("Not impl");
    }

    public Object[] getChildren(Object o) {
        Object[] found = this.stubsCache.get(o);
        if (found != null) {
            return found;
        }
        File folder = null;
        if (!(o instanceof ProjectStub)) {
            throw new RuntimeException("Shouldn't happen");
        }
        ProjectStub projectStub = (ProjectStub)o;
        folder = projectStub.projectRoot;
        ArrayList<Object> ret = new ArrayList<Object>();
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String lower = file.getName().toLowerCase();
            if (!lower.equals("cvs") && !lower.equals(".svn")) {
                if (file.isDirectory()) {
                    ret.add(new FolderStub(this, file));
                } else {
                    ret.add(new FileStub(this, file));
                }
            }
            ++n2;
        }
        if (this.addNullChild) {
            ret.add(null);
        }
        ret.addAll(this.additionalChildren);
        return ret.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        throw new RuntimeException("Not implemented");
    }

    public String getLabel(Object o) {
        throw new RuntimeException("Not implemented");
    }

    public Object getParent(Object o) {
        throw new RuntimeException("Not implemented");
    }
}

