/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.preferences;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.osgi.framework.Bundle;
import org.python.pydev.shared_core.cache.LRUCache;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.preferences.IScopedPreferences;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.OrderedSet;
import org.python.pydev.shared_core.structure.Tuple;
import org.yaml.snakeyaml.Yaml;

public final class ScopedPreferences
implements IScopedPreferences {
    private static final Map<String, IScopedPreferences> yamlFileNameToPreferences = new HashMap<String, IScopedPreferences>();
    private static final Object lock = new Object();
    public static String USER_HOME_IN_TESTS = null;
    public static String WORKSPACE_DIR_IN_TESTS = null;
    private String yamlFileName;
    private File[] trackedDirs;
    private File defaultSettingsDir;
    private File workspaceDir;
    LRUCache<Object, Map<String, Object>> cache;
    LRUCache<Object, Long> lastSeenCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IScopedPreferences get(String yamlFileName) {
        IScopedPreferences ret = yamlFileNameToPreferences.get(yamlFileName);
        if (ret == null) {
            Object object = lock;
            synchronized (object) {
                ret = new ScopedPreferences(yamlFileName);
                yamlFileNameToPreferences.put(yamlFileName, ret);
            }
        }
        return ret;
    }

    public ScopedPreferences(String yamlFileName) {
        String userHome;
        OrderedSet<File> set;
        block13: {
            this.defaultSettingsDir = null;
            this.workspaceDir = null;
            this.cache = new LRUCache(15);
            this.lastSeenCache = new LRUCache(15);
            this.yamlFileName = yamlFileName;
            set = new OrderedSet<File>();
            try {
                if (WORKSPACE_DIR_IN_TESTS != null) {
                    this.workspaceDir = new File(WORKSPACE_DIR_IN_TESTS, String.valueOf(yamlFileName) + ".yaml");
                } else {
                    Bundle bundle = Platform.getBundle((String)"org.python.pydev.shared_core");
                    if (bundle != null) {
                        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
                        this.workspaceDir = new File(stateLocation.toFile(), String.valueOf(yamlFileName) + ".yaml");
                    }
                }
            }
            catch (Exception e1) {
                Log.log(e1);
            }
            userHome = USER_HOME_IN_TESTS == null ? System.getProperty("user.home") : USER_HOME_IN_TESTS;
            if (userHome != null) {
                try {
                    File f = new File(userHome);
                    if (!f.isDirectory()) break block13;
                    f = new File(f, ".eclipse");
                    try {
                        if (!f.exists()) {
                            f.mkdirs();
                        }
                    }
                    catch (Exception e) {
                        Log.log(e);
                    }
                    if (f.isDirectory()) {
                        set.add(f);
                        this.defaultSettingsDir = f;
                    }
                }
                catch (Throwable e) {
                    Log.log(e);
                }
            }
        }
        if (set.size() == 0) {
            Log.log("System.getProperty(\"user.home\") returned " + userHome + " which is not a directory!");
        }
        this.trackedDirs = set.toArray(new File[0]);
    }

    @Override
    public File getUserSettingsLocation() {
        return new File(this.defaultSettingsDir, String.valueOf(this.yamlFileName) + ".yaml");
    }

    @Override
    public File getWorkspaceSettingsLocation() {
        return this.workspaceDir;
    }

    @Override
    public Tuple<Map<String, Object>, Set<String>> loadFromUserSettings(Map<String, Object> saveData) throws Exception {
        HashMap<String, Object> o1 = new HashMap<String, Object>();
        HashSet<String> o2 = new HashSet<String>();
        Tuple<Map<String, Object>, Set<String>> ret = new Tuple<Map<String, Object>, Set<String>>(o1, o2);
        File yamlFile = this.getUserSettingsLocation();
        Map<String, Object> loaded = this.getYamlFileContents(yamlFile);
        if (loaded != null) {
            Set<Map.Entry<String, Object>> initialEntrySet = saveData.entrySet();
            for (Map.Entry<String, Object> entry : initialEntrySet) {
                Object loadedObj = loaded.get(entry.getKey());
                if (loadedObj == null) {
                    o2.add(entry.getKey());
                    continue;
                }
                o1.put(entry.getKey(), this.convertValueToTypeOfOldValue(loadedObj, entry.getValue()));
            }
        }
        return ret;
    }

    @Override
    public Tuple<Map<String, Object>, Set<String>> loadFromProjectSettings(Map<String, Object> saveData, IProject project) throws Exception {
        HashMap<String, Object> o1 = new HashMap<String, Object>();
        HashSet<String> o2 = new HashSet<String>();
        Tuple<Map<String, Object>, Set<String>> ret = new Tuple<Map<String, Object>, Set<String>>(o1, o2);
        IFile yamlFile = ScopedPreferences.getProjectConfigFile(project, String.valueOf(this.yamlFileName) + ".yaml", false);
        if (yamlFile.exists()) {
            Map<String, Object> loaded = this.getYamlFileContents(yamlFile);
            Set<Map.Entry<String, Object>> initialEntrySet = saveData.entrySet();
            for (Map.Entry<String, Object> entry : initialEntrySet) {
                Object loadedObj = loaded.get(entry.getKey());
                if (loadedObj == null) {
                    o2.add(entry.getKey());
                    continue;
                }
                o1.put(entry.getKey(), this.convertValueToTypeOfOldValue(loadedObj, entry.getValue()));
            }
        }
        return ret;
    }

    @Override
    public String saveToUserSettings(Map<String, Object> saveData) throws Exception {
        if (this.defaultSettingsDir == null) {
            throw new Exception("user.home is not available!");
        }
        if (!this.defaultSettingsDir.isDirectory()) {
            throw new Exception("user.home/.settings: " + this.defaultSettingsDir + "is not a directory!");
        }
        TreeMap<String, Object> yamlMapToWrite = new TreeMap<String, Object>();
        Set<Map.Entry<String, Object>> entrySet = saveData.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            yamlMapToWrite.put(entry.getKey(), entry.getValue());
        }
        saveData = null;
        File yamlFile = new File(this.defaultSettingsDir, String.valueOf(this.yamlFileName) + ".yaml");
        if (yamlFile.exists()) {
            try {
                HashMap<String, Object> initial = new HashMap<String, Object>(this.getYamlFileContents(yamlFile));
                initial.putAll(yamlMapToWrite);
                yamlMapToWrite = new TreeMap<String, Object>(initial);
            }
            catch (Exception e) {
                throw new Exception(StringUtils.format("Error: unable to write settings because the file: %s already exists but is not a parseable YAML file (aborting to avoid overriding existing file).", yamlFile), e);
            }
        }
        this.dumpSaveDataToFile(yamlMapToWrite, yamlFile);
        return "Contents saved to:\n" + yamlFile;
    }

    @Override
    public String saveToProjectSettings(Map<String, Object> saveData, IProject ... projects) {
        FastStringBuffer buf = new FastStringBuffer();
        int createdForNProjects = 0;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IProject project = iProjectArray[n2];
                try {
                    IFile projectConfigFile = ScopedPreferences.getProjectConfigFile(project, String.valueOf(this.yamlFileName) + ".yaml", true);
                    if (projectConfigFile == null) {
                        buf.append("Unable to get config file location for: ").append(project.getName()).append("\n");
                        break block9;
                    }
                    if (projectConfigFile.exists()) {
                        Map<String, Object> yamlFileContents = null;
                        try {
                            yamlFileContents = this.getYamlFileContents(projectConfigFile);
                        }
                        catch (Exception e) {
                            throw new Exception(StringUtils.format("Error: unable to write settings because the file: %s already exists but is not a parseable YAML file (aborting to avoid overriding existing file).\n", projectConfigFile), e);
                        }
                        TreeMap<String, Object> yamlMapToWrite = new TreeMap<String, Object>();
                        Set<Map.Entry<String, Object>> entrySet = yamlFileContents.entrySet();
                        for (Map.Entry<String, Object> entry : entrySet) {
                            yamlMapToWrite.put(entry.getKey(), entry.getValue());
                        }
                        yamlMapToWrite.putAll(saveData);
                        this.dumpSaveDataToFile(yamlMapToWrite, projectConfigFile, true);
                        ++createdForNProjects;
                        break block9;
                    }
                    this.dumpSaveDataToFile(saveData, projectConfigFile, false);
                    ++createdForNProjects;
                }
                catch (Exception e) {
                    Log.log(e);
                    buf.append(e.getMessage());
                }
            }
            ++n2;
        }
        if (createdForNProjects > 0) {
            buf.insert(0, "Operation succeeded for " + createdForNProjects + " projects.\n");
        }
        return buf.toString();
    }

    private void dumpSaveDataToFile(Map<String, Object> saveData, IFile yamlFile, boolean exists) throws IOException, CoreException {
        Yaml yaml = new Yaml();
        String dumpAsMap = yaml.dumpAsMap(saveData);
        if (!exists) {
            yamlFile.create((InputStream)new ByteArrayInputStream("".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        }
        yamlFile.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        yamlFile.setContents((InputStream)new ByteArrayInputStream(dumpAsMap.getBytes(StandardCharsets.UTF_8)), true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void dumpSaveDataToFile(Map<String, Object> saveData, File yamlFile) throws IOException {
        Yaml yaml = new Yaml();
        String dumpAsMap = yaml.dumpAsMap(saveData);
        FileUtils.writeStrToFile(dumpAsMap, yamlFile);
    }

    @Override
    public IFile getProjectSettingsLocation(IProject p) {
        return ScopedPreferences.getProjectConfigFile(p, String.valueOf(this.yamlFileName) + ".yaml", false);
    }

    private static IFile getProjectConfigFile(IProject project, String filename, boolean createPath) {
        try {
            if (project != null && project.exists()) {
                IFolder folder = project.getFolder(".settings");
                if (createPath && !folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                return folder.getFile(filename);
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
        return null;
    }

    @Override
    public String getString(IPreferenceStore pluginPreferenceStore, String keyInPreferenceStore, IAdaptable adaptable) {
        Object object = this.getFromProjectOrUserSettings(keyInPreferenceStore, adaptable);
        if (object != null) {
            return object.toString();
        }
        return pluginPreferenceStore.getString(keyInPreferenceStore);
    }

    @Override
    public boolean getBoolean(IPreferenceStore pluginPreferenceStore, String keyInPreferenceStore, IAdaptable adaptable) {
        Object object = this.getFromProjectOrUserSettings(keyInPreferenceStore, adaptable);
        if (object != null) {
            return ScopedPreferences.toBoolean(object);
        }
        return pluginPreferenceStore.getBoolean(keyInPreferenceStore);
    }

    @Override
    public int getInt(IPreferenceStore pluginPreferenceStore, String keyInPreferenceStore, IAdaptable adaptable) {
        Object object = this.getFromProjectOrUserSettings(keyInPreferenceStore, adaptable);
        if (object != null) {
            return ScopedPreferences.toInt(object);
        }
        return pluginPreferenceStore.getInt(keyInPreferenceStore);
    }

    private Object getFromProjectOrUserSettings(String keyInPreferenceStore, IAdaptable adaptable) {
        String keyInYaml;
        block12: {
            keyInYaml = keyInPreferenceStore;
            if (adaptable != null) {
                try {
                    Object object;
                    IProject project = adaptable instanceof IResource ? ((IResource)adaptable).getProject() : (IProject)adaptable.getAdapter(IProject.class);
                    IFile projectConfigFile = this.getProjectSettingsLocation(project);
                    if (projectConfigFile == null || !projectConfigFile.exists()) break block12;
                    Map<String, Object> yamlFileContents = null;
                    try {
                        yamlFileContents = this.getYamlFileContents(projectConfigFile);
                    }
                    catch (Exception e) {
                        Log.log(e);
                    }
                    if (yamlFileContents != null && (object = yamlFileContents.get(keyInYaml)) != null) {
                        return object;
                    }
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
        File[] fileArray = this.trackedDirs;
        int n = this.trackedDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            try {
                Object object;
                File yaml = new File(dir, String.valueOf(this.yamlFileName) + ".yaml");
                Map<String, Object> yamlFileContents = null;
                try {
                    yamlFileContents = this.getYamlFileContents(yaml);
                }
                catch (Exception e) {
                    Log.log(e);
                }
                if (yamlFileContents != null && (object = yamlFileContents.get(keyInYaml)) != null) {
                    return object;
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
            ++n2;
        }
        return null;
    }

    public static boolean toBoolean(Object found) {
        if (found == null) {
            return false;
        }
        if (Boolean.FALSE.equals(found)) {
            return false;
        }
        String asStr = found.toString();
        return !"false".equals(asStr) && !"False".equals(asStr) && !"0".equals(asStr) && asStr.trim().length() != 0;
    }

    public static int toInt(Object found) {
        if (found == null) {
            return 0;
        }
        if (found instanceof Integer) {
            return (Integer)found;
        }
        String asStr = found.toString();
        try {
            return Integer.parseInt(asStr);
        }
        catch (Exception e) {
            Log.log(e);
            return 0;
        }
    }

    private Object convertValueToTypeOfOldValue(Object loadedObj, Object oldValue) {
        if (oldValue == null) {
            return loadedObj;
        }
        if (loadedObj == null) {
            return null;
        }
        if (oldValue instanceof Boolean) {
            return ScopedPreferences.toBoolean(loadedObj);
        }
        if (oldValue instanceof Integer) {
            return ScopedPreferences.toInt(loadedObj);
        }
        if (oldValue instanceof String) {
            return loadedObj.toString();
        }
        throw new RuntimeException("Unable to handle type conversion to: " + oldValue.getClass());
    }

    private Map<String, Object> getCachedYamlFileContents(Object key, long currentSeen, ICallback0<Object> iCallback0) throws Exception {
        Map obj;
        Long lastSeen = (Long)this.lastSeenCache.getObj(key);
        if (lastSeen != null && lastSeen != currentSeen) {
            this.cache.remove(key);
        }
        if ((obj = (Map)this.cache.getObj(key)) != null) {
            return obj;
        }
        Map ret = (Map)iCallback0.call();
        this.lastSeenCache.add(key, currentSeen);
        this.cache.add(key, ret);
        return ret;
    }

    private Map<String, Object> getYamlFileContents(final IFile projectConfigFile) throws Exception {
        return this.getCachedYamlFileContents(projectConfigFile, projectConfigFile.getModificationStamp(), new ICallback0<Object>(){

            @Override
            public Object call() {
                IDocument fileContents = ScopedPreferences.this.getFileContents(projectConfigFile);
                String yamlContents = fileContents.get();
                try {
                    return ScopedPreferences.this.getYamlFileContentsImpl(yamlContents);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public Map<String, Object> getYamlFileContents(final File yamlFile) throws Exception {
        if (!yamlFile.exists()) {
            return null;
        }
        FileTime ret = Files.getLastModifiedTime(yamlFile.toPath(), new LinkOption[0]);
        long lastModified = ret.to(TimeUnit.NANOSECONDS);
        return this.getCachedYamlFileContents(yamlFile, lastModified, new ICallback0<Object>(){

            @Override
            public Object call() {
                try {
                    String fileContents = FileUtils.getFileContents(yamlFile);
                    Map initial = ScopedPreferences.this.getYamlFileContentsImpl(fileContents);
                    return initial;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Map<String, Object> getYamlFileContentsImpl(String yamlContents) throws Exception {
        if (yamlContents.trim().length() == 0) {
            return new HashMap<String, Object>();
        }
        Yaml yaml = new Yaml();
        Object load = yaml.load(yamlContents);
        if (!(load instanceof Map)) {
            if (load == null) {
                throw new Exception("Expected top-level element to be a map. Found: null");
            }
            throw new Exception("Expected top-level element to be a map. Found: " + load.getClass());
        }
        return Collections.unmodifiableMap((Map)load);
    }

    private IDocument getFileContents(IFile file) {
        return FileUtils.getDocFromResource((IResource)file);
    }
}

