/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.IToken;
import org.python.pydev.shared_core.partitioner.DummyToken;
import org.python.pydev.shared_core.partitioner.SubRuleToken;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class TypedPositionWithSubTokens
extends TypedPosition {
    private SubRuleToken subRuleToken;

    public TypedPositionWithSubTokens(int offset, int length, String type, SubRuleToken subRuleToken, boolean fixRelativeOffset) {
        super(offset, length, type);
        if (fixRelativeOffset) {
            this.setSubRuleToken(subRuleToken);
        } else {
            this.subRuleToken = subRuleToken;
        }
    }

    public TypedPositionWithSubTokens(int offset, int length, String type, SubRuleToken subRuleToken) {
        this(offset, length, type, subRuleToken, true);
    }

    public void clearSubRuleToken() {
        this.subRuleToken = null;
    }

    public void setSubRuleToken(SubRuleToken subRuleToken) {
        if (subRuleToken != null) {
            subRuleToken.makeRelativeToOffset(this.getOffset());
        }
        this.subRuleToken = subRuleToken;
    }

    public SubRuleToken getSubRuleToken() {
        return this.subRuleToken;
    }

    public String toStringTest() {
        FastStringBuffer buf = new FastStringBuffer();
        buf.append(String.valueOf(this.getType()) + ":" + this.getOffset() + ":" + this.getLength()).append(" [\n ").append(this.subRuleToken != null ? this.subRuleToken.toStringBetter() : "null").append("\n]");
        return buf.toString();
    }

    public void mergeSubRuleToken(TypedPositionWithSubTokens withSub) {
        if (withSub == null || withSub.subRuleToken == null) {
            return;
        }
        if (this.subRuleToken == null) {
            this.subRuleToken = withSub.subRuleToken;
            return;
        }
        Assert.isTrue((withSub.offset >= this.offset ? 1 : 0) != 0);
        withSub.subRuleToken.addOffset(withSub.offset);
        withSub.subRuleToken.makeRelativeToOffset(this.offset);
        Object d0 = this.subRuleToken.token.getData();
        Object d1 = withSub.subRuleToken.token.getData();
        if (d0 == d1 || d0 != null && d1 != null && d0.equals(d1)) {
            this.subRuleToken.addChildren(withSub.subRuleToken.getChildren());
        } else {
            if (this.subRuleToken.token.getData() != null) {
                SubRuleToken newSub = new SubRuleToken((IToken)new DummyToken(null), this.subRuleToken.offset, this.subRuleToken.len);
                newSub.addChild(this.subRuleToken);
                this.subRuleToken = newSub;
            }
            this.subRuleToken.addChild(withSub.subRuleToken);
        }
        int finalOffset = withSub.subRuleToken.offset + withSub.subRuleToken.len;
        int currentFinalOffset = this.subRuleToken.offset + this.subRuleToken.len;
        if (currentFinalOffset < finalOffset) {
            this.subRuleToken.len += finalOffset - currentFinalOffset;
        }
    }

    public TypedPositionWithSubTokens createCopy() {
        return new TypedPositionWithSubTokens(this.offset, this.length, this.getType(), this.subRuleToken != null ? this.subRuleToken.createCopy() : null, false);
    }
}

