/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.python.pydev.shared_core.partitioner.TypedPositionWithSubTokens;

public class PartitionMerger {
    public static List<TypedPosition> sortAndMergePositions(Position[] positions, int docLen) {
        Arrays.sort(positions, new PositionComparator());
        ArrayList<TypedPosition> lst = new ArrayList<TypedPosition>(positions.length);
        int lastOffset = 0;
        TypedPositionWithSubTokens last = null;
        int j = 0;
        while (j < positions.length) {
            Position position = positions[j];
            TypedPositionWithSubTokens withSub = null;
            if (position instanceof TypedPositionWithSubTokens) {
                withSub = (TypedPositionWithSubTokens)position;
            }
            if (position instanceof TypedPosition) {
                TypedPositionWithSubTokens newPos;
                TypedPosition typedPosition = (TypedPosition)position;
                String type = typedPosition.getType();
                int currOffset = typedPosition.getOffset();
                int currLen = typedPosition.getLength();
                if (lastOffset < currOffset) {
                    if (last != null && last.getType().equals("__dftl_partition_content_type")) {
                        last.setLength(last.getLength() + currOffset - lastOffset);
                    } else {
                        newPos = new TypedPositionWithSubTokens(lastOffset, currOffset - lastOffset, "__dftl_partition_content_type", null, false);
                        lst.add(newPos);
                        last = newPos;
                    }
                }
                if (last != null && last.getType().equals(type)) {
                    last.setLength(last.getLength() + currLen);
                    if (withSub != null) {
                        last.mergeSubRuleToken(withSub.createCopy());
                    }
                } else {
                    newPos = new TypedPositionWithSubTokens(currOffset, currLen, type, withSub != null ? withSub.createCopy().getSubRuleToken() : null, false);
                    lst.add(newPos);
                    last = newPos;
                }
                lastOffset = currOffset + currLen;
            }
            ++j;
        }
        if (lastOffset < docLen) {
            if (last != null && last.getType().equals("__dftl_partition_content_type")) {
                last.setLength(last.getLength() + docLen - lastOffset);
            } else {
                lst.add(new TypedPositionWithSubTokens(lastOffset, docLen - lastOffset, "__dftl_partition_content_type", null, false));
            }
        }
        return lst;
    }

    private static final class PositionComparator
    implements Comparator<Position> {
        private PositionComparator() {
        }

        @Override
        public int compare(Position o1, Position o2) {
            return o1.offset - o2.offset;
        }
    }
}

