/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.partitioner.AbstractCustomRuleBasedScanner;
import org.python.pydev.shared_core.partitioner.IContentsScanner;
import org.python.pydev.shared_core.partitioner.IMarkScanner;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.FastStack;

public abstract class AbstractCustomBufferedRuleBasedScanner
extends AbstractCustomRuleBasedScanner
implements IMarkScanner,
IContentsScanner {
    private static final int DEFAULT_BUFFER_SIZE = 2000;
    private int fBufferSize = 2000;
    private char[] fBuffer = new char[2000];
    private int fStart;
    private int fEnd;
    private int fDocumentLength;
    private int lastRegexpMatchOffset;
    private FastStack<TempStacked> rangeStack = new FastStack(3);

    public void setLastRegexpMatchOffset(int endOffset) {
        this.lastRegexpMatchOffset = endOffset;
    }

    public int getLastRegexpMatchOffset() {
        return this.lastRegexpMatchOffset;
    }

    protected AbstractCustomBufferedRuleBasedScanner() {
    }

    public AbstractCustomBufferedRuleBasedScanner(int size) {
        this.setBufferSize(size);
    }

    protected void setBufferSize(int size) {
        Assert.isTrue((size > 0 ? 1 : 0) != 0);
        this.fBufferSize = size;
        this.fBuffer = new char[size];
    }

    private void shiftBuffer(int offset) {
        this.fStart = offset;
        this.fEnd = this.fStart + this.fBufferSize;
        if (this.fEnd > this.fDocumentLength) {
            this.fEnd = this.fDocumentLength;
        }
        try {
            String content = this.fDocument.get(this.fStart, this.fEnd - this.fStart);
            content.getChars(0, this.fEnd - this.fStart, this.fBuffer, 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    @Override
    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fDocumentLength = document.getLength();
        this.shiftBuffer(offset);
    }

    @Override
    public int getMark() {
        return this.fOffset;
    }

    @Override
    public void getContents(int offset, int length, FastStringBuffer buffer) {
        buffer.resizeForMinimum(buffer.length() + length);
        int mark = this.getMark();
        this.setMark(offset);
        try {
            int i = 0;
            while (i < length) {
                buffer.append((char)this.read());
                ++i;
            }
        }
        finally {
            this.setMark(mark);
        }
    }

    @Override
    public void setMark(int offset) {
        this.fOffset = offset;
        this.fColumn = -1;
        if (this.fOffset == this.fStart) {
            this.shiftBuffer(Math.max(0, this.fStart - this.fBufferSize / 2));
        } else if (this.fOffset == this.fEnd) {
            this.shiftBuffer(this.fEnd);
        } else if (this.fOffset < this.fStart || this.fEnd < this.fOffset) {
            this.shiftBuffer(this.fOffset);
        }
    }

    public void pushRange(int offset, int len) {
        this.rangeStack.push(new TempStacked(this.fOffset, this.fRangeEnd, this.lastRegexpMatchOffset));
        this.fOffset = offset;
        this.fRangeEnd = offset + len;
        this.setMark(this.fOffset);
    }

    public void popRange() {
        TempStacked pop = this.rangeStack.pop();
        this.fOffset = pop.offset;
        this.fRangeEnd = pop.rangeEnd;
        this.lastRegexpMatchOffset = pop.lastRegexpMatchOffset;
        this.setMark(this.fOffset);
    }

    @Override
    public int read() {
        this.fColumn = -1;
        if (this.fOffset >= this.fRangeEnd) {
            ++this.fOffset;
            return -1;
        }
        if (this.fOffset == this.fEnd) {
            this.shiftBuffer(this.fEnd);
        } else if (this.fOffset < this.fStart || this.fEnd < this.fOffset) {
            this.shiftBuffer(this.fOffset);
        }
        return this.fBuffer[this.fOffset++ - this.fStart];
    }

    @Override
    public void unread() {
        if (this.fOffset == this.fStart) {
            this.shiftBuffer(Math.max(0, this.fStart - this.fBufferSize / 2));
        }
        --this.fOffset;
        this.fColumn = -1;
    }

    private static class TempStacked {
        private int offset;
        private int rangeEnd;
        private int lastRegexpMatchOffset;

        public TempStacked(int offset, int rangeEnd, int lastRegexpMatchOffset) {
            this.offset = offset;
            this.rangeEnd = rangeEnd;
            this.lastRegexpMatchOffset = lastRegexpMatchOffset;
        }
    }
}

