/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.document;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.document.DocCopy;

public class DocumentSync {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object runWithDocumentSynched(IDocument document, ICallback<Object, IDocument> iCallback, boolean createCopy) {
        Object lockObject = null;
        if (document instanceof ISynchronizable) {
            ISynchronizable sync = (ISynchronizable)document;
            lockObject = sync.getLockObject();
        }
        DocCopy docCopy = null;
        try {
            if (lockObject != null) {
                if (createCopy) {
                    Object object = lockObject;
                    synchronized (object) {
                        docCopy = new DocCopy(document);
                    }
                    Object object2 = iCallback.call(docCopy);
                    return object2;
                }
                Object object = lockObject;
                synchronized (object) {
                    Object object3 = iCallback.call(document);
                    return object3;
                }
            }
            if (createCopy && !(document instanceof DocCopy)) {
                docCopy = new DocCopy(document);
                Object object = iCallback.call(docCopy);
                return object;
            }
            Object object = iCallback.call(document);
            return object;
        }
        finally {
            if (docCopy != null) {
                docCopy.dispose();
            }
        }
    }

    public static IDocument createUnsynchedDocIfNeeded(IDocument doc) {
        if (doc instanceof ISynchronizable) {
            return new DocCopy(doc);
        }
        return doc;
    }
}

