/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.auto_edit;

import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.python.pydev.shared_core.auto_edit.AutoEditStrategyHelper;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.DocCmd;

public class AutoEditStrategyScopeCreationHelper {
    private int linkOffset;
    private int linkExitPos;
    private int linkLen;

    public static VerifyKeyListener createVerifyKeyListener(final TextViewer viewer, final IScopeCreatingCharsProvider provider) {
        return new VerifyKeyListener(){
            private final AutoEditStrategyScopeCreationHelper scopeHelper = new AutoEditStrategyScopeCreationHelper();

            public void verifyKey(VerifyEvent event) {
                if (!event.doit || event.character == '\u0000') {
                    return;
                }
                if (viewer != null && viewer.isEditable()) {
                    ISelection selection;
                    boolean blockSelection = false;
                    try {
                        blockSelection = viewer.getTextWidget().getBlockSelection();
                    }
                    catch (Throwable throwable) {}
                    if (!blockSelection && (selection = viewer.getSelection()) instanceof ITextSelection) {
                        TextSelectionUtils ps = new TextSelectionUtils(viewer.getDocument(), (ITextSelection)selection);
                        int absoluteCursorOffset = ps.getAbsoluteCursorOffset();
                        String contentType = AutoEditStrategyHelper.getContentType(ps.getDoc(), absoluteCursorOffset, false);
                        int closeScope = provider.getCharactersThatCreateScope(contentType, event.character);
                        switch (closeScope) {
                            case 1: {
                                break;
                            }
                            case 3: {
                                return;
                            }
                            case 2: {
                                if (ps.getSelLength() != 0) break;
                                return;
                            }
                        }
                        if (this.scopeHelper.perform(ps, event.character, viewer, provider)) {
                            event.doit = false;
                        }
                    }
                }
            }
        };
    }

    public boolean perform(TextSelectionUtils ps, char c, TextViewer viewer, IScopeCreatingCharsProvider provider) {
        block6: {
            block5: {
                this.linkOffset = -1;
                this.linkExitPos = -1;
                this.linkLen = 0;
                IDocument doc = ps.getDoc();
                DocCmd docCmd = new DocCmd(ps.getAbsoluteCursorOffset(), ps.getSelLength(), Character.toString(c));
                if (this.handleScopeCreationChar(doc, docCmd, ps, provider, c)) break block5;
                return false;
            }
            if (this.linkOffset != -1 && this.linkExitPos != -1) break block6;
            return true;
        }
        try {
            if (viewer != null) {
                viewer.setSelectedRange(this.linkOffset, this.linkLen);
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleScopeCreationChar(IDocument document, DocumentCommand command, TextSelectionUtils ps, IScopeCreatingCharsProvider provider, char c) throws BadLocationException {
        boolean hasMatchesAfter;
        int currOffset;
        IDocument doc;
        String string;
        int length;
        String cursorLineContents;
        int offset = ps.getAbsoluteCursorOffset();
        Set<Tuple<String, String>> multiLineSequences = provider.getMultiLineSequences();
        Tuple<String, String> foundMultiLine = null;
        for (Tuple<String, String> tuple : multiLineSequences) {
            if (((String)tuple.o1).length() <= 0 || ((String)tuple.o1).charAt(0) != c) continue;
            foundMultiLine = tuple;
            break;
        }
        if (command.length > 0) {
            String selectedText = ps.getSelectedText();
            if (selectedText.indexOf(13) != -1 || selectedText.indexOf(10) != -1) {
                if (foundMultiLine == null) return false;
                FastStringBuffer buf = new FastStringBuffer(selectedText.length() + 10);
                buf.append((String)foundMultiLine.o1);
                buf.append(selectedText);
                buf.append((String)foundMultiLine.o2);
                document.replace(offset, ps.getSelLength(), buf.toString());
                this.linkOffset = offset + ((String)foundMultiLine.o1).length();
                this.linkLen = selectedText.length();
                this.linkExitPos = this.linkOffset + this.linkLen + ((String)foundMultiLine.o2).length();
                return true;
            } else {
                document.replace(offset, ps.getSelLength(), this.getReplacement(command, foundMultiLine, selectedText));
                this.linkOffset = offset + 1;
                this.linkLen = selectedText.length();
                this.linkExitPos = this.linkOffset + this.linkLen + 1;
            }
            return true;
        }
        try {
            char nextChar = ps.getCharAtCurrentOffset();
            if (Character.isJavaIdentifierPart(nextChar)) {
                return false;
            }
        }
        catch (BadLocationException badLocationException) {}
        if ((cursorLineContents = ps.getCursorLineContents()).indexOf(c) == -1) {
            document.replace(offset, ps.getSelLength(), this.getReplacement(command, foundMultiLine, ""));
            this.linkOffset = offset + 1;
            this.linkLen = 0;
            this.linkExitPos = this.linkOffset + this.linkLen + 1;
            return true;
        }
        if (foundMultiLine != null && command.text.length() == 1 && (length = ((String)foundMultiLine.o1).length()) > 1 && ((String)foundMultiLine.o1).charAt(length - 1) == command.text.charAt(0) && (string = (doc = ps.getDoc()).get((currOffset = ps.getAbsoluteCursorOffset()) - (length - 1), length - 1)).equals(((String)foundMultiLine.o1).substring(0, length - 1))) {
            FastStringBuffer buf = new FastStringBuffer(10);
            buf.append(c);
            buf.append((String)foundMultiLine.o2);
            document.replace(offset, 0, buf.toString());
            this.linkOffset = offset + 1;
            this.linkLen = 0;
            this.linkExitPos = this.linkOffset + this.linkLen + ((String)foundMultiLine.o2).length();
            return true;
        }
        boolean balanced = this.isLiteralBalanced(cursorLineContents);
        Tuple<String, String> beforeAndAfterMatchingChars = ps.getBeforeAndAfterMatchingChars(c);
        int matchesBefore = ((String)beforeAndAfterMatchingChars.o1).length();
        int matchesAfter = ((String)beforeAndAfterMatchingChars.o2).length();
        boolean hasMatchesBefore = matchesBefore != 0;
        boolean bl = hasMatchesAfter = matchesAfter != 0;
        if (hasMatchesBefore || hasMatchesAfter) return false;
        if (!balanced) return false;
        document.replace(offset, ps.getSelLength(), this.getReplacement(command, foundMultiLine, ""));
        this.linkOffset = offset + 1;
        this.linkLen = 0;
        this.linkExitPos = this.linkOffset + this.linkLen + 1;
        return true;
    }

    private String getReplacement(DocumentCommand command, Tuple<String, String> found, String selectedText) {
        String replacement;
        if (found != null && ((String)found.o1).equals(command.text)) {
            replacement = String.valueOf((String)found.o1) + selectedText + (String)found.o2;
        } else if (command.text.length() == 1) {
            char peer;
            char char0 = command.text.charAt(0);
            try {
                peer = StringUtils.getPeer(char0);
            }
            catch (Exception exception) {
                peer = char0;
            }
            replacement = String.valueOf(char0) + selectedText + peer;
        } else {
            replacement = String.valueOf(command.text) + selectedText + command.text;
        }
        return replacement;
    }

    private boolean isLiteralBalanced(String cursorLineContents) {
        return true;
    }

    int getLinkLen() {
        return this.linkLen;
    }

    int getLinkExitPos() {
        return this.linkExitPos;
    }

    int getLinkOffset() {
        return this.linkOffset;
    }

    public static interface IScopeCreatingCharsProvider {
        public static final int CLOSE_SCOPE = 1;
        public static final int CLOSE_SCOPE_IF_SELECTION = 2;
        public static final int CLOSE_SCOPE_NO = 3;

        public int getCharactersThatCreateScope(String var1, char var2);

        public Set<Tuple<String, String>> getMultiLineSequences();
    }
}

