/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.auto_edit;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TypedPosition;
import org.python.pydev.shared_core.auto_edit.AutoEditPairMatcher;
import org.python.pydev.shared_core.auto_edit.AutoEditStrategyNewLineHelper;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.partitioner.PartitionCodeReader;
import org.python.pydev.shared_core.partitioner.PartitionMerger;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.NoPeerAvailableException;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class AutoEditStrategyHelper {
    public final IDocument document;
    public final DocumentCommand command;
    public final char c;
    public static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    public static final char[] CLOSING_BRACKETS = new char[]{'}', ')', ']', '>'};

    public AutoEditStrategyHelper(IDocument document, DocumentCommand command) {
        this.document = document;
        this.command = command;
        this.c = command.text.length() == 1 ? command.text.charAt(0) : (char)'\u0000';
    }

    private AutoEditPairMatcher getMatcher() {
        return new AutoEditPairMatcher(BRACKETS, AutoEditStrategyHelper.getContentType(this.document, this.command));
    }

    public void handleAutoClose(IDocument document, DocumentCommand command, char start, char end) {
        TextSelectionUtils ps = new TextSelectionUtils(document, (ITextSelection)new TextSelection(document, command.offset, command.length));
        try {
            char nextChar = ps.getCharAfterCurrentOffset();
            if (Character.isJavaIdentifierPart(nextChar)) {
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
        command.text = String.valueOf(Character.toString(start)) + Character.toString(end);
        command.shiftsCaret = false;
        command.caretOffset = command.offset + 1;
    }

    public void handleAutoSkip(IDocument document, DocumentCommand command, char c) {
        TextSelectionUtils ps = new TextSelectionUtils(document, (ITextSelection)new TextSelection(document, command.offset, command.length));
        Tuple<String, String> beforeAndAfterMatchingChars = ps.getBeforeAndAfterMatchingChars(c);
        int matchesAfter = ((String)beforeAndAfterMatchingChars.o2).length();
        if (matchesAfter == 1) {
            command.text = "";
            command.shiftsCaret = false;
            command.caretOffset = command.offset + 1;
        }
    }

    public void handleCloseParens(IDocument document, DocumentCommand command, char c) {
        try {
            if (command.offset < document.getLength() && document.get(command.offset, 1).equals(command.text)) {
                boolean found = false;
                int i = 1;
                while (i <= BRACKETS.length && !found) {
                    char b = BRACKETS[i];
                    if (b == c) {
                        found = true;
                        this.performPairReplacement(document, command);
                    }
                    i += 2;
                }
            }
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
    }

    private void performPairReplacement(IDocument document, DocumentCommand command) throws BadLocationException {
        boolean skipChar = this.canSkipCloseParenthesis(document, command);
        if (skipChar) {
            command.text = "";
            command.caretOffset = command.offset + 1;
        }
    }

    public boolean canSkipCloseParenthesis(IDocument document, DocumentCommand command) throws BadLocationException {
        TextSelectionUtils ps = new TextSelectionUtils(document, command.offset);
        char c = ps.getCharAtCurrentOffset();
        try {
            char peer = StringUtils.getPeer(c);
            String contentType = AutoEditStrategyHelper.getContentType(document, command);
            String doc = this.getPartsWithPartition(document, contentType);
            int chars = StringUtils.countChars(c, doc);
            int peers = StringUtils.countChars(peer, doc);
            boolean skipChar = chars == peers;
            return skipChar;
        }
        catch (NoPeerAvailableException noPeerAvailableException) {
            return false;
        }
    }

    private String getPartsWithPartition(IDocument document, String contentType) {
        Position[] positions = PartitionCodeReader.getDocumentTypedPositions(document, contentType);
        int total = 0;
        int i = 0;
        while (i < positions.length) {
            Position position = positions[i];
            total += position.length;
            ++i;
        }
        List<TypedPosition> sortAndMergePositions = PartitionMerger.sortAndMergePositions(positions, document.getLength());
        FastStringBuffer buf = new FastStringBuffer(total + 5);
        for (TypedPosition typedPosition : sortAndMergePositions) {
            try {
                String string = document.get(typedPosition.getOffset(), typedPosition.getLength());
                buf.append(string);
            }
            catch (BadLocationException e) {
                Log.log(e);
            }
        }
        return buf.toString();
    }

    public static String getContentType(IDocument document, DocumentCommand command) {
        return AutoEditStrategyHelper.getContentType(document, command.offset, true);
    }

    public static String getContentType(IDocument document, int offset, boolean preferOpen) {
        String contentType;
        IDocumentExtension3 extension = (IDocumentExtension3)document;
        try {
            contentType = extension.getContentType("__dftl_partitioning", offset, preferOpen);
        }
        catch (BadLocationException badLocationException) {
            contentType = "__dftl_partition_content_type";
        }
        catch (Exception e) {
            Log.log(e);
            contentType = "__dftl_partition_content_type";
        }
        return contentType;
    }

    public void handleOpenParens(IDocument document2, DocumentCommand command2, char c2) {
        try {
            TextSelectionUtils ps = new TextSelectionUtils(this.document, this.command.offset);
            char peer = StringUtils.getPeer(this.c);
            if (this.shouldClose(ps, this.c, peer)) {
                this.command.shiftsCaret = false;
                this.command.text = String.valueOf(this.c) + peer;
                this.command.caretOffset = this.command.offset + 1;
            }
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
    }

    public boolean shouldClose(TextSelectionUtils ps, char c, char peer) throws BadLocationException {
        int closingPeerLine;
        String lineContentsFromCursor = ps.getLineContentsFromCursor();
        int i = 0;
        while (i < lineContentsFromCursor.length()) {
            char charAt = lineContentsFromCursor.charAt(i);
            if (!Character.isWhitespace(charAt)) {
                if (charAt == ',' || StringUtils.isClosingPeer(charAt)) break;
                return false;
            }
            ++i;
        }
        AutoEditPairMatcher matcher = this.getMatcher();
        int closingPeerFoundAtOffset = ps.getAbsoluteCursorOffset();
        int searchUntilLine = ps.getCursorLine() + 5;
        do {
            if ((closingPeerFoundAtOffset = matcher.searchForClosingPeer(closingPeerFoundAtOffset, c, peer, ps.getDoc())) == -1) {
                return true;
            }
            IRegion match = matcher.match(ps.getDoc(), ++closingPeerFoundAtOffset);
            if (match == null) {
                return false;
            }
            try {
                closingPeerLine = ps.getDoc().getLineOfOffset(closingPeerFoundAtOffset);
            }
            catch (Exception exception) {
                break;
            }
        } while (searchUntilLine > closingPeerLine);
        return true;
    }

    public void handleNewLine(IDocument document, DocumentCommand command, char c, String regularIndent) {
        AutoEditStrategyNewLineHelper helper = new AutoEditStrategyNewLineHelper();
        TextSelectionUtils ts = new TextSelectionUtils(document, command.offset);
        helper.handleNewLine(ts, AutoEditStrategyHelper.getContentType(document, command), command, regularIndent);
    }
}

