/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.auto_edit;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.python.pydev.shared_core.partitioner.PartitionCodeReader;
import org.python.pydev.shared_core.string.ICharacterPairMatcher2;
import org.python.pydev.shared_core.string.StringUtils;

public class AutoEditPairMatcher
extends DefaultCharacterPairMatcher
implements ICharacterPairMatcher2 {
    private final char[] fChars;
    private final String contentType;

    public AutoEditPairMatcher(char[] chars, String contentType) {
        super(chars, contentType);
        this.fChars = chars;
        this.contentType = contentType;
    }

    @Override
    public int searchForClosingPeer(int offset, char openingPeer, char closingPeer, IDocument document) {
        try {
            PartitionCodeReader reader = new PartitionCodeReader(this.contentType);
            reader.configureForwardReader(document, offset, document.getLength());
            int stack = 1;
            int c = reader.read();
            while (c != -1) {
                if (c == openingPeer && c != closingPeer) {
                    ++stack;
                } else if (c == closingPeer) {
                    --stack;
                }
                if (stack <= 0) {
                    return reader.getOffset();
                }
                c = reader.read();
            }
            return -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int searchForOpeningPeer(int offset, char openingPeer, char closingPeer, IDocument document) {
        try {
            PartitionCodeReader fReader = new PartitionCodeReader(this.contentType);
            fReader.configureBackwardReader(document, offset);
            int stack = 1;
            int c = fReader.read();
            while (c != -1) {
                if (c == closingPeer && c != openingPeer) {
                    ++stack;
                } else if (c == openingPeer) {
                    --stack;
                }
                if (stack <= 0) {
                    return fReader.getOffset();
                }
                c = fReader.read();
            }
            return -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int searchForAnyOpeningPeer(int offset, IDocument document) {
        try {
            PartitionCodeReader fReader = new PartitionCodeReader(this.contentType);
            fReader.configureBackwardReader(document, offset);
            HashMap<Character, Integer> stack = new HashMap<Character, Integer>();
            HashSet<Character> closing = new HashSet<Character>();
            HashSet<Character> opening = new HashSet<Character>();
            int i = 0;
            while (i < this.fChars.length) {
                stack.put(Character.valueOf(this.fChars[i]), 1);
                if (i % 2 == 0) {
                    opening.add(Character.valueOf(this.fChars[i]));
                } else {
                    closing.add(Character.valueOf(this.fChars[i]));
                }
                ++i;
            }
            int c = fReader.read();
            while (c != -1) {
                if (closing.contains(Character.valueOf((char)c))) {
                    char peer = StringUtils.getPeer((char)c);
                    Integer iStack = (Integer)stack.get(Character.valueOf(peer));
                    iStack = iStack + 1;
                    stack.put(Character.valueOf(peer), iStack);
                } else if (opening.contains(Character.valueOf((char)c))) {
                    Integer iStack = (Integer)stack.get(Character.valueOf((char)c));
                    iStack = iStack - 1;
                    stack.put(Character.valueOf((char)c), iStack);
                    if (iStack == 0) {
                        return fReader.getOffset();
                    }
                }
                c = fReader.read();
            }
            return -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

