/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.actions;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class LineCommentAction {
    private TextSelectionUtils ps;
    private String commentPattern;
    private int spacesInStart;

    public LineCommentAction(TextSelectionUtils ps, String commentPattern, int spacesInStart) {
        this.ps = ps;
        this.commentPattern = commentPattern;
        this.spacesInStart = spacesInStart;
    }

    public FastStringBuffer commentLines(String selectedText) {
        List<String> ret = StringUtils.splitInLines(selectedText);
        FastStringBuffer strbuf = new FastStringBuffer(selectedText.length() + ret.size() + (this.spacesInStart + 2) * ret.size());
        String spacesInStartComment = null;
        if (this.spacesInStart > 0) {
            spacesInStartComment = StringUtils.createSpaceString(this.spacesInStart);
        }
        for (String line : ret) {
            strbuf.append(this.commentPattern);
            if (spacesInStartComment != null) {
                strbuf.append(spacesInStartComment);
            }
            strbuf.append(line);
        }
        return strbuf;
    }

    public Tuple<Integer, Integer> execute() throws BadLocationException {
        this.ps.selectCompleteLine();
        String selectedText = this.ps.getSelectedText();
        FastStringBuffer strbuf = this.commentLines(selectedText);
        ITextSelection txtSel = this.ps.getTextSelection();
        int start = txtSel.getOffset();
        int len = txtSel.getLength();
        String replacement = strbuf.toString();
        this.ps.getDoc().replace(start, len, replacement);
        return new Tuple<Integer, Integer>(start, replacement.length());
    }
}

