/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.actions;

import com.python.pydev.actions.OutlineEntry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;
import org.python.pydev.shared_ui.ImageCache;

public final class ShowOutlineLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public Image getImage(Object element) {
        SimpleNode n = null;
        if (element instanceof DataAndImageTreeNode) {
            DataAndImageTreeNode treeNode = (DataAndImageTreeNode)element;
            element = treeNode.data;
        }
        if (element instanceof OutlineEntry) {
            n = ((OutlineEntry)element).node;
        }
        if (element instanceof ASTEntry) {
            n = ((ASTEntry)element).node;
        }
        if (n != null) {
            ImageCache imageCache = PydevPlugin.getImageCache();
            if (imageCache == null) {
                return null;
            }
            return ParsedItem.getImageForNode((ImageCache)imageCache, (SimpleNode)n, null);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof DataAndImageTreeNode) {
            DataAndImageTreeNode treeNode = (DataAndImageTreeNode)element;
            element = treeNode.data;
        }
        if (element instanceof OutlineEntry) {
            OutlineEntry entry = (OutlineEntry)element;
            String start = NodeUtils.getFullRepresentationString((SimpleNode)entry.node);
            if (entry.model != null) {
                FastStringBuffer suffix = new FastStringBuffer("  (", entry.model.name.length() + 50).append(entry.model.name);
                if (entry.model.moduleName != null && entry.model.moduleName.length() > 0) {
                    suffix.append(" - ").append(entry.model.moduleName);
                }
                suffix.append(')');
                return String.valueOf(start) + suffix.toString();
            }
            return start;
        }
        if (element instanceof ASTEntry) {
            return NodeUtils.getFullRepresentationString((SimpleNode)((ASTEntry)element).node);
        }
        return element.toString();
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof DataAndImageTreeNode) {
            DataAndImageTreeNode treeNode = (DataAndImageTreeNode)element;
            element = treeNode.data;
        }
        if (element instanceof OutlineEntry) {
            OutlineEntry entry = (OutlineEntry)element;
            String start = NodeUtils.getFullRepresentationString((SimpleNode)entry.node);
            if (entry.model != null) {
                FastStringBuffer suffix = new FastStringBuffer("    (", entry.model.name.length() + 50).append(entry.model.name);
                if (entry.model.moduleName != null && entry.model.moduleName.length() > 0) {
                    suffix.append(" - ").append(entry.model.moduleName);
                }
                suffix.append(')');
                return new StyledString(start).append(suffix.toString(), StyledString.QUALIFIER_STYLER);
            }
            if (entry.parentClass != null) {
                FastStringBuffer suffix = new FastStringBuffer("    (", entry.parentClass.length() + 4).append(entry.parentClass).append(')');
                return new StyledString(start).append(suffix.toString(), StyledString.QUALIFIER_STYLER);
            }
            return new StyledString(start);
        }
        if (element instanceof ASTEntry) {
            return new StyledString(NodeUtils.getFullRepresentationString((SimpleNode)((ASTEntry)element).node));
        }
        return new StyledString(element.toString());
    }
}

