/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import java.util.Arrays;
import org.python.google.common.base.Objects$ToStringHelper;
import org.python.google.common.base.Platform;
import org.python.google.common.base.Supplier;
import org.python.google.common.base.Suppliers$SupplierOfInstance;

public abstract class CharMatcher {
    public static final CharMatcher NONE;
    private String description;
    public static final CharMatcher WHITESPACE;

    public static CharMatcher is(char match) {
        String description = "CharMatcher.is(" + Integer.toHexString(match) + ")";
        return new CharMatcher(description, match){
            private /* synthetic */ char val$match;
            {
                this.val$match = c;
                super(x0);
            }

            @Override
            public final boolean matches(char c) {
                return c == this.val$match;
            }

            @Override
            public final CharMatcher or(CharMatcher other) {
                if (other.matches(this.val$match)) {
                    return other;
                }
                return super.or(other);
            }

            @Override
            final void setBits(LookupTable table) {
                table.set(this.val$match);
            }

            @Override
            public final CharMatcher precomputed() {
                return this;
            }
        };
    }

    private static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                char match1 = sequence.charAt(0);
                char match2 = sequence.charAt(1);
                return new CharMatcher("CharMatcher.anyOf(\"" + sequence + "\")", match1, match2){
                    private /* synthetic */ char val$match1;
                    private /* synthetic */ char val$match2;
                    {
                        this.val$match1 = c;
                        this.val$match2 = c2;
                        super(x0);
                    }

                    @Override
                    public final boolean matches(char c) {
                        return c == this.val$match1 || c == this.val$match2;
                    }

                    @Override
                    final void setBits(LookupTable table) {
                        table.set(this.val$match1);
                        table.set(this.val$match2);
                    }

                    @Override
                    public final CharMatcher precomputed() {
                        return this;
                    }
                };
            }
        }
        char[] chars = ((Object)sequence).toString().toCharArray();
        Arrays.sort(chars);
        return new CharMatcher("CharMatcher.anyOf(\"" + chars + "\")", chars){
            private /* synthetic */ char[] val$chars;
            {
                this.val$chars = cArray;
                super(x0);
            }

            @Override
            public final boolean matches(char c) {
                return Arrays.binarySearch(this.val$chars, c) >= 0;
            }
        };
    }

    private static CharMatcher inRange(char startInclusive, char endInclusive) {
        LookupTable.checkArgument(endInclusive >= startInclusive);
        String description = "CharMatcher.inRange(" + Integer.toHexString(startInclusive) + ", " + Integer.toHexString(endInclusive) + ")";
        return CharMatcher.inRange(startInclusive, endInclusive, description);
    }

    private static CharMatcher inRange(char startInclusive, char endInclusive, String description) {
        return new CharMatcher(description, startInclusive, endInclusive){
            private /* synthetic */ char val$startInclusive;
            private /* synthetic */ char val$endInclusive;
            {
                this.val$startInclusive = c;
                this.val$endInclusive = c2;
                super(x0);
            }

            @Override
            public final boolean matches(char c) {
                return this.val$startInclusive <= c && c <= this.val$endInclusive;
            }

            @Override
            final void setBits(LookupTable table) {
                char c;
                char c2 = this.val$startInclusive;
                do {
                    table.set(c2);
                    c = c2;
                    c2 = (char)(c2 + '\u0001');
                } while (c != this.val$endInclusive);
            }

            @Override
            public final CharMatcher precomputed() {
                return this;
            }
        };
    }

    CharMatcher(String description) {
        this.description = description;
    }

    protected CharMatcher() {
        this.description = "UnknownCharMatcher";
    }

    public abstract boolean matches(char var1);

    public CharMatcher or(CharMatcher other) {
        return new Or(this, LookupTable.checkNotNull(other));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    CharMatcher withToString(String description) {
        throw new UnsupportedOperationException();
    }

    void setBits(LookupTable table) {
        char c;
        char c2 = '\u0000';
        do {
            if (this.matches(c2)) {
                table.set(c2);
            }
            c = c2;
            c2 = (char)(c2 + '\u0001');
        } while (c != 65535);
    }

    public int indexIn(CharSequence sequence, int start) {
        int length = sequence.length();
        LookupTable.checkPositionIndex(start, length);
        for (int i = start; i < length; ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.description;
    }

    static {
        CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000").or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200a')).withToString("CharMatcher.BREAKING_WHITESPACE").precomputed();
        CharMatcher.inRange('\u0000', '\u007f', "CharMatcher.ASCII");
        CharMatcher digit = CharMatcher.inRange('0', '9');
        String zeroes = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        for (char base : "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".toCharArray()) {
            digit = digit.or(CharMatcher.inRange(base, (char)(base + 9)));
        }
        digit.withToString("CharMatcher.DIGIT").precomputed();
        new CharMatcher("CharMatcher.JAVA_DIGIT"){

            @Override
            public final boolean matches(char c) {
                return Character.isDigit(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_LETTER"){

            @Override
            public final boolean matches(char c) {
                return Character.isLetter(c);
            }

            @Override
            public final CharMatcher precomputed() {
                return this;
            }
        };
        new CharMatcher("CharMatcher.JAVA_LETTER_OR_DIGIT"){

            @Override
            public final boolean matches(char c) {
                return Character.isLetterOrDigit(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_UPPER_CASE"){

            @Override
            public final boolean matches(char c) {
                return Character.isUpperCase(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_LOWER_CASE"){

            @Override
            public final boolean matches(char c) {
                return Character.isLowerCase(c);
            }
        };
        CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f')).withToString("CharMatcher.JAVA_ISO_CONTROL");
        CharMatcher.inRange('\u0000', ' ').or(CharMatcher.inRange('\u007f', '\u00a0')).or(CharMatcher.is('\u00ad')).or(CharMatcher.inRange('\u0600', '\u0604')).or(CharMatcher.anyOf("\u06dd\u070f\u1680\u180e")).or(CharMatcher.inRange('\u2000', '\u200f')).or(CharMatcher.inRange('\u2028', '\u202f')).or(CharMatcher.inRange('\u205f', '\u2064')).or(CharMatcher.inRange('\u206a', '\u206f')).or(CharMatcher.is('\u3000')).or(CharMatcher.inRange('\ud800', '\uf8ff')).or(CharMatcher.anyOf("\ufeff\ufff9\ufffa\ufffb")).withToString("CharMatcher.INVISIBLE").precomputed();
        CharMatcher.inRange('\u0000', '\u04f9').or(CharMatcher.is('\u05be')).or(CharMatcher.inRange('\u05d0', '\u05ea')).or(CharMatcher.is('\u05f3')).or(CharMatcher.is('\u05f4')).or(CharMatcher.inRange('\u0600', '\u06ff')).or(CharMatcher.inRange('\u0750', '\u077f')).or(CharMatcher.inRange('\u0e00', '\u0e7f')).or(CharMatcher.inRange('\u1e00', '\u20af')).or(CharMatcher.inRange('\u2100', '\u213a')).or(CharMatcher.inRange('\ufb50', '\ufdff')).or(CharMatcher.inRange('\ufe70', '\ufeff')).or(CharMatcher.inRange('\uff61', '\uffdc')).withToString("CharMatcher.SINGLE_WIDTH").precomputed();
        new CharMatcher("CharMatcher.ANY"){

            @Override
            public final boolean matches(char c) {
                return true;
            }

            @Override
            public final int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                LookupTable.checkPositionIndex(start, length);
                if (start == length) {
                    return -1;
                }
                return start;
            }

            @Override
            public final CharMatcher or(CharMatcher other) {
                LookupTable.checkNotNull(other);
                return this;
            }

            @Override
            public final CharMatcher precomputed() {
                return this;
            }
        };
        NONE = new CharMatcher("CharMatcher.NONE"){

            @Override
            public final boolean matches(char c) {
                return false;
            }

            @Override
            public final int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                LookupTable.checkPositionIndex(start, length);
                return -1;
            }

            @Override
            public final CharMatcher or(CharMatcher other) {
                return LookupTable.checkNotNull(other);
            }

            @Override
            final void setBits(LookupTable table) {
            }

            @Override
            public final CharMatcher precomputed() {
                return this;
            }
        };
        WHITESPACE = new CharMatcher("CharMatcher.WHITESPACE"){
            private final char[] table = new char[]{'\u0001', '\u0000', '\u00a0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\t', '\n', '\u000b', '\f', '\r', '\u0000', '\u0000', '\u2028', '\u2029', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u202f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u3000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0085', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u205f', '\u1680', '\u0000', '\u0000', '\u180e', '\u0000', '\u0000', '\u0000'};

            @Override
            public final boolean matches(char c) {
                return this.table[c % 79] == c;
            }

            @Override
            public final CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static final class LookupTable {
        int[] data = new int[2048];

        private LookupTable() {
        }

        final void set(char index) {
            int n = index >> 5;
            this.data[n] = this.data[n] | '\u0001' << index;
        }

        /* synthetic */ LookupTable(byte by) {
            this();
        }

        public static boolean equal(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }

        public static Objects$ToStringHelper toStringHelper(Object self) {
            Class<?> clazz = self.getClass();
            String string = clazz.getName();
            int n = (string = string.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
            if (n == -1) {
                n = string.lastIndexOf(46);
            }
            return new Objects$ToStringHelper(string.substring(n + 1), 0);
        }

        public static <T> T firstNonNull(T first, T second) {
            if (first != null) {
                return first;
            }
            return LookupTable.checkNotNull(second);
        }

        public static void checkArgument(boolean expression) {
            if (!expression) {
                throw new IllegalArgumentException();
            }
        }

        public static void checkArgument(boolean expression, Object errorMessage) {
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }

        public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
            if (!expression) {
                throw new IllegalArgumentException(LookupTable.format(errorMessageTemplate, errorMessageArgs));
            }
        }

        public static void checkState(boolean expression) {
            if (!expression) {
                throw new IllegalStateException();
            }
        }

        public static void checkState(boolean expression, Object errorMessage) {
            if (!expression) {
                throw new IllegalStateException(String.valueOf(errorMessage));
            }
        }

        public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
            if (!expression) {
                throw new IllegalStateException(LookupTable.format(errorMessageTemplate, errorMessageArgs));
            }
        }

        public static <T> T checkNotNull(T reference) {
            if (reference == null) {
                throw new NullPointerException();
            }
            return reference;
        }

        public static <T> T checkNotNull(T reference, Object errorMessage) {
            if (reference == null) {
                throw new NullPointerException(String.valueOf(errorMessage));
            }
            return reference;
        }

        public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
            if (reference == null) {
                throw new NullPointerException(LookupTable.format(errorMessageTemplate, errorMessageArgs));
            }
            return reference;
        }

        public static int checkElementIndex(int index, int size) {
            String string = "index";
            int n = size;
            int n2 = index;
            if (n2 < 0 || n2 >= n) {
                String string2;
                String string3 = string;
                int n3 = n;
                int n4 = n2;
                if (n4 < 0) {
                    string2 = LookupTable.format("%s (%s) must not be negative", string3, n4);
                } else {
                    if (n3 < 0) {
                        throw new IllegalArgumentException("negative size: " + n3);
                    }
                    string2 = LookupTable.format("%s (%s) must be less than size (%s)", string3, n4, n3);
                }
                throw new IndexOutOfBoundsException(string2);
            }
            return n2;
        }

        public static int checkPositionIndex(int index, int size) {
            String string = "index";
            int n = size;
            int n2 = index;
            if (n2 < 0 || n2 > n) {
                throw new IndexOutOfBoundsException(LookupTable.badPositionIndex(n2, n, string));
            }
            return n2;
        }

        private static String badPositionIndex(int index, int size, String desc) {
            if (index < 0) {
                return LookupTable.format("%s (%s) must not be negative", desc, index);
            }
            if (size < 0) {
                throw new IllegalArgumentException("negative size: " + size);
            }
            return LookupTable.format("%s (%s) must not be greater than size (%s)", desc, index, size);
        }

        public static void checkPositionIndexes(int start, int end, int size) {
            if (start < 0 || end < start || end > size) {
                int n = size;
                int n2 = end;
                int n3 = start;
                throw new IndexOutOfBoundsException(n3 < 0 || n3 > n ? LookupTable.badPositionIndex(n3, n, "start index") : (n2 < 0 || n2 > n ? LookupTable.badPositionIndex(n2, n, "end index") : LookupTable.format("end index (%s) must not be less than start index (%s)", n2, n3)));
            }
        }

        static String format(String template, Object ... args) {
            int placeholderStart;
            template = String.valueOf(template);
            StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
            int templateStart = 0;
            int i = 0;
            while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
                builder.append(template.substring(templateStart, placeholderStart));
                builder.append(args[i++]);
                templateStart = placeholderStart + 2;
            }
            builder.append(template.substring(templateStart));
            if (i < args.length) {
                builder.append(" [");
                builder.append(args[i++]);
                while (i < args.length) {
                    builder.append(", ");
                    builder.append(args[i++]);
                }
                builder.append(']');
            }
            return builder.toString();
        }

        public static <T> Supplier<T> ofInstance(T instance) {
            return new Suppliers$SupplierOfInstance<T>(instance);
        }
    }

    static final class Or
    extends CharMatcher {
        private CharMatcher first;
        private CharMatcher second;

        private Or(CharMatcher a, CharMatcher b, String description) {
            super(description);
            this.first = LookupTable.checkNotNull(a);
            this.second = LookupTable.checkNotNull(b);
        }

        Or(CharMatcher a, CharMatcher b) {
            this(a, b, "CharMatcher.or(" + a + ", " + b + ")");
        }

        @Override
        public final CharMatcher or(CharMatcher other) {
            return new Or(this, LookupTable.checkNotNull(other));
        }

        @Override
        public final boolean matches(char c) {
            return this.first.matches(c) || this.second.matches(c);
        }

        @Override
        final CharMatcher withToString(String description) {
            return new Or(this.first, this.second, description);
        }
    }
}

