/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.io.InputStream;
import jline.ConsoleReader;
import jline.UnixTerminal;
import jline.UnsupportedTerminal;
import jline.WindowsTerminal;

public abstract class Terminal {
    private static Terminal term;
    private static /* synthetic */ Class class$jline$Terminal;

    public static Terminal getTerminal() {
        return Terminal.setupTerminal();
    }

    public static void resetTerminal() {
        term = null;
    }

    public static synchronized Terminal setupTerminal() {
        Terminal t;
        if (term != null) {
            return term;
        }
        String os2 = System.getProperty("os.name").toLowerCase();
        String termProp = System.getProperty("jline.terminal");
        if (termProp != null && termProp.length() > 0) {
            try {
                t = (Terminal)Class.forName(termProp).newInstance();
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException(e.toString()).fillInStackTrace();
            }
        } else {
            t = os2.indexOf("windows") != -1 ? new WindowsTerminal() : new UnixTerminal();
        }
        try {
            t.initializeTerminal();
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
            term = new UnsupportedTerminal();
            return term;
        }
        term = t;
        return term;
    }

    public boolean isANSISupported() {
        return true;
    }

    public int readCharacter(InputStream in) throws IOException {
        return in.read();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        return this.readCharacter(in);
    }

    public abstract void initializeTerminal() throws Exception;

    public abstract int getTerminalWidth();

    public abstract int getTerminalHeight();

    public abstract boolean isSupported();

    public abstract boolean getEcho();

    public void beforeReadLine(ConsoleReader reader, String prompt, Character mask) {
    }

    public void afterReadLine$5d946c1f() {
    }

    public InputStream getDefaultBindings() {
        return (class$jline$Terminal == null ? (class$jline$Terminal = Terminal.class$("jline.Terminal")) : class$jline$Terminal).getResourceAsStream(System.getProperty("os.name").toLowerCase().startsWith("mac") ? "keybindings-mac.properties" : "keybindings.properties");
    }

    private static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

