/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class PyFileListing {
    private final List<PyFileInfo> pyFileInfos = new ArrayList<PyFileInfo>();
    private List<File> foldersFound = new ArrayList<File>();

    private static PyFileListing getPyFilesBelow(PyFileListing result, File file, FileFilter filter, IProgressMonitor monitor, boolean addSubFolders, int level, boolean checkHasInit, String currModuleRep, Set<File> canonicalFolders) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                FastStringBuffer buf = new FastStringBuffer(currModuleRep, 128);
                if (level != 0) {
                    FastStringBuffer newModuleRep = buf;
                    if (newModuleRep.length() != 0) {
                        newModuleRep.append('.');
                    }
                    newModuleRep.append(file.getName());
                    currModuleRep = newModuleRep.toString();
                }
                try {
                    File canonicalizedDir = file.getCanonicalFile();
                    if (!canonicalizedDir.equals(file) && canonicalFolders.contains(canonicalizedDir)) {
                        return result;
                    }
                    canonicalFolders.add(canonicalizedDir);
                }
                catch (IOException e) {
                    Log.log((Throwable)e);
                }
                File[] files = filter != null ? file.listFiles(filter) : file.listFiles();
                boolean hasInit = false;
                LinkedListWarningOnSlowOperations foldersLater = new LinkedListWarningOnSlowOperations();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file2 = fileArray[n2];
                        if (monitor.isCanceled()) break;
                        if (file2.isFile()) {
                            result.addPyFileInfo(new PyFileInfo(file2, currModuleRep));
                            monitor.worked(1);
                            monitor.setTaskName(buf.clear().append("Found:").append(file2.toString()).toString());
                            if (checkHasInit && !hasInit && PythonPathHelper.isValidInitFile(file2.getName())) {
                                hasInit = true;
                            }
                        } else {
                            foldersLater.add(file2);
                        }
                        ++n2;
                    }
                    if (!checkHasInit || hasInit || level == 0) {
                        result.foldersFound.add(file);
                        for (File folder : foldersLater) {
                            if (!monitor.isCanceled()) {
                                if (!folder.isDirectory() || !addSubFolders) continue;
                                PyFileListing.getPyFilesBelow(result, folder, filter, monitor, addSubFolders, level + 1, checkHasInit, currModuleRep, canonicalFolders);
                                monitor.worked(1);
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else {
                result.addPyFileInfo(new PyFileInfo(file, currModuleRep));
            }
        }
        return result;
    }

    private static PyFileListing getPyFilesBelow(File file, FileFilter filter, IProgressMonitor monitor, boolean addSubFolders, boolean checkHasInit) {
        PyFileListing result = new PyFileListing();
        return PyFileListing.getPyFilesBelow(result, file, filter, monitor, addSubFolders, 0, checkHasInit, "", new HashSet<File>());
    }

    public static PyFileListing getPyFilesBelow(File file, FileFilter filter, IProgressMonitor monitor, boolean checkHasInit) {
        return PyFileListing.getPyFilesBelow(file, filter, monitor, true, checkHasInit);
    }

    public static FileFilter getPyFilesFileFilter(final boolean includeDirs) {
        return new FileFilter(){
            private final String[] dottedValidSourceFiles = FileTypesPreferencesPage.getDottedValidSourceFiles();

            @Override
            public boolean accept(File pathname) {
                if (includeDirs) {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    return PythonPathHelper.isValidSourceFile(pathname.toString(), this.dottedValidSourceFiles);
                }
                if (pathname.isDirectory()) {
                    return false;
                }
                return PythonPathHelper.isValidSourceFile(pathname.toString(), this.dottedValidSourceFiles);
            }
        };
    }

    public static PyFileListing getPyFilesBelow(File file, IProgressMonitor monitor, boolean includeDirs, boolean checkHasInit) {
        FileFilter filter = PyFileListing.getPyFilesFileFilter(includeDirs);
        return PyFileListing.getPyFilesBelow(file, filter, monitor, true, checkHasInit);
    }

    public static List<IFile> getAllIFilesBelow(IContainer member) {
        final ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            member.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFile) {
                        ret.add((IFile)resource);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public Collection<PyFileInfo> getFoundPyFileInfos() {
        return this.pyFileInfos;
    }

    public Collection<File> getFoundFolders() {
        return this.foldersFound;
    }

    private void addPyFileInfo(PyFileInfo info) {
        this.pyFileInfos.add(info);
    }

    public static final class PyFileInfo {
        private final String relPath;
        private final File file;

        public PyFileInfo(File file, String relPath) {
            this.file = file;
            this.relPath = relPath;
        }

        public File getFile() {
            return this.file;
        }

        public String getPackageName() {
            return this.relPath;
        }

        public String toString() {
            return StringUtils.join((String)"", (Object[])new Object[]{"PyFileInfo:", this.file, " - ", this.relPath});
        }

        public String getModuleName(FastStringBuffer temp) {
            String scannedModuleName = this.getPackageName();
            String name = this.file.getName();
            String modName = scannedModuleName.length() != 0 ? temp.clear().append(scannedModuleName).append('.').append(PythonPathHelper.stripExtension(name)).toString() : PythonPathHelper.stripExtension(name);
            return modName;
        }
    }
}

