/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.project;

import java.io.File;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.PyProjectPythonDetails;
import org.python.pydev.ui.wizards.gettingstarted.AbstractNewProjectPage;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;
import org.python.pydev.ui.wizards.project.PythonProjectWizard;
import org.python.pydev.utils.ICallback;
import org.python.pydev.utils.PyFileListing;

public class NewProjectNameAndLocationWizardPage
extends AbstractNewProjectPage
implements IWizardNewProjectNameAndLocationPage {
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private PyProjectPythonDetails.ProjectInterpreterAndGrammarConfig details;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            NewProjectNameAndLocationWizardPage.this.setLocationForSelection();
            NewProjectNameAndLocationWizardPage.this.setPageComplete(NewProjectNameAndLocationWizardPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            NewProjectNameAndLocationWizardPage.this.setPageComplete(NewProjectNameAndLocationWizardPage.this.validatePage());
        }
    };
    protected Button checkSrcFolder;
    protected Button projectAsSrcFolder;
    protected Button exSrcFolder;
    protected Button noSrcFolder;
    private static final String RESOURCE = "org.eclipse.ui.resourceWorkingSetPage";
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private final WorkingSetGroup fWorkingSetGroup;

    @Override
    public String getProjectType() {
        return this.details.getSelectedPythonOrJythonAndGrammarVersion();
    }

    @Override
    public String getProjectInterpreter() {
        return this.details.getProjectInterpreter();
    }

    public NewProjectNameAndLocationWizardPage(String pageName) {
        super(pageName);
        this.setTitle("PyDev Project");
        this.setDescription("Create a new PyDev Project.");
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
        this.customLocationFieldValue = "";
        this.fWorkingSetGroup = new WorkingSetGroup();
        this.setWorkingSets(new IWorkingSet[0]);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.createProjectDetails(composite);
        this.projectAsSrcFolder = new Button(composite, 16);
        this.projectAsSrcFolder.setText("&Add project directory to the PYTHONPATH");
        this.checkSrcFolder = new Button(composite, 16);
        this.checkSrcFolder.setText("Cr&eate 'src' folder and add it to the PYTHONPATH");
        this.exSrcFolder = new Button(composite, 16);
        this.exSrcFolder.setText("Create links to e&xisting sources (select them on the next page)");
        this.noSrcFolder = new Button(composite, 16);
        this.noSrcFolder.setText("Don't configure PYTHONPATH (to be done &manually later on)");
        IPreferenceStore preferences = PydevPrefs.getPreferences();
        int srcFolderCreate = preferences.getInt("PYDEV_NEW_PROJECT_CREATE_PREFERENCES");
        switch (srcFolderCreate) {
            case 1: {
                this.projectAsSrcFolder.setSelection(true);
                break;
            }
            case 2: {
                this.exSrcFolder.setSelection(true);
                break;
            }
            case 3: {
                this.noSrcFolder.setSelection(true);
                break;
            }
            default: {
                this.checkSrcFolder.setSelection(true);
            }
        }
        this.checkSrcFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == NewProjectNameAndLocationWizardPage.this.checkSrcFolder) {
                    IPreferenceStore preferences = PydevPrefs.getPreferences();
                    if (NewProjectNameAndLocationWizardPage.this.checkSrcFolder.getSelection()) {
                        preferences.setValue("PYDEV_NEW_PROJECT_CREATE_PREFERENCES", 0);
                        NewProjectNameAndLocationWizardPage.this.setPageComplete(NewProjectNameAndLocationWizardPage.this.validatePage());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.projectAsSrcFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == NewProjectNameAndLocationWizardPage.this.projectAsSrcFolder) {
                    IPreferenceStore preferences = PydevPrefs.getPreferences();
                    if (NewProjectNameAndLocationWizardPage.this.projectAsSrcFolder.getSelection()) {
                        preferences.setValue("PYDEV_NEW_PROJECT_CREATE_PREFERENCES", 1);
                        NewProjectNameAndLocationWizardPage.this.setPageComplete(NewProjectNameAndLocationWizardPage.this.validatePage());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.exSrcFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == NewProjectNameAndLocationWizardPage.this.exSrcFolder) {
                    IPreferenceStore preferences = PydevPrefs.getPreferences();
                    if (NewProjectNameAndLocationWizardPage.this.exSrcFolder.getSelection()) {
                        preferences.setValue("PYDEV_NEW_PROJECT_CREATE_PREFERENCES", 2);
                        NewProjectNameAndLocationWizardPage.this.setPageComplete(NewProjectNameAndLocationWizardPage.this.validatePage());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.noSrcFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == NewProjectNameAndLocationWizardPage.this.noSrcFolder) {
                    IPreferenceStore preferences = PydevPrefs.getPreferences();
                    if (NewProjectNameAndLocationWizardPage.this.noSrcFolder.getSelection()) {
                        preferences.setValue("PYDEV_NEW_PROJECT_CREATE_PREFERENCES", 3);
                        NewProjectNameAndLocationWizardPage.this.setPageComplete(NewProjectNameAndLocationWizardPage.this.validatePage());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Control workingSetControl = this.createWorkingSetControl(composite);
        workingSetControl.setLayoutData((Object)new GridData(768));
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected Control createWorkingSetControl(Composite composite) {
        return this.fWorkingSetGroup.createControl(composite);
    }

    @Override
    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSetGroup.getSelectedWorkingSets();
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingSetGroup.setWorkingSets(workingSets);
    }

    private void createProjectDetails(Composite parent) {
        Font font = parent.getFont();
        Composite projectDetails = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        projectDetails.setLayout((Layout)layout);
        projectDetails.setLayoutData((Object)new GridData(768));
        projectDetails.setFont(font);
        Label projectTypeLabel = new Label(projectDetails, 0);
        projectTypeLabel.setFont(font);
        projectTypeLabel.setText("Project type");
        this.details = new PyProjectPythonDetails.ProjectInterpreterAndGrammarConfig(new ICallback(){

            @Override
            public Object call(Object args) throws Exception {
                NewProjectNameAndLocationWizardPage.this.setPageComplete(NewProjectNameAndLocationWizardPage.this.validatePage());
                return null;
            }
        });
        Control createdOn = this.details.doCreateContents(projectDetails);
        this.details.setDefaultSelection();
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        createdOn.setLayoutData((Object)data);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(font);
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setFont(font);
        projectContentsLabel.setText("Project contents:");
        GridData labelData = new GridData();
        labelData.horizontalSpan = 3;
        projectContentsLabel.setLayoutData((Object)labelData);
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setText("Use &default");
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectNameAndLocationWizardPage.this.useDefaults = useDefaultsButton.getSelection();
                NewProjectNameAndLocationWizardPage.this.browseButton.setEnabled(!NewProjectNameAndLocationWizardPage.this.useDefaults);
                NewProjectNameAndLocationWizardPage.this.locationPathField.setEnabled(!NewProjectNameAndLocationWizardPage.this.useDefaults);
                NewProjectNameAndLocationWizardPage.this.locationLabel.setEnabled(!NewProjectNameAndLocationWizardPage.this.useDefaults);
                if (NewProjectNameAndLocationWizardPage.this.useDefaults) {
                    NewProjectNameAndLocationWizardPage.this.customLocationFieldValue = NewProjectNameAndLocationWizardPage.this.locationPathField.getText();
                    NewProjectNameAndLocationWizardPage.this.setLocationForSelection();
                } else {
                    NewProjectNameAndLocationWizardPage.this.locationPathField.setText(NewProjectNameAndLocationWizardPage.this.customLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setFont(font);
        projectLabel.setText("&Project name:");
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(font);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        Font font = projectGroup.getFont();
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setFont(font);
        this.locationLabel.setText("Director&y");
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(font);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText("B&rowse");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewProjectNameAndLocationWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    @Override
    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.getProjectLocationFieldValue());
    }

    @Override
    public IProject getProjectHandle() {
        return PyStructureConfigHelpers.getProjectHandle(this.getProjectName());
    }

    @Override
    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage("Select the project contents directory.");
        String dirName = this.getProjectLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    private boolean isDotProjectFileInLocation() {
        Path path = new Path(this.getProjectLocationFieldValue());
        path = path.append(".project");
        return path.toFile().exists();
    }

    void setInitialProjectName(String name) {
        this.initialProjectFieldValue = name == null ? null : name.trim();
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.getProjectNameFieldValue());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }

    protected boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage("Project name is empty");
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage("Project location is empty");
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage("Project location is not valid");
            return false;
        }
        IProject projectHandle = this.getProjectHandle();
        if (projectHandle.exists()) {
            this.setErrorMessage("Project already exists");
            return false;
        }
        if (!this.useDefaults && (path = this.getLocationPath()).equals((Object)workspace.getRoot().getLocation())) {
            this.setErrorMessage("Project location cannot be the workspace location.");
            return false;
        }
        if (this.isDotProjectFileInLocation()) {
            this.setErrorMessage(".project found in: " + this.getLocationPath().toOSString() + " (use the Import Project wizard instead).");
            return false;
        }
        if (this.getProjectInterpreter() == null) {
            this.setErrorMessage("Project interpreter not specified");
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        File locFile = (!this.useDefaults ? this.getLocationPath() : this.getLocationPath().append(projectFieldContents)).toFile();
        PyFileListing pyFileListing = PythonPathHelper.getModulesBelow(locFile, null);
        if (pyFileListing != null) {
            boolean foundInit = false;
            Collection<PyFileListing.PyFileInfo> modulesBelow = pyFileListing.getFoundPyFileInfos();
            for (PyFileListing.PyFileInfo fileInfo : modulesBelow) {
                if (!PythonPathHelper.isValidInitFile(fileInfo.getFile().getPath()) || !fileInfo.getFile().getParentFile().equals(locFile)) continue;
                this.setMessage("Project location contains an __init__.py file. Consider using the location's parent folder instead.");
                foundInit = true;
                break;
            }
            if (!foundInit && modulesBelow.size() > 0) {
                this.setMessage("Project location contains existing Python files. The created project will include them.");
            }
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    @Override
    public int getSourceFolderConfigurationStyle() {
        IPreferenceStore preferences = PydevPrefs.getPreferences();
        int srcFolderCreate = preferences.getInt("PYDEV_NEW_PROJECT_CREATE_PREFERENCES");
        switch (srcFolderCreate) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public void setProjectName(String projectName) {
        this.projectNameField.setText(projectName);
    }

    public IWizardPage getNextPage() {
        PythonProjectWizard wizard = (PythonProjectWizard)this.getWizard();
        if (this.getSourceFolderConfigurationStyle() == 2) {
            return wizard.getSourcesPage();
        }
        return wizard.getPageAfterSourcesPage();
    }

    private final class WorkingSetGroup {
        private WorkingSetConfigurationBlock fWorkingSetBlock;

        public WorkingSetGroup() {
            String[] workingSetIds = new String[]{NewProjectNameAndLocationWizardPage.RESOURCE};
            this.fWorkingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, PydevPlugin.getDefault().getDialogSettings());
        }

        public Control createControl(Composite composite) {
            Group workingSetGroup = new Group(composite, 0);
            workingSetGroup.setFont(composite.getFont());
            workingSetGroup.setText("Working sets");
            workingSetGroup.setLayout((Layout)new GridLayout(1, false));
            this.fWorkingSetBlock.createContent((Composite)workingSetGroup);
            return workingSetGroup;
        }

        public void setWorkingSets(IWorkingSet[] workingSets) {
            this.fWorkingSetBlock.setWorkingSets(workingSets);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
    }
}

