/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.utils.AsynchronousProgressMonitorDialog;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.ui.pythonpathconf.ObtainInterpreterInfoOperation;

public class InterpreterConfigHelpers {
    public static final int CONFIG_MANUAL = 0;
    public static final int CONFIG_AUTO = 1;
    public static final int CONFIG_ADV_AUTO = 2;
    public static final String[] CONFIG_NAMES = new String[]{"Manual Config", "Quick Auto-Config", "Advanced Auto-Config"};
    public static final int NUM_CONFIG_TYPES = 3;
    public static final String ERMSG_NOLIBS = "The interpreter's standard libraries (typically in a Lib/ folder) are missing: ";

    static ObtainInterpreterInfoOperation tryInterpreter(Tuple<String, String> interpreterNameAndExecutable, IInterpreterManager interpreterManager, boolean autoSelectFolders, boolean displayErrors, PrintWriter logger, Shell shell) throws Exception {
        ObtainInterpreterInfoOperation operation;
        block28: {
            String executable;
            block29: {
                int choice;
                executable = (String)interpreterNameAndExecutable.o2;
                logger.println("- Ok, file is non-null. Getting info on:" + executable);
                AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(shell);
                monitorDialog.setBlockOnOpen(false);
                do {
                    operation = new ObtainInterpreterInfoOperation((String)interpreterNameAndExecutable.o2, logger, interpreterManager, autoSelectFolders);
                    monitorDialog.run(true, false, (IRunnableWithProgress)operation);
                    if (operation.e != null) {
                        logger.println("- Some error happened while getting info on the interpreter:");
                        operation.e.printStackTrace(logger);
                        String errorTitle = "Unable to get info on the interpreter: " + executable;
                        if (operation.e instanceof SimpleJythonRunner.JavaNotConfiguredException) {
                            SimpleJythonRunner.JavaNotConfiguredException javaNotConfiguredException = (SimpleJythonRunner.JavaNotConfiguredException)operation.e;
                            if (displayErrors) {
                                ErrorDialog.openError((Shell)shell, (String)errorTitle, (String)javaNotConfiguredException.getMessage(), (IStatus)PydevPlugin.makeStatus(4, "Java vm not configured.\n", javaNotConfiguredException));
                            }
                            throw new Exception(javaNotConfiguredException);
                        }
                        if (operation.e instanceof JDTNotAvailableException) {
                            JDTNotAvailableException noJdtException = (JDTNotAvailableException)operation.e;
                            if (displayErrors) {
                                ErrorDialog.openError((Shell)shell, (String)errorTitle, (String)noJdtException.getMessage(), (IStatus)PydevPlugin.makeStatus(4, "JDT not available.\n", noJdtException));
                            }
                            throw new Exception(noJdtException);
                        }
                        if (displayErrors) {
                            String errorMsg = "Unable to get info on the interpreter: " + executable + "\n\n" + "Common reasons include:\n\n" + "- Using an unsupported version\n" + "  (Python and Jython require at least version 2.1 and IronPython 2.6).\n" + "\n" + "- Specifying an invalid interpreter\n" + "  (usually a link to the actual interpreter on Mac or Linux)";
                            ErrorDialog.openError((Shell)shell, (String)errorTitle, (String)errorMsg, (IStatus)PydevPlugin.makeStatus(4, "See error log for details.", operation.e));
                        }
                        throw new Exception(operation.e);
                    }
                    if (operation.result == null) {
                        return null;
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add("threading");
                    hashSet.add("traceback");
                    String[] validSourceFiles = FileTypesPreferencesPage.getValidSourceFiles();
                    HashSet<String> extensions = new HashSet<String>(Arrays.asList(validSourceFiles));
                    for (String s : operation.result.libs) {
                        File file = new File(s);
                        if (file.isDirectory()) {
                            String[] directoryFiles = file.list();
                            if (directoryFiles != null) {
                                String[] stringArray = directoryFiles;
                                int n = directoryFiles.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String found = stringArray[n2];
                                    List split = StringUtils.split((String)found, (char)'.');
                                    if (split.size() == 2 && extensions.contains(split.get(1))) {
                                        hashSet.remove(split.get(0));
                                    }
                                    ++n2;
                                }
                                continue;
                            }
                            logger.append("Warning: unable to get contents of directory: " + file + " (permission not available, it's not a dir or dir does not exist).");
                            continue;
                        }
                        if (!file.isFile()) continue;
                        try {
                            Throwable throwable = null;
                            Object var16_18 = null;
                            try (ZipFile zipFile = new ZipFile(file);){
                                String[] stringArray = validSourceFiles;
                                int n = validSourceFiles.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    String extension = stringArray[n3];
                                    if (zipFile.getEntry("threading." + extension) != null) {
                                        hashSet.remove("threading");
                                    }
                                    if (zipFile.getEntry("traceback." + extension) != null) {
                                        hashSet.remove("traceback");
                                    }
                                    ++n3;
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (hashSet.size() <= 0) break block28;
                    if (!displayErrors) break block29;
                } while ((choice = PyDialogHelpers.openCriticalWithChoices("Error: Python stdlib source files not found.", "Error: Python stdlib not found or stdlib found without .py files.\n\nIt seems that the Python /Lib folder (which contains the standard library) was not found/selected during the install process or the stdlib does not contain the required .py files (i.e.: only has .pyc files).\n\nThis folder (which contains files such as threading.py and traceback.py) is required for PyDev to function properly, and it must contain the actual source files, not only .pyc files. if you don't have the .py files in your install, please use an install from python.org or grab the standard library for your install from there.\n\nIf this is a virtualenv install, the /Lib folder from the base install needs to be selected (unlike the site-packages which is optional).\n\nWhat do you want to do?\n\nNote: if you choose to proceed, the /Lib with the standard library .py source files must be added later on, otherwise PyDev may not function properly.", new String[]{"Re-select folders", "Cancel", "Proceed anyways"})) == 0);
                if (choice == 1) {
                    return null;
                }
                break block28;
            }
            logger.println("- Could not find /Lib folder, exiting with error.");
            throw new Exception(ERMSG_NOLIBS + executable);
        }
        operation.result.setName((String)interpreterNameAndExecutable.o1);
        logger.println("- Success getting the info. Result:" + operation.result);
        return operation;
    }

    static boolean checkInterpreterNameAndExecutable(Tuple<String, String> interpreterNameAndExecutable, PrintWriter logger, String errorMsg, Map<String, IInterpreterInfo> nameToInfo, Shell shell) {
        String error;
        boolean foundError = false;
        if (interpreterNameAndExecutable == null) {
            logger.println("- When trimmed, the chosen file was null (returning null).");
            if (shell != null) {
                ErrorDialog.openError((Shell)shell, (String)errorMsg, (String)"interpreterNameAndExecutable == null", (IStatus)PydevPlugin.makeStatus(4, "interpreterNameAndExecutable == null", new RuntimeException()));
            }
            foundError = true;
        }
        if (!foundError && ((String)interpreterNameAndExecutable.o2).trim().length() == 0) {
            logger.println("- When trimmed, the chosen file was empty (returning null).");
            if (shell != null) {
                ErrorDialog.openError((Shell)shell, (String)errorMsg, (String)"interpreterNameAndExecutable size == empty", (IStatus)PydevPlugin.makeStatus(4, "interpreterNameAndExecutable size == empty", new RuntimeException()));
            }
            foundError = true;
        }
        if (!foundError && nameToInfo != null && (error = InterpreterConfigHelpers.getDuplicatedMessageError((String)interpreterNameAndExecutable.o1, (String)interpreterNameAndExecutable.o2, nameToInfo)) != null) {
            logger.println("- Duplicated interpreter found.");
            if (shell != null) {
                ErrorDialog.openError((Shell)shell, (String)errorMsg, (String)error, (IStatus)PydevPlugin.makeStatus(4, "Duplicated interpreter information", new RuntimeException()));
            }
            foundError = true;
        }
        return foundError;
    }

    public static String getUniqueInterpreterName(String expectedName, Map<String, IInterpreterInfo> nameToInfo) {
        if (nameToInfo == null) {
            return expectedName;
        }
        String additional = "";
        int i = 0;
        while (InterpreterConfigHelpers.getDuplicatedMessageError(String.valueOf(expectedName) + additional, null, nameToInfo) != null) {
            additional = String.valueOf(++i);
        }
        return String.valueOf(expectedName) + additional;
    }

    public static String getDuplicatedMessageError(String interpreterName, String executableOrJar, Map<String, IInterpreterInfo> nameToInfo) {
        if (nameToInfo == null) {
            return null;
        }
        String error = null;
        if (interpreterName != null && nameToInfo.containsKey(interpreterName = interpreterName.trim())) {
            error = "An interpreter is already configured with the name: " + interpreterName;
        }
        if (executableOrJar != null) {
            executableOrJar = executableOrJar.trim();
            for (IInterpreterInfo info : nameToInfo.values()) {
                if (!info.getExecutableOrJar().trim().equals(executableOrJar)) continue;
                error = "An interpreter is already configured with the path: " + executableOrJar;
            }
        }
        return error;
    }

    public static HashSet<IPath> getRootPaths() {
        IProject[] projects;
        HashSet<IPath> rootPaths = new HashSet<IPath>();
        if (SharedCorePlugin.inTestMode()) {
            return rootPaths;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootLocation = root.getLocation().makeAbsolute();
        rootPaths.add(rootLocation);
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IPath abs;
            IProject iProject = iProjectArray[n2];
            IPath location = iProject.getLocation();
            if (location != null && !rootLocation.isPrefixOf(abs = location.makeAbsolute())) {
                rootPaths.add(abs);
            }
            ++n2;
        }
        return rootPaths;
    }

    public static boolean isChildOfRootPath(String data, Set<IPath> rootPaths) {
        IPath path = Path.fromOSString((String)data);
        for (IPath p : rootPaths) {
            if (!p.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }
}

