/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.interpreters;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.UIJob;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IInterpreterManagerListener;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.NotConfiguredInterpreterException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.SyncSystemModulesManagerScheduler;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.PythonNatureListenersManager;
import org.python.pydev.shared_core.callbacks.ListenerList;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.interpreters.IInterpreterObserver;
import org.python.pydev.ui.pythonpathconf.AutoConfigMaker;
import org.python.pydev.ui.pythonpathconf.IInterpreterProviderFactory;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public abstract class AbstractInterpreterManager
implements IInterpreterManager {
    private int modificationStamp = 0;
    protected final Map<String, InterpreterInfo> exeToInfo = new HashMap<String, InterpreterInfo>();
    private final IPreferenceStore prefs;
    protected final Map<String, IToken[]> builtinCompletions = new HashMap<String, IToken[]>();
    protected final Map<String, IModule> builtinMod = new HashMap<String, IModule>();
    private ListenerList<IInterpreterManagerListener> listeners = new ListenerList(IInterpreterManagerListener.class);
    private static ConfigureInterpreterJob configureInterpreterJob = new ConfigureInterpreterJob();
    private volatile IInterpreterInfo[] interpreterInfosFromPersistedString;
    private Object lock = new Object();
    private String persistedCache;
    private IInterpreterInfo[] persistedCacheRet;
    String persistedString;

    public void clearBuiltinCompletions(String projectInterpreterName) {
        this.builtinCompletions.remove(projectInterpreterName);
    }

    public void addListener(IInterpreterManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    public IToken[] getBuiltinCompletions(String projectInterpreterName) {
        IModule builtMod;
        if ((projectInterpreterName = this.getInternalName(projectInterpreterName)) == null) {
            return null;
        }
        IToken[] toks = this.builtinCompletions.get(projectInterpreterName);
        if ((toks == null || toks.length == 0) && (builtMod = this.getBuiltinMod(projectInterpreterName)) != null) {
            toks = builtMod.getGlobalTokens();
            this.builtinCompletions.put(projectInterpreterName, toks);
        }
        return this.builtinCompletions.get(projectInterpreterName);
    }

    public IModule getBuiltinMod(String projectInterpreterName) {
        if ((projectInterpreterName = this.getInternalName(projectInterpreterName)) == null) {
            return null;
        }
        IModule mod = this.builtinMod.get(projectInterpreterName);
        if (mod != null) {
            return mod;
        }
        try {
            InterpreterInfo interpreterInfo = this.getInterpreterInfo(projectInterpreterName, null);
            ISystemModulesManager modulesManager = interpreterInfo.getModulesManager();
            mod = modulesManager.getBuiltinModule("__builtin__", false);
            if (mod == null) {
                mod = modulesManager.getBuiltinModule("builtins", false);
            }
            if (mod != null) {
                this.builtinMod.put(projectInterpreterName, mod);
            }
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
        }
        return this.builtinMod.get(projectInterpreterName);
    }

    private String getInternalName(String projectInterpreterName) {
        if ("Default".equals(projectInterpreterName)) {
            try {
                return this.getDefaultInterpreterInfo(true).getExecutableOrJar();
            }
            catch (NotConfiguredInterpreterException e) {
                Log.log((Throwable)e);
                return projectInterpreterName;
            }
        }
        return projectInterpreterName;
    }

    public void clearBuiltinMod(String projectInterpreterName) {
        this.builtinMod.remove(projectInterpreterName);
    }

    public AbstractInterpreterManager(IPreferenceStore prefs) {
        this.prefs = prefs;
        prefs.setDefault(this.getPreferenceName(), "");
        this.getInterpreterInfos();
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_observer");
        for (IInterpreterObserver observer : participants) {
            observer.notifyInterpreterManagerRecreated(this);
        }
    }

    public boolean isConfigured() {
        String defaultInterpreter;
        block3: {
            try {
                defaultInterpreter = this.getDefaultInterpreterInfo(false).getExecutableOrJar();
                if (defaultInterpreter != null) break block3;
                return false;
            }
            catch (NotConfiguredInterpreterException notConfiguredInterpreterException) {
                return false;
            }
        }
        return defaultInterpreter.length() != 0;
    }

    public void clearCaches() {
        this.builtinMod.clear();
        this.builtinCompletions.clear();
        this.clearInterpretersFromPersistedString();
    }

    protected abstract String getPreferenceName();

    public IInterpreterInfo getDefaultInterpreterInfo(boolean autoConfigureIfNotConfigured) throws NotConfiguredInterpreterException {
        IInterpreterInfo[] interpreters = this.getInterpreterInfos();
        String errorMsg = null;
        if (interpreters.length > 0) {
            IInterpreterInfo defaultInfo = interpreters[0];
            String interpreter = defaultInfo.getExecutableOrJar();
            if (interpreter == null) {
                errorMsg = "The configured interpreter for " + this.getInterpreterUIName() + " is null, some error happened getting it.";
            }
            return defaultInfo;
        }
        errorMsg = String.valueOf(this.getInterpreterUIName()) + " not configured.";
        if (autoConfigureIfNotConfigured && PyDialogHelpers.getAskAgainInterpreter(this)) {
            configureInterpreterJob.addInterpreter(this);
            configureInterpreterJob.schedule(50L);
        }
        throw new NotConfiguredInterpreterException(errorMsg);
    }

    protected abstract String getPreferencesPageId();

    public abstract String getInterpreterUIName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInterpretersFromPersistedString() {
        Object object = this.lock;
        synchronized (object) {
            if (this.interpreterInfosFromPersistedString != null) {
                this.exeToInfo.clear();
                this.interpreterInfosFromPersistedString = null;
            }
        }
    }

    public IInterpreterInfo[] getInterpreterInfos() {
        return this.internalRecreateCacheGetInterpreterInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IInterpreterInfo[] internalRecreateCacheGetInterpreterInfos() {
        IInterpreterInfo[] interpreters = this.interpreterInfosFromPersistedString;
        if (interpreters == null) {
            Object object = this.lock;
            synchronized (object) {
                int n;
                int n2;
                IInterpreterInfo[] iInterpreterInfoArray;
                if (this.interpreterInfosFromPersistedString != null) {
                    interpreters = this.interpreterInfosFromPersistedString;
                } else {
                    interpreters = this.getInterpretersFromPersistedString(this.getPersistedString());
                    try {
                        this.exeToInfo.clear();
                        iInterpreterInfoArray = interpreters;
                        n2 = interpreters.length;
                        n = 0;
                        while (n < n2) {
                            IInterpreterInfo info = iInterpreterInfoArray[n];
                            this.exeToInfo.put(info.getExecutableOrJar(), (InterpreterInfo)info);
                            ++n;
                        }
                    }
                    finally {
                        this.interpreterInfosFromPersistedString = interpreters;
                    }
                }
                iInterpreterInfoArray = this.interpreterInfosFromPersistedString;
                n2 = this.interpreterInfosFromPersistedString.length;
                n = 0;
                while (n < n2) {
                    IInterpreterInfo iInterpreterInfo = iInterpreterInfoArray[n];
                    iInterpreterInfo.setModificationStamp(this.modificationStamp);
                    ++n;
                }
            }
        }
        return interpreters;
    }

    protected abstract Tuple<InterpreterInfo, String> internalCreateInterpreterInfo(String var1, IProgressMonitor var2, boolean var3) throws CoreException, JDTNotAvailableException;

    public IInterpreterInfo createInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) {
        InterpreterInfo info;
        Tuple<InterpreterInfo, String> tup;
        block8: {
            monitor.worked(5);
            tup = null;
            tup = this.internalCreateInterpreterInfo(executable, monitor, askUser);
            if (tup != null) break block8;
            return null;
        }
        try {
            info = (InterpreterInfo)tup.o1;
        }
        catch (RuntimeException e) {
            Log.log((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new RuntimeException(e);
        }
        if (info.executableOrJar == null || info.executableOrJar.trim().length() == 0) {
            final String title = "Invalid interpreter:" + executable;
            String reasonCreation = "The interpreter (or jar): '" + executable + "' is not valid - info.executable found: " + info.executableOrJar + "\n";
            if (tup != null) {
                reasonCreation = String.valueOf(reasonCreation) + "The standard output gotten from the executed shell was: >>" + (String)tup.o2 + "<<";
            }
            final String reason = reasonCreation;
            try {
                Display disp = Display.getDefault();
                disp.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError(null, (String)title, (String)"Unable to get information on interpreter!", (IStatus)new Status(4, PydevPlugin.getPluginID(), 0, reason, null));
                    }
                });
            }
            catch (Throwable throwable) {}
            throw new RuntimeException(reason);
        }
        return info;
    }

    protected static InterpreterInfo createInfoFromOutput(IProgressMonitor monitor, Tuple<String, String> outTup, boolean askUser, String executableName, boolean executableIsUserSpecified) {
        String executableToUse;
        if (outTup.o1 == null || ((String)outTup.o1).trim().length() == 0) {
            throw new RuntimeException("No output was in the standard output when\ntrying to create the interpreter info for: " + executableName + "\nThe error output contains:>>" + (String)outTup.o2 + "<<");
        }
        String string = executableToUse = executableIsUserSpecified ? executableName : null;
        if (executableToUse != null && !new File(executableToUse).exists()) {
            executableToUse = null;
        }
        InterpreterInfo info = InterpreterInfo.fromString((String)outTup.o1, askUser, executableToUse);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterInfo getInterpreterInfo(String nameOrExecutableOrJar, IProgressMonitor monitor) throws MisconfigurationException {
        Object object = this.lock;
        synchronized (object) {
            if (this.interpreterInfosFromPersistedString == null) {
                this.internalRecreateCacheGetInterpreterInfos();
            }
            for (IInterpreterInfo iInterpreterInfo : this.exeToInfo.values()) {
                if (iInterpreterInfo == null || !iInterpreterInfo.matchNameBackwardCompatible(nameOrExecutableOrJar)) continue;
                return (InterpreterInfo)iInterpreterInfo;
            }
        }
        throw new MisconfigurationException(StringUtils.format((String)"Interpreter: %s not found", (Object[])new Object[]{nameOrExecutableOrJar}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInterpreterInfo[] getInterpretersFromPersistedString(String persisted) {
        Object object = this.lock;
        synchronized (object) {
            if (persisted == null || persisted.trim().length() == 0) {
                return new IInterpreterInfo[0];
            }
            if (this.persistedCache == null || !this.persistedCache.equals(persisted)) {
                ArrayList<InterpreterInfo> ret = new ArrayList<InterpreterInfo>();
                try {
                    String[] strings;
                    ArrayList<InterpreterInfo> list = new ArrayList<InterpreterInfo>();
                    String[] stringArray = strings = persisted.split("&&&&&");
                    int n = strings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        try {
                            list.add(InterpreterInfo.fromString(string, false));
                        }
                        catch (Exception e) {
                            String errMsg = "Interpreter storage changed.\r\nPlease restore it (window > preferences > Pydev > Interpreter)";
                            Log.log((String)errMsg, (Throwable)e);
                            return new IInterpreterInfo[0];
                        }
                        ++n2;
                    }
                    for (InterpreterInfo info : list) {
                        if (info == null || info.executableOrJar == null) continue;
                        ret.add(info);
                    }
                    for (InterpreterInfo info : list) {
                        try {
                            info.getModulesManager().load();
                        }
                        catch (Exception e) {
                            Log.logInfo((Throwable)new RuntimeException("Restoring info for: " + info.getExecutableOrJar(), e));
                            info.setLoadFinished(false);
                            try {
                                NullProgressMonitor monitor = new NullProgressMonitor();
                                info.restorePythonpath((IProgressMonitor)monitor);
                                info.getModulesManager().save();
                            }
                            finally {
                                info.setLoadFinished(true);
                            }
                            Log.logInfo((String)("Finished restoring information for: " + info.executableOrJar + " at: " + info.getModulesManager().getIoDirectory()));
                        }
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    return new IInterpreterInfo[0];
                }
                this.persistedCache = persisted;
                this.persistedCacheRet = ret.toArray(new IInterpreterInfo[0]);
            }
        }
        return this.persistedCacheRet;
    }

    public static String getStringToPersist(IInterpreterInfo[] executables) {
        FastStringBuffer buf = new FastStringBuffer();
        IInterpreterInfo[] iInterpreterInfoArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInfo info = iInterpreterInfoArray[n2];
            if (info != null) {
                buf.append(info.toString());
                buf.append("&&&&&");
            }
            ++n2;
        }
        return buf.toString();
    }

    protected static File getInterpreterInfoPy() throws CoreException {
        File script = PydevPlugin.getScriptWithinPySrc("interpreterInfo.py");
        if (!script.exists()) {
            throw new RuntimeException("The file specified does not exist: " + script);
        }
        return script;
    }

    public String getPersistedString() {
        if (this.persistedString == null) {
            this.persistedString = this.prefs.getString(this.getPreferenceName());
        }
        return this.persistedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfos(IInterpreterInfo[] infos, Set<String> interpreterNamesToRestore, IProgressMonitor monitor) {
        IInterpreterInfo[] interpreterInfos;
        Object message;
        String s;
        block18: {
            s = AbstractInterpreterManager.getStringToPersist(infos);
            this.prefs.setValue(this.getPreferenceName(), s);
            if (this.prefs instanceof IPersistentPreferenceStore) {
                try {
                    ((IPersistentPreferenceStore)this.prefs).save();
                }
                catch (Exception e) {
                    message = e.getMessage();
                    if (message != null && ((String)message).indexOf("File name not specified") != -1) break block18;
                    Log.log((Throwable)e);
                }
            }
        }
        try {
            IInterpreterManagerListener[] managerListeners;
            message = this.lock;
            synchronized (message) {
                ++this.modificationStamp;
                this.clearInterpretersFromPersistedString();
                this.persistedString = s;
                interpreterInfos = this.internalRecreateCacheGetInterpreterInfos();
                this.restorePythopathForInterpreters(monitor, interpreterNamesToRestore);
                for (InterpreterInfo info : this.exeToInfo.values()) {
                    try {
                        PythonPathHelper pathHelper;
                        List<String> pythonpath;
                        ISystemModulesManager modulesManager = info.getModulesManager();
                        Object pythonPathHelper = modulesManager.getPythonPathHelper();
                        if (!(pythonPathHelper instanceof PythonPathHelper) || (pythonpath = (pathHelper = (PythonPathHelper)pythonPathHelper).getPythonpath()) == null || pythonpath.size() == 0) continue;
                        modulesManager.save();
                    }
                    catch (Throwable e22) {
                        Log.log((Throwable)e22);
                    }
                }
            }
            this.restorePythopathForNatures(monitor);
            IInterpreterInfo[] e22 = interpreterInfos;
            int n = interpreterInfos.length;
            int info = 0;
            while (info < n) {
                IInterpreterInfo interpreter = e22[info];
                int[] nArray = AbstractShell.getAllShellIds();
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int id = nArray[n3];
                    AbstractShell.stopServerShell(interpreter, id);
                    ++n3;
                }
                ++info;
            }
            IInterpreterManagerListener[] iInterpreterManagerListenerArray = managerListeners = (IInterpreterManagerListener[])this.listeners.getListeners();
            int e22 = managerListeners.length;
            n = 0;
            while (n < e22) {
                IInterpreterManagerListener iInterpreterManagerListener = iInterpreterManagerListenerArray[n];
                iInterpreterManagerListener.afterSetInfos((IInterpreterManager)this, interpreterInfos);
                ++n;
            }
        }
        finally {
            AbstractShell.restartAllShells();
        }
        PydevPlugin plugin = PydevPlugin.getDefault();
        if (plugin != null && interpreterNamesToRestore != null && interpreterNamesToRestore.size() > 0) {
            SyncSystemModulesManagerScheduler syncScheduler = plugin.syncScheduler;
            ArrayList<IInterpreterInfo> lst = new ArrayList<IInterpreterInfo>(interpreterNamesToRestore.size());
            IInterpreterInfo[] iInterpreterInfoArray = interpreterInfos;
            int n = interpreterInfos.length;
            int n4 = 0;
            while (n4 < n) {
                IInterpreterInfo info = iInterpreterInfoArray[n4];
                if (interpreterNamesToRestore.contains(info.getExecutableOrJar())) {
                    lst.add(info);
                }
                ++n4;
            }
            syncScheduler.addToCheck(this, lst.toArray(new IInterpreterInfo[lst.size()]));
        }
    }

    private void restorePythopathForInterpreters(IProgressMonitor monitor, Set<String> interpretersNamesToRestore) {
        Set<Map.Entry<String, InterpreterInfo>> entrySet = this.exeToInfo.entrySet();
        for (Map.Entry<String, InterpreterInfo> entry : entrySet) {
            String interpreterExecutableOrJar = entry.getKey();
            if (interpretersNamesToRestore != null && !interpretersNamesToRestore.contains(interpreterExecutableOrJar)) continue;
            InterpreterInfo info = entry.getValue();
            info.restorePythonpath(monitor);
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_observer");
            for (IInterpreterObserver observer : participants) {
                try {
                    observer.notifyDefaultPythonpathRestored(this, interpreterExecutableOrJar, monitor);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePythopathForNatures(IProgressMonitor monitor) {
        List<IPythonNature> pythonNatures;
        IInterpreterInfo defaultInterpreterInfo;
        try {
            defaultInterpreterInfo = this.getDefaultInterpreterInfo(false);
        }
        catch (NotConfiguredInterpreterException notConfiguredInterpreterException) {
            defaultInterpreterInfo = null;
        }
        FastStringBuffer buf = new FastStringBuffer();
        try {
            pythonNatures = PythonNature.getAllPythonNatures();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        for (IPythonNature nature : pythonNatures) {
            try {
                Properties stringSubstitutionVariables;
                IInterpreterInfo info;
                if (this.getInterpreterType() != nature.getInterpreterType()) continue;
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                String complete = String.valueOf(pythonPathNature.getProjectExternalSourcePath(false)) + pythonPathNature.getProjectSourcePath(false);
                PythonNature n = (PythonNature)nature;
                String projectInterpreterName = n.getProjectInterpreterName();
                if ("Default".equals(projectInterpreterName)) {
                    info = defaultInterpreterInfo;
                } else {
                    Object object = this.lock;
                    synchronized (object) {
                        info = this.exeToInfo.get(projectInterpreterName);
                    }
                }
                boolean makeCompleteRebuild = false;
                if (info != null && (stringSubstitutionVariables = info.getStringSubstitutionVariables()) != null) {
                    Enumeration<Object> keys = stringSubstitutionVariables.keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        buf.clear();
                        buf.append("${");
                        buf.append(key.toString());
                        buf.append("}");
                        if (complete.indexOf(buf.toString()) == -1) continue;
                        makeCompleteRebuild = true;
                        break;
                    }
                }
                if (!makeCompleteRebuild) {
                    if (nature instanceof PythonNature) {
                        ((PythonNature)nature).clearCaches(true);
                    }
                    PythonNatureListenersManager.notifyPythonPathRebuilt(nature.getProject(), nature);
                    continue;
                }
                nature.rebuildPath();
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
    }

    private static class ConfigureInterpreterJob
    extends UIJob {
        private volatile Set<AbstractInterpreterManager> interpreters = new HashSet<AbstractInterpreterManager>();

        public void addInterpreter(AbstractInterpreterManager abstractInterpreterManager) {
            this.interpreters.add(abstractInterpreterManager);
        }

        public ConfigureInterpreterJob() {
            super("Configure interpreter");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Set<AbstractInterpreterManager> current = this.interpreters;
            this.interpreters = new HashSet<AbstractInterpreterManager>();
            for (AbstractInterpreterManager m : current) {
                try {
                    m.getDefaultInterpreterInfo(false);
                }
                catch (NotConfiguredInterpreterException notConfiguredInterpreterException) {
                    IInterpreterProviderFactory.InterpreterType interpreterType;
                    int ret = PyDialogHelpers.openQuestionConfigureInterpreter(m);
                    if (ret == 0) {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)m.getPreferencesPageId(), null, null);
                        dialog.open();
                        continue;
                    }
                    if (ret == -1) continue;
                    switch (m.getInterpreterType()) {
                        case 1: {
                            interpreterType = IInterpreterProviderFactory.InterpreterType.JYTHON;
                            break;
                        }
                        case 2: {
                            interpreterType = IInterpreterProviderFactory.InterpreterType.IRONPYTHON;
                            break;
                        }
                        default: {
                            interpreterType = IInterpreterProviderFactory.InterpreterType.PYTHON;
                        }
                    }
                    boolean advanced = ret == 2;
                    EditorUtils.getShell();
                    AutoConfigMaker a = new AutoConfigMaker(interpreterType, advanced, null, null);
                    a.autoConfigSingleApply(null);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

